/*
 * Decompiled with CFR 0.152.
 */
package com.xiaofeng.flowlayoutmanager;

import android.graphics.Point;
import androidx.recyclerview.widget.RecyclerView;
import com.xiaofeng.flowlayoutmanager.FlowLayoutOptions;
import com.xiaofeng.flowlayoutmanager.LayoutContext;

public class LayoutHelper {
    RecyclerView.LayoutManager layoutManager;
    RecyclerView recyclerView;

    public LayoutHelper(RecyclerView.LayoutManager layoutManager, RecyclerView recyclerView) {
        this.layoutManager = layoutManager;
        this.recyclerView = recyclerView;
    }

    public static boolean hasItemsPerLineLimit(FlowLayoutOptions layoutOptions) {
        return layoutOptions.itemsPerLine > 0;
    }

    public static boolean shouldStartNewline(int x, int childWidth, int leftEdge, int rightEdge, LayoutContext layoutContext) {
        if (LayoutHelper.hasItemsPerLineLimit(layoutContext.layoutOptions) && layoutContext.currentLineItemCount == layoutContext.layoutOptions.itemsPerLine) {
            return true;
        }
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return x - childWidth < leftEdge;
            }
        }
        return x + childWidth > rightEdge;
    }

    public int leftVisibleEdge() {
        return this.recyclerView.getPaddingLeft();
    }

    public int rightVisibleEdge() {
        return this.layoutManager.getWidth() - this.layoutManager.getPaddingRight();
    }

    public int visibleAreaWidth() {
        return this.rightVisibleEdge() - this.leftVisibleEdge();
    }

    public int topVisibleEdge() {
        return this.layoutManager.getPaddingTop();
    }

    public int bottomVisibleEdge() {
        return this.layoutManager.getHeight() - this.layoutManager.getPaddingBottom();
    }

    public Point layoutStartPoint(LayoutContext layoutContext) {
        switch (layoutContext.layoutOptions.alignment) {
            case RIGHT: {
                return new Point(this.rightVisibleEdge(), this.topVisibleEdge());
            }
        }
        return new Point(this.leftVisibleEdge(), this.topVisibleEdge());
    }
}

