/*
 * Decompiled with CFR 0.152.
 */
package jp.shts.android.storiesprogressview;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import jp.shts.android.storiesprogressview.R;

final class PausableProgressBar
extends FrameLayout {
    private static final int DEFAULT_PROGRESS_DURATION = 2000;
    private View frontProgressView;
    private View maxProgressView;
    private PausableScaleAnimation animation;
    private long duration = 2000L;
    private Callback callback;

    public PausableProgressBar(Context context) {
        this(context, null);
    }

    public PausableProgressBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PausableProgressBar(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.pausable_progress, (ViewGroup)this);
        this.frontProgressView = this.findViewById(R.id.front_progress);
        this.maxProgressView = this.findViewById(R.id.max_progress);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setCallback(@NonNull Callback callback) {
        this.callback = callback;
    }

    void setMax() {
        this.finishProgress(true);
    }

    void setMin() {
        this.finishProgress(false);
    }

    void setMinWithoutCallback() {
        this.maxProgressView.setBackgroundResource(R.color.progress_secondary);
        this.maxProgressView.setVisibility(0);
        if (this.animation != null) {
            this.animation.setAnimationListener(null);
            this.animation.cancel();
        }
    }

    void setMaxWithoutCallback() {
        this.maxProgressView.setBackgroundResource(R.color.progress_max_active);
        this.maxProgressView.setVisibility(0);
        if (this.animation != null) {
            this.animation.setAnimationListener(null);
            this.animation.cancel();
        }
    }

    private void finishProgress(boolean isMax) {
        if (isMax) {
            this.maxProgressView.setBackgroundResource(R.color.progress_max_active);
        }
        this.maxProgressView.setVisibility(isMax ? 0 : 8);
        if (this.animation != null) {
            this.animation.setAnimationListener(null);
            this.animation.cancel();
            if (this.callback != null) {
                this.callback.onFinishProgress();
            }
        }
    }

    public void startProgress() {
        this.maxProgressView.setVisibility(8);
        this.animation = new PausableScaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, 1, 0.0f);
        this.animation.setDuration(this.duration);
        this.animation.setInterpolator((Interpolator)new LinearInterpolator());
        this.animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                PausableProgressBar.this.frontProgressView.setVisibility(0);
                if (PausableProgressBar.this.callback != null) {
                    PausableProgressBar.this.callback.onStartProgress();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (PausableProgressBar.this.callback != null) {
                    PausableProgressBar.this.callback.onFinishProgress();
                }
            }
        });
        this.animation.setFillAfter(true);
        this.frontProgressView.startAnimation((Animation)this.animation);
    }

    public void pauseProgress() {
        if (this.animation != null) {
            this.animation.pause();
        }
    }

    public void resumeProgress() {
        if (this.animation != null) {
            this.animation.resume();
        }
    }

    void clear() {
        if (this.animation != null) {
            this.animation.setAnimationListener(null);
            this.animation.cancel();
            this.animation = null;
        }
    }

    private class PausableScaleAnimation
    extends ScaleAnimation {
        private long mElapsedAtPause;
        private boolean mPaused;

        PausableScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
            super(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
            this.mElapsedAtPause = 0L;
            this.mPaused = false;
        }

        public boolean getTransformation(long currentTime, Transformation outTransformation, float scale) {
            if (this.mPaused && this.mElapsedAtPause == 0L) {
                this.mElapsedAtPause = currentTime - this.getStartTime();
            }
            if (this.mPaused) {
                this.setStartTime(currentTime - this.mElapsedAtPause);
            }
            return super.getTransformation(currentTime, outTransformation, scale);
        }

        void pause() {
            if (this.mPaused) {
                return;
            }
            this.mElapsedAtPause = 0L;
            this.mPaused = true;
        }

        void resume() {
            this.mPaused = false;
        }
    }

    static interface Callback {
        public void onStartProgress();

        public void onFinishProgress();
    }
}

