/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.distribute.impl.jpa;

import com.github.shoothzj.distribute.api.LockException;
import com.github.shoothzj.distribute.impl.common.BaseLockImpl;
import com.github.shoothzj.distribute.impl.jpa.domain.LockPo;
import com.github.shoothzj.distribute.impl.jpa.repo.LockRepo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JpaLockImpl
extends BaseLockImpl {
    private static final Logger log = LoggerFactory.getLogger(JpaLockImpl.class);
    @Autowired
    private LockRepo lockRepo;

    public String requireLock(String key, long nanoseconds) throws LockException {
        int affectRow;
        String lockId = UUID.randomUUID().toString();
        Optional<LockPo> lockOp = this.lockRepo.findByLockKey(key);
        LocalDateTime nowTime = LocalDateTime.now(ZoneId.of("UTC"));
        LocalDateTime expireTime = nowTime.plusNanos(nanoseconds);
        if (!lockOp.isPresent()) {
            this.lockRepo.save(new LockPo(key, lockId, expireTime));
            return lockId;
        }
        LockPo lockPo = lockOp.get();
        if (lockPo.getExpireTime().isBefore(nowTime) && (affectRow = this.lockRepo.findAndModify(key, lockPo.getLockId(), lockId, expireTime)) == 1) {
            return lockId;
        }
        throw new LockException("get lock failed");
    }

    public void releaseLock(String lockKey, String lockId) {
        this.lockRepo.deleteByLockKeyAndLockId(lockKey, lockId);
    }
}

