/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.webrtc.BaseBitrateAdjuster;
import org.webrtc.BitrateAdjuster;
import org.webrtc.DynamicBitrateAdjuster;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.FramerateBitrateAdjuster;
import org.webrtc.H264Utils;
import org.webrtc.HardwareVideoEncoder;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.Predicate;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecMimeType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderSupportedCallback;

public class CustomHardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "CustomHardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    @Nullable
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    @Nullable
    private final VideoEncoderSupportedCallback videoEncoderSupportedCallback;

    public CustomHardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, @Nullable VideoEncoderSupportedCallback videoEncoderSupportedCallback) {
        this(sharedContext, enableIntelVp8Encoder, enableH264HighProfile, null, videoEncoderSupportedCallback);
    }

    public CustomHardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate, @Nullable VideoEncoderSupportedCallback videoEncoderSupportedCallback) {
        if (sharedContext instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)sharedContext;
        } else {
            Logging.w((String)TAG, (String)"No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = enableIntelVp8Encoder;
        this.enableH264HighProfile = enableH264HighProfile;
        this.codecAllowedPredicate = codecAllowedPredicate;
        this.videoEncoderSupportedCallback = videoEncoderSupportedCallback;
    }

    @Deprecated
    public CustomHardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, enableIntelVp8Encoder, enableH264HighProfile, null);
    }

    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecMimeType type = VideoCodecMimeType.valueOf((String)input.name);
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        String mime = type.mimeType();
        Integer surfaceColorFormat = MediaCodecUtils.selectColorFormat((int[])MediaCodecUtils.TEXTURE_COLOR_FORMATS, (MediaCodecInfo.CodecCapabilities)info.getCapabilitiesForType(mime));
        Integer yuvColorFormat = MediaCodecUtils.selectColorFormat((int[])MediaCodecUtils.ENCODER_COLOR_FORMATS, (MediaCodecInfo.CodecCapabilities)info.getCapabilitiesForType(mime));
        if (type == VideoCodecMimeType.H264) {
            boolean isHighProfile = H264Utils.isSameH264Profile((Map)input.params, (Map)MediaCodecUtils.getCodecProperties((VideoCodecMimeType)type, (boolean)true));
            boolean isBaselineProfile = H264Utils.isSameH264Profile((Map)input.params, (Map)MediaCodecUtils.getCodecProperties((VideoCodecMimeType)type, (boolean)false));
            if (!isHighProfile && !isBaselineProfile) {
                return null;
            }
            if (isHighProfile && !this.isH264HighProfileSupported(info)) {
                return null;
            }
        }
        return new HardwareVideoEncoder((MediaCodecWrapperFactory)new MediaCodecWrapperFactoryImpl(), codecName, type, surfaceColorFormat, yuvColorFormat, input.params, this.getKeyFrameIntervalSec(type), this.getForcedKeyFrameIntervalMs(type, codecName), this.createBitrateAdjuster(type, codecName), this.sharedContext);
    }

    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecMimeType type : new VideoCodecMimeType[]{VideoCodecMimeType.VP8, VideoCodecMimeType.VP9, VideoCodecMimeType.H264}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecMimeType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties((VideoCodecMimeType)type, (boolean)true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties((VideoCodecMimeType)type, (boolean)false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[0]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecMimeType type) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e((String)TAG, (String)"Cannot retrieve encoder codec info", (Throwable)e);
            }
            if (info == null || !info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecMimeType type) {
        if (!MediaCodecUtils.codecSupportsType((MediaCodecInfo)info, (VideoCodecMimeType)type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat((int[])MediaCodecUtils.ENCODER_COLOR_FORMATS, (MediaCodecInfo.CodecCapabilities)info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(info, type) && this.isMediaCodecAllowed(info);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecMimeType type) {
        switch (type) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return this.isHardwareSupportedInCurrentSdkH264(info);
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        boolean isSupported;
        String name = info.getName();
        boolean bl = isSupported = name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
        if (isSupported) {
            return true;
        }
        return this.videoEncoderSupportedCallback != null && this.videoEncoderSupportedCallback.isSupportedVp8(info);
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        boolean isSupported;
        String name = info.getName();
        boolean bl = isSupported = (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
        if (isSupported) {
            return true;
        }
        return this.videoEncoderSupportedCallback != null && this.videoEncoderSupportedCallback.isSupportedVp9(info);
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        boolean isSupported;
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        boolean bl = isSupported = name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21;
        if (isSupported) {
            return true;
        }
        return this.videoEncoderSupportedCallback != null && this.videoEncoderSupportedCallback.isSupportedH264(info);
    }

    private boolean isMediaCodecAllowed(MediaCodecInfo info) {
        if (this.codecAllowedPredicate == null) {
            return true;
        }
        return this.codecAllowedPredicate.test((Object)info);
    }

    private int getKeyFrameIntervalSec(VideoCodecMimeType type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecMimeType " + type);
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecMimeType type, String codecName) {
        if (type == VideoCodecMimeType.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecMimeType type, String codecName) {
        if (codecName.startsWith("OMX.Exynos.")) {
            if (type == VideoCodecMimeType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && info.getName().startsWith("OMX.Exynos.");
    }
}

