/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.shimmer;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.cooltechworks.views.shimmer.R;

public class ShimmerFrameLayout
extends FrameLayout {
    private static final String TAG = "ShimmerFrameLayout";
    private static final PorterDuffXfermode DST_IN_PORTER_DUFF_XFERMODE = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Paint mAlphaPaint;
    private Paint mMaskPaint;
    private Mask mMask;
    private MaskTranslation mMaskTranslation;
    private Bitmap mRenderMaskBitmap;
    private Bitmap mRenderUnmaskBitmap;
    private boolean mAutoStart;
    private int mDuration;
    private int mRepeatCount;
    private int mRepeatDelay;
    private int mRepeatMode;
    private int mMaskOffsetX;
    private int mMaskOffsetY;
    private boolean mAnimationStarted;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    protected ValueAnimator mAnimator;
    protected Bitmap mMaskBitmap;

    public ShimmerFrameLayout(Context context) {
        this(context, null, 0);
    }

    public ShimmerFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.mMask = new Mask();
        this.mAlphaPaint = new Paint();
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setAntiAlias(true);
        this.mMaskPaint.setDither(true);
        this.mMaskPaint.setFilterBitmap(true);
        this.mMaskPaint.setXfermode((Xfermode)DST_IN_PORTER_DUFF_XFERMODE);
        this.useDefaults();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShimmerFrameLayout, 0, 0);
            try {
                if (a.hasValue(R.styleable.ShimmerFrameLayout_auto_start)) {
                    this.setAutoStart(a.getBoolean(R.styleable.ShimmerFrameLayout_auto_start, false));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_base_alpha)) {
                    this.setBaseAlpha(a.getFloat(R.styleable.ShimmerFrameLayout_base_alpha, 0.0f));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_duration)) {
                    this.setDuration(a.getInt(R.styleable.ShimmerFrameLayout_duration, 0));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_repeat_count)) {
                    this.setRepeatCount(a.getInt(R.styleable.ShimmerFrameLayout_repeat_count, 0));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_repeat_delay)) {
                    this.setRepeatDelay(a.getInt(R.styleable.ShimmerFrameLayout_repeat_delay, 0));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_repeat_mode)) {
                    this.setRepeatMode(a.getInt(R.styleable.ShimmerFrameLayout_repeat_mode, 0));
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_angle)) {
                    int angle = a.getInt(R.styleable.ShimmerFrameLayout_angle, 0);
                    switch (angle) {
                        default: {
                            this.mMask.angle = MaskAngle.CW_0;
                            break;
                        }
                        case 90: {
                            this.mMask.angle = MaskAngle.CW_90;
                            break;
                        }
                        case 180: {
                            this.mMask.angle = MaskAngle.CW_180;
                            break;
                        }
                        case 270: {
                            this.mMask.angle = MaskAngle.CW_270;
                        }
                    }
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_shape)) {
                    int shape = a.getInt(R.styleable.ShimmerFrameLayout_shape, 0);
                    switch (shape) {
                        default: {
                            this.mMask.shape = MaskShape.LINEAR;
                            break;
                        }
                        case 2: {
                            this.mMask.shape = MaskShape.RADIAL;
                        }
                    }
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_dropoff)) {
                    this.mMask.dropoff = a.getFloat(R.styleable.ShimmerFrameLayout_dropoff, 0.0f);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_fixed_width)) {
                    this.mMask.fixedWidth = a.getDimensionPixelSize(R.styleable.ShimmerFrameLayout_fixed_width, 0);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_fixed_height)) {
                    this.mMask.fixedHeight = a.getDimensionPixelSize(R.styleable.ShimmerFrameLayout_fixed_height, 0);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_intensity)) {
                    this.mMask.intensity = a.getFloat(R.styleable.ShimmerFrameLayout_intensity, 0.0f);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_relative_width)) {
                    this.mMask.relativeWidth = a.getFloat(R.styleable.ShimmerFrameLayout_relative_width, 0.0f);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_relative_height)) {
                    this.mMask.relativeHeight = a.getFloat(R.styleable.ShimmerFrameLayout_relative_height, 0.0f);
                }
                if (a.hasValue(R.styleable.ShimmerFrameLayout_tilt)) {
                    this.mMask.tilt = a.getFloat(R.styleable.ShimmerFrameLayout_tilt, 0.0f);
                }
            }
            finally {
                a.recycle();
            }
        }
    }

    public void useDefaults() {
        this.setAutoStart(false);
        this.setDuration(1000);
        this.setRepeatCount(-1);
        this.setRepeatDelay(0);
        this.setRepeatMode(1);
        this.mMask.angle = MaskAngle.CW_0;
        this.mMask.shape = MaskShape.LINEAR;
        this.mMask.dropoff = 0.5f;
        this.mMask.fixedWidth = 0;
        this.mMask.fixedHeight = 0;
        this.mMask.intensity = 0.0f;
        this.mMask.relativeWidth = 1.0f;
        this.mMask.relativeHeight = 1.0f;
        this.mMask.tilt = 20.0f;
        this.mMaskTranslation = new MaskTranslation();
        this.setBaseAlpha(0.3f);
        this.resetAll();
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart = autoStart;
        this.resetAll();
    }

    public float getBaseAlpha() {
        return (float)this.mAlphaPaint.getAlpha() / 255.0f;
    }

    public void setBaseAlpha(float alpha) {
        this.mAlphaPaint.setAlpha((int)(ShimmerFrameLayout.clamp(0.0f, 1.0f, alpha) * 255.0f));
        this.resetAll();
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.resetAll();
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.mRepeatCount = repeatCount;
        this.resetAll();
    }

    public int getRepeatDelay() {
        return this.mRepeatDelay;
    }

    public void setRepeatDelay(int repeatDelay) {
        this.mRepeatDelay = repeatDelay;
        this.resetAll();
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
        this.resetAll();
    }

    public MaskShape getMaskShape() {
        return this.mMask.shape;
    }

    public void setMaskShape(MaskShape shape) {
        this.mMask.shape = shape;
        this.resetAll();
    }

    public MaskAngle getAngle() {
        return this.mMask.angle;
    }

    public void setAngle(MaskAngle angle) {
        this.mMask.angle = angle;
        this.resetAll();
    }

    public float getDropoff() {
        return this.mMask.dropoff;
    }

    public void setDropoff(float dropoff) {
        this.mMask.dropoff = dropoff;
        this.resetAll();
    }

    public int getFixedWidth() {
        return this.mMask.fixedWidth;
    }

    public void setFixedWidth(int fixedWidth) {
        this.mMask.fixedWidth = fixedWidth;
        this.resetAll();
    }

    public int getFixedHeight() {
        return this.mMask.fixedHeight;
    }

    public void setFixedHeight(int fixedHeight) {
        this.mMask.fixedHeight = fixedHeight;
        this.resetAll();
    }

    public float getIntensity() {
        return this.mMask.intensity;
    }

    public void setIntensity(float intensity) {
        this.mMask.intensity = intensity;
        this.resetAll();
    }

    public float getRelativeWidth() {
        return this.mMask.relativeWidth;
    }

    public void setRelativeWidth(int relativeWidth) {
        this.mMask.relativeWidth = relativeWidth;
        this.resetAll();
    }

    public float getRelativeHeight() {
        return this.mMask.relativeHeight;
    }

    public void setRelativeHeight(int relativeHeight) {
        this.mMask.relativeHeight = relativeHeight;
        this.resetAll();
    }

    public float getTilt() {
        return this.mMask.tilt;
    }

    public void setTilt(float tilt) {
        this.mMask.tilt = tilt;
        this.resetAll();
    }

    public void startShimmerAnimation() {
        if (this.mAnimationStarted) {
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.mAnimationStarted = true;
    }

    public void stopShimmerAnimation() {
        if (this.mAnimator != null) {
            this.mAnimator.end();
            this.mAnimator.removeAllUpdateListeners();
            this.mAnimator.cancel();
        }
        this.mAnimator = null;
        this.mAnimationStarted = false;
    }

    public boolean isAnimationStarted() {
        return this.mAnimationStarted;
    }

    private void setMaskOffsetX(int maskOffsetX) {
        if (this.mMaskOffsetX == maskOffsetX) {
            return;
        }
        this.mMaskOffsetX = maskOffsetX;
        this.invalidate();
    }

    private void setMaskOffsetY(int maskOffsetY) {
        if (this.mMaskOffsetY == maskOffsetY) {
            return;
        }
        this.mMaskOffsetY = maskOffsetY;
        this.invalidate();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mGlobalLayoutListener == null) {
            this.mGlobalLayoutListener = this.getLayoutListener();
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
    }

    private ViewTreeObserver.OnGlobalLayoutListener getLayoutListener() {
        return new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                boolean animationStarted = ShimmerFrameLayout.this.mAnimationStarted;
                ShimmerFrameLayout.this.resetAll();
                if (ShimmerFrameLayout.this.mAutoStart || animationStarted) {
                    ShimmerFrameLayout.this.startShimmerAnimation();
                }
            }
        };
    }

    protected void onDetachedFromWindow() {
        this.stopShimmerAnimation();
        if (this.mGlobalLayoutListener != null) {
            this.getViewTreeObserver().removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
            this.mGlobalLayoutListener = null;
        }
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.mAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
            return;
        }
        this.dispatchDrawUsingBitmap(canvas);
    }

    private static float clamp(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    private boolean dispatchDrawUsingBitmap(Canvas canvas) {
        Bitmap unmaskBitmap = this.tryObtainRenderUnmaskBitmap();
        Bitmap maskBitmap = this.tryObtainRenderMaskBitmap();
        if (unmaskBitmap == null || maskBitmap == null) {
            return false;
        }
        this.drawUnmasked(new Canvas(unmaskBitmap));
        canvas.drawBitmap(unmaskBitmap, 0.0f, 0.0f, this.mAlphaPaint);
        this.drawMasked(new Canvas(maskBitmap));
        canvas.drawBitmap(maskBitmap, 0.0f, 0.0f, null);
        return true;
    }

    private Bitmap tryObtainRenderUnmaskBitmap() {
        if (this.mRenderUnmaskBitmap == null) {
            this.mRenderUnmaskBitmap = this.tryCreateRenderBitmap();
        }
        return this.mRenderUnmaskBitmap;
    }

    private Bitmap tryObtainRenderMaskBitmap() {
        if (this.mRenderMaskBitmap == null) {
            this.mRenderMaskBitmap = this.tryCreateRenderBitmap();
        }
        return this.mRenderMaskBitmap;
    }

    private Bitmap tryCreateRenderBitmap() {
        int width = this.getWidth();
        int height = this.getHeight();
        try {
            return ShimmerFrameLayout.createBitmapAndGcIfNecessary(width, height);
        }
        catch (OutOfMemoryError e) {
            String logMessage = "ShimmerFrameLayout failed to create working bitmap";
            StringBuilder logMessageStringBuilder = new StringBuilder(logMessage);
            logMessageStringBuilder.append(" (width = ");
            logMessageStringBuilder.append(width);
            logMessageStringBuilder.append(", height = ");
            logMessageStringBuilder.append(height);
            logMessageStringBuilder.append(")\n\n");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                logMessageStringBuilder.append(stackTraceElement.toString());
                logMessageStringBuilder.append("\n");
            }
            logMessage = logMessageStringBuilder.toString();
            Log.d((String)TAG, (String)logMessage);
            return null;
        }
    }

    private void drawUnmasked(Canvas renderCanvas) {
        renderCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        super.dispatchDraw(renderCanvas);
    }

    private void drawMasked(Canvas renderCanvas) {
        Bitmap maskBitmap = this.getMaskBitmap();
        if (maskBitmap == null) {
            return;
        }
        renderCanvas.clipRect(this.mMaskOffsetX, this.mMaskOffsetY, this.mMaskOffsetX + maskBitmap.getWidth(), this.mMaskOffsetY + maskBitmap.getHeight());
        renderCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        super.dispatchDraw(renderCanvas);
        renderCanvas.drawBitmap(maskBitmap, (float)this.mMaskOffsetX, (float)this.mMaskOffsetY, this.mMaskPaint);
    }

    private void resetAll() {
        this.stopShimmerAnimation();
        this.resetMaskBitmap();
        this.resetRenderedView();
    }

    private void resetMaskBitmap() {
        if (this.mMaskBitmap != null) {
            this.mMaskBitmap.recycle();
            this.mMaskBitmap = null;
        }
    }

    private void resetRenderedView() {
        if (this.mRenderUnmaskBitmap != null) {
            this.mRenderUnmaskBitmap.recycle();
            this.mRenderUnmaskBitmap = null;
        }
        if (this.mRenderMaskBitmap != null) {
            this.mRenderMaskBitmap.recycle();
            this.mRenderMaskBitmap = null;
        }
    }

    private Bitmap getMaskBitmap() {
        RadialGradient gradient;
        if (this.mMaskBitmap != null) {
            return this.mMaskBitmap;
        }
        int width = this.mMask.maskWidth(this.getWidth());
        int height = this.mMask.maskHeight(this.getHeight());
        this.mMaskBitmap = ShimmerFrameLayout.createBitmapAndGcIfNecessary(width, height);
        Canvas canvas = new Canvas(this.mMaskBitmap);
        switch (this.mMask.shape) {
            default: {
                int y2;
                int x2;
                int y1;
                int x1;
                switch (this.mMask.angle) {
                    default: {
                        x1 = 0;
                        y1 = 0;
                        x2 = width;
                        y2 = 0;
                        break;
                    }
                    case CW_90: {
                        x1 = 0;
                        y1 = 0;
                        x2 = 0;
                        y2 = height;
                        break;
                    }
                    case CW_180: {
                        x1 = width;
                        y1 = 0;
                        x2 = 0;
                        y2 = 0;
                        break;
                    }
                    case CW_270: {
                        x1 = 0;
                        y1 = height;
                        x2 = 0;
                        y2 = 0;
                    }
                }
                gradient = new LinearGradient((float)x1, (float)y1, (float)x2, (float)y2, this.mMask.getGradientColors(), this.mMask.getGradientPositions(), Shader.TileMode.REPEAT);
                break;
            }
            case RADIAL: {
                int x = width / 2;
                int y = height / 2;
                gradient = new RadialGradient((float)x, (float)y, (float)((double)Math.max(width, height) / Math.sqrt(2.0)), this.mMask.getGradientColors(), this.mMask.getGradientPositions(), Shader.TileMode.REPEAT);
                break;
            }
        }
        canvas.rotate(this.mMask.tilt, (float)(width / 2), (float)(height / 2));
        Paint paint = new Paint();
        paint.setShader((Shader)gradient);
        int padding = (int)(Math.sqrt(2.0) * (double)Math.max(width, height)) / 2;
        canvas.drawRect((float)(-padding), (float)(-padding), (float)(width + padding), (float)(height + padding), paint);
        return this.mMaskBitmap;
    }

    private Animator getShimmerAnimation() {
        if (this.mAnimator != null) {
            return this.mAnimator;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.mMask.shape) {
            default: 
        }
        switch (this.mMask.angle) {
            default: {
                this.mMaskTranslation.set(-width, 0, width, 0);
                break;
            }
            case CW_90: {
                this.mMaskTranslation.set(0, -height, 0, height);
                break;
            }
            case CW_180: {
                this.mMaskTranslation.set(width, 0, -width, 0);
                break;
            }
            case CW_270: {
                this.mMaskTranslation.set(0, height, 0, -height);
            }
        }
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f + (float)this.mRepeatDelay / (float)this.mDuration});
        this.mAnimator.setDuration((long)(this.mDuration + this.mRepeatDelay));
        this.mAnimator.setRepeatCount(this.mRepeatCount);
        this.mAnimator.setRepeatMode(this.mRepeatMode);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = Math.max(0.0f, Math.min(1.0f, ((Float)animation.getAnimatedValue()).floatValue()));
                ShimmerFrameLayout.this.setMaskOffsetX((int)((float)((ShimmerFrameLayout)ShimmerFrameLayout.this).mMaskTranslation.fromX * (1.0f - value) + (float)((ShimmerFrameLayout)ShimmerFrameLayout.this).mMaskTranslation.toX * value));
                ShimmerFrameLayout.this.setMaskOffsetY((int)((float)((ShimmerFrameLayout)ShimmerFrameLayout.this).mMaskTranslation.fromY * (1.0f - value) + (float)((ShimmerFrameLayout)ShimmerFrameLayout.this).mMaskTranslation.toY * value));
            }
        });
        return this.mAnimator;
    }

    protected static Bitmap createBitmapAndGcIfNecessary(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    private static class MaskTranslation {
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MaskTranslation() {
        }

        public void set(int fromX, int fromY, int toX, int toY) {
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }

    private static class Mask {
        public MaskAngle angle;
        public float tilt;
        public float dropoff;
        public int fixedWidth;
        public int fixedHeight;
        public float intensity;
        public float relativeWidth;
        public float relativeHeight;
        public MaskShape shape;

        private Mask() {
        }

        public int maskWidth(int width) {
            return this.fixedWidth > 0 ? this.fixedWidth : (int)((float)width * this.relativeWidth);
        }

        public int maskHeight(int height) {
            return this.fixedHeight > 0 ? this.fixedHeight : (int)((float)height * this.relativeHeight);
        }

        public int[] getGradientColors() {
            switch (this.shape) {
                default: {
                    return new int[]{0, -16777216, -16777216, 0};
                }
                case RADIAL: 
            }
            return new int[]{-16777216, -16777216, 0};
        }

        public float[] getGradientPositions() {
            switch (this.shape) {
                default: {
                    return new float[]{Math.max((1.0f - this.intensity - this.dropoff) / 2.0f, 0.0f), Math.max((1.0f - this.intensity) / 2.0f, 0.0f), Math.min((1.0f + this.intensity) / 2.0f, 1.0f), Math.min((1.0f + this.intensity + this.dropoff) / 2.0f, 1.0f)};
                }
                case RADIAL: 
            }
            return new float[]{0.0f, Math.min(this.intensity, 1.0f), Math.min(this.intensity + this.dropoff, 1.0f)};
        }
    }

    public static enum MaskAngle {
        CW_0,
        CW_90,
        CW_180,
        CW_270;

    }

    public static enum MaskShape {
        LINEAR,
        RADIAL;

    }
}

