/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.filter.FileNameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassUtil {
    public static List<Class> getClasses(String modelPackage, String root) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(root.replaceAll("\\\\", "/"));
        buffer.append("/src/main/java/");
        buffer.append(modelPackage.replace(".", "/"));
        ArrayList<Class> list = new ArrayList<Class>();
        File entryFile = new File(buffer.toString());
        File[] eFiles = entryFile.listFiles(new FileNameFilter("java"));
        try {
            for (File ef : eFiles) {
                String alName = ef.getName();
                String name = alName.split("\\.")[0];
                Class<?> c = Class.forName(modelPackage + "." + name);
                list.add(c);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getClassName(String filePath, String simpleClassName) {
        String regex = "(class (.*?)\\{)|(interfase (.*?)\\{)";
        try {
            String curLine;
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            while ((curLine = reader.readLine()) != null) {
                String[] strs;
                Matcher matcher = Pattern.compile("(class (.*?)\\{)|(interfase (.*?)\\{)", 40).matcher(curLine);
                if (!matcher.find()) continue;
                String selector = matcher.group();
                for (String str : strs = selector.split(" ")) {
                    if (!str.contains(simpleClassName)) continue;
                    return str;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getSimpleTypeName(Object val) {
        if (val instanceof String) {
            return "string";
        }
        if (val instanceof Float) {
            return "float(float32)";
        }
        if (val instanceof Double) {
            return "double(float64)";
        }
        if (val instanceof Long) {
            return "long(int64)";
        }
        if (val instanceof Short) {
            return "short";
        }
        if (val instanceof Boolean) {
            return "boolean";
        }
        if (val instanceof Integer) {
            return "int32";
        }
        return "object";
    }
}

