/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.exception.XssException;
import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    boolean isUpData = false;

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        String contentType = servletRequest.getContentType();
        if (null != contentType) {
            this.isUpData = contentType.startsWith("multipart");
        }
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            if (ValidateUtil.isContainsForbiddenCharacter(values[i])) {
                throw new XssException("Contains illegal characters[From getParameterValues method]:" + values[i]);
            }
            encodedValues[i] = StringUtil.cleanXSS(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (ValidateUtil.isContainsForbiddenCharacter(value)) {
            throw new XssException("Contains illegal characters[From getParameter method]\uff1a" + value);
        }
        if (value == null) {
            return null;
        }
        return StringUtil.cleanXSS(value);
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isUpData) {
            return super.getInputStream();
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.inputHandlers(super.getInputStream()).getBytes("utf-8"));
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bais.read();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String inputHandlers(ServletInputStream servletInputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream, Charset.forName("UTF-8")));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (servletInputStream != null) {
                try {
                    servletInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (ValidateUtil.isContainsForbiddenCharacter(sb.toString())) {
            throw new XssException("Contains illegal characters[From getInputStream method]\uff1a" + sb.toString());
        }
        return StringUtil.cleanXSS(sb.toString());
    }

    private String cleanXSS(String value) {
        if (null == value) {
            return value;
        }
        value = value.replaceAll("\\+", "&#43;");
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("%", "&#37;");
        value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("%3C", "&lt;").replaceAll("%3E", "&gt;");
        value = value.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");
        value = value.replaceAll("%28", "&#40;").replaceAll("%29", "&#41;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("eval\\((.*)\\)", "\u975e\u6cd5\u5b57\u7b26");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", " ");
        return value;
    }
}

