/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.filter.AbstractUrlMatcher;
import com.power.common.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RewriteFilter
extends AbstractUrlMatcher
implements Filter {
    public static final String REWRITE_TO = "rewriteToUrl";
    public static final String REWRITE_PATTERNS = "urlPatterns";
    private Set<String> urlPatterns = null;
    private String rewriteTo = null;

    public void init(FilterConfig cfg) throws ServletException {
        this.rewriteTo = cfg.getInitParameter(REWRITE_TO);
        String exceptUrlString = cfg.getInitParameter(REWRITE_PATTERNS);
        this.urlPatterns = StringUtil.isNotEmpty(exceptUrlString) ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(exceptUrlString.split(";", 0)))) : Collections.emptySet();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String servletPath = request.getServletPath();
        String context = request.getContextPath();
        if (this.isMatches(this.urlPatterns, servletPath)) {
            req.getRequestDispatcher(context + "/" + this.rewriteTo).forward(req, resp);
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }
}

