/*
 * Decompiled with CFR 0.152.
 */
package com.buildware.widget.indeterm;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import com.buildware.widget.indeterm.IndeterminateCheckable;
import com.buildware.widget.indeterm.R;

class Utils {
    Utils() {
    }

    public static int applyAlpha(int color, float alpha) {
        return Color.argb((int)Math.round((float)Color.alpha((int)color) * alpha), (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public static Drawable tintDrawable(View view, @DrawableRes int drawable2) {
        if (!(view instanceof IndeterminateCheckable)) {
            throw new IllegalArgumentException("view must implement IndeterminateCheckable");
        }
        ColorStateList colorStateList = Utils.createIndetermColorStateList(view.getContext());
        Drawable d = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)view.getContext(), (int)drawable2));
        DrawableCompat.setTintList((Drawable)d, (ColorStateList)colorStateList);
        return d;
    }

    private static ColorStateList createIndetermColorStateList(Context context) {
        int[][] states = new int[][]{{-16842910}, {R.attr.state_indeterminate}, {0x10100A0}, StateSet.WILD_CARD};
        int normal = Utils.resolveColor(context, R.attr.colorControlNormal, -12303292);
        int activated = Utils.resolveColor(context, R.attr.colorControlActivated, -16711681);
        float disabledAlpha = Utils.resolveFloat(context, 0x1010033, 0.25f);
        int[] colors = new int[]{Utils.applyAlpha(normal, disabledAlpha), normal, activated, normal};
        return new ColorStateList((int[][])states, colors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveColor(Context context, @AttrRes int attr2, int defaultValue) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, defaultValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    private static float resolveFloat(Context context, @AttrRes int attr2, float defaultValue) {
        TypedValue val = new TypedValue();
        if (context.getTheme().resolveAttribute(attr2, val, true)) {
            return val.getFloat();
        }
        return defaultValue;
    }
}

