/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.util;

import java.util.Calendar;
import java.util.logging.Logger;

public final class CalendarUtil {
    protected static Logger log = Logger.getLogger(CalendarUtil.class.getCanonicalName());
    public static Calendar testData;

    public static Calendar getCurrentTime() {
        if (testData != null) {
            log.warning("Test data has been loaded...");
            Calendar result = CalendarUtil.deepCopy(testData);
            testData = null;
            return result;
        }
        return Calendar.getInstance();
    }

    public static Calendar getCurrentTruncDate() {
        return CalendarUtil.dateTrunc(CalendarUtil.getCurrentTime());
    }

    public static Integer getYear(Calendar calendar) {
        Integer year = calendar.get(1);
        return year;
    }

    public static Integer getMonth(Calendar calendar) {
        Integer month = calendar.get(2) + 1;
        return month;
    }

    public static Integer getDay(Calendar calendar) {
        Integer day = calendar.get(5);
        return day;
    }

    public static Integer getDayOfWeekNumber(Calendar cal) {
        return cal.get(7);
    }

    public static Integer get24Hour(Calendar calendar) {
        Integer hour = calendar.get(11);
        return hour;
    }

    public static Integer getMinute(Calendar calendar) {
        Integer minute = calendar.get(12);
        return minute;
    }

    public static Integer getSecond(Calendar calendar) {
        Integer second = calendar.get(13);
        return second;
    }

    public static Integer getMillisecond(Calendar calendar) {
        Integer millisecond = calendar.get(14);
        return millisecond;
    }

    public static Calendar getCalendar(String yyyy, String mm, String dd) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.valueOf(yyyy));
        cal.set(2, Integer.valueOf(mm) - 1);
        cal.set(5, Integer.valueOf(dd));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCalendar(int yyyy, int mm, int dd) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, yyyy);
        cal.set(2, mm - 1);
        cal.set(5, dd);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCalendar(String yyyy, String mm, String dd, String hh, String mi, String ss) {
        Calendar cal = CalendarUtil.getCalendar(yyyy, mm, dd);
        cal.set(11, Integer.valueOf(hh));
        cal.set(12, Integer.valueOf(mi));
        cal.set(13, Integer.valueOf(ss));
        return cal;
    }

    public static Calendar getCalendar(int yyyy, int mm, int dd, int hh, int mi, int ss) {
        Calendar cal = CalendarUtil.getCalendar(yyyy, mm, dd);
        cal.set(11, hh);
        cal.set(12, mi);
        cal.set(13, ss);
        return cal;
    }

    public static Calendar dateTrunc(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        Calendar date = (Calendar)calendar.clone();
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        return date;
    }

    public static boolean isFirstAfterSecond(Calendar first, Calendar second) {
        long secondValue;
        long firstValue = first.getTimeInMillis();
        return firstValue > (secondValue = second.getTimeInMillis());
    }

    public static Calendar deepCopy(Calendar src) {
        Calendar dest = Calendar.getInstance();
        dest.setTimeInMillis(src.getTimeInMillis());
        return dest;
    }

    public static Calendar addYears(Calendar src, int years) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(1, years);
        return dest;
    }

    public static Calendar addMonths(Calendar src, int months) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(2, months);
        return dest;
    }

    public static Calendar addDays(Calendar src, int days) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(5, days);
        return dest;
    }

    public static Calendar addHours(Calendar src, int hours) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(11, hours);
        return dest;
    }

    public static Calendar addMinutes(Calendar src, int minutes) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(12, minutes);
        return dest;
    }

    public static Calendar addSeconds(Calendar src, int seconds) {
        Calendar dest = CalendarUtil.deepCopy(src);
        dest.add(13, seconds);
        return dest;
    }

    public static Calendar getCalendar(long timeInMillis) {
        Calendar dest = Calendar.getInstance();
        dest.setTimeInMillis(timeInMillis);
        return dest;
    }

    public static String toYYYYMMDDHHMISS(Calendar calendar) {
        return String.format("%04d", CalendarUtil.getYear(calendar)) + String.format("%02d", CalendarUtil.getMonth(calendar)) + String.format("%02d", CalendarUtil.getDay(calendar)) + String.format("%02d", CalendarUtil.get24Hour(calendar)) + String.format("%02d", CalendarUtil.getMinute(calendar)) + String.format("%02d", CalendarUtil.getSecond(calendar));
    }
}

