/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.scheduler.impl;

import com.github.seratch.taskun.inject.TaskunInjector;
import com.github.seratch.taskun.scheduler.Taskun;
import com.github.seratch.taskun.scheduler.config.TaskunConfig;
import com.github.seratch.taskun.scheduler.crond.CronInvocation;
import com.github.seratch.taskun.scheduler.crond.RawCrontabLine;
import com.github.seratch.taskun.util.CalendarUtil;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TaskunImpl
implements Taskun {
    private ScheduledExecutorService executorService;
    private TaskunInjector taskunInjector;
    private CronInvocation cronInvocation = new CronInvocation();
    private String crontabFilepath;

    @Override
    public void initialize(TaskunConfig config) {
        final TaskunConfig config_ = config;
        this.initialize(new TaskunInjector(){

            @Override
            public TaskunConfig getTaskunConfig() {
                return config_;
            }

            @Override
            public <T> T inject(Class<?> clazz) {
                try {
                    return (T)clazz.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void initialize(TaskunInjector taskunInjector) {
        this.taskunInjector = taskunInjector;
        this.executorService = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private ThreadGroup threadGroup = new ThreadGroup("taskun-scheduler");

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.threadGroup, r);
                t.setDaemon(true);
                t.setName(t.getThreadGroup().getName() + "-worker-" + t.getId());
                return t;
            }
        });
    }

    @Override
    public void start() {
        this.invokeCronDaemon(this.taskunInjector, this.executorService);
    }

    @Override
    public void scheduleCronExecute(Runnable runnable, RawCrontabLine crontabLine) {
        this.cronInvocation.addCrontabLine(crontabLine);
    }

    @Override
    public void scheduleIntervalExecute(Runnable runnable, Calendar initialScheduledDate, long interval, TimeUnit timeUnit) {
        long initialDelay = this.getDelayValue(initialScheduledDate, timeUnit);
        this.executorService.scheduleAtFixedRate(runnable, initialDelay, interval, timeUnit);
    }

    @Override
    public void scheduleOnetime(Runnable runnable, Calendar scheduledDate) {
        Calendar currentDate = CalendarUtil.getCurrentTime();
        long delay = scheduledDate.getTimeInMillis() - currentDate.getTimeInMillis();
        this.executorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
    }

    @Override
    public void replaceCrontabFile(String crontabFilepath) {
        this.crontabFilepath = crontabFilepath;
    }

    @Override
    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isTerminated();
    }

    @Override
    public List<RawCrontabLine> getCurrentRawCrontabLines() {
        return this.cronInvocation.getCurrentRawCrontabLines();
    }

    @Override
    public long getLastCronInvocationTimeMillis() {
        return this.cronInvocation.getPreviousCheckedTimeMillis();
    }

    void invokeCronDaemon(TaskunInjector taskunInjector, ScheduledExecutorService executorService) {
        if (taskunInjector == null) {
            throw new IllegalStateException("Not initialized scheduler - the taskunInjector is null");
        }
        if (this.crontabFilepath != null) {
            this.cronInvocation.initialize(taskunInjector, executorService, this.crontabFilepath);
        } else {
            this.cronInvocation.initialize(taskunInjector, executorService);
        }
        Calendar cal = CalendarUtil.getCurrentTime();
        long currentTime = cal.getTimeInMillis();
        cal.add(12, 1);
        cal.set(13, 0);
        long initialInvocation = cal.getTimeInMillis();
        long initialDelay = initialInvocation - currentTime;
        executorService.scheduleAtFixedRate(this.cronInvocation, initialDelay, 60000L, TimeUnit.MILLISECONDS);
    }

    long getDelayValue(Calendar executeDate, TimeUnit timeUnit) {
        Calendar current = CalendarUtil.getCurrentTime();
        long delayMillis = executeDate.getTimeInMillis() - current.getTimeInMillis();
        if (timeUnit.equals((Object)TimeUnit.DAYS)) {
            return delayMillis / 1000L / 60L / 60L / 24L;
        }
        if (timeUnit.equals((Object)TimeUnit.HOURS)) {
            return delayMillis / 1000L / 60L / 60L;
        }
        if (timeUnit.equals((Object)TimeUnit.MICROSECONDS)) {
            return delayMillis * 1000L;
        }
        if (timeUnit.equals((Object)TimeUnit.MILLISECONDS)) {
            return delayMillis;
        }
        if (timeUnit.equals((Object)TimeUnit.MINUTES)) {
            return delayMillis / 1000L / 60L;
        }
        if (timeUnit.equals((Object)TimeUnit.NANOSECONDS)) {
            return delayMillis * 1000L * 1000L;
        }
        if (timeUnit.equals((Object)TimeUnit.SECONDS)) {
            return delayMillis / 1000L;
        }
        throw new UnsupportedOperationException("unexpected TimeUnit value");
    }
}

