/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.scheduler.crond;

import com.github.seratch.taskun.logging.TaskunLog;
import com.github.seratch.taskun.logging.TaskunLogUtilLoggerImpl;
import com.github.seratch.taskun.scheduler.crond.CronInvocation;
import com.github.seratch.taskun.scheduler.crond.Crontab;
import com.github.seratch.taskun.scheduler.crond.CrontabCommandClassNameElement;
import com.github.seratch.taskun.scheduler.crond.CrontabElement;
import com.github.seratch.taskun.scheduler.crond.RawCrontabLine;
import com.github.seratch.taskun.util.CalendarUtil;
import com.github.seratch.taskun.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CrontabParser {
    private Class<? extends TaskunLog> logImplClass = TaskunLogUtilLoggerImpl.class;
    private TaskunLog taskunLog = this.getLog(CronInvocation.class.getCanonicalName());

    public CrontabParser(Class<? extends TaskunLog> logImplClass) {
        this.logImplClass = logImplClass;
    }

    TaskunLog getLog() {
        return this.getLog(CronInvocation.class.getCanonicalName());
    }

    TaskunLog getLog(String name) {
        try {
            return this.logImplClass.getConstructor(String.class).newInstance(name);
        }
        catch (Throwable t) {
            return new TaskunLogUtilLoggerImpl(name);
        }
    }

    public Crontab parseLine(RawCrontabLine line) {
        Crontab crontab = new Crontab();
        String lineString = line.toString();
        if (lineString.equals("") || lineString.startsWith("#")) {
            return crontab;
        }
        crontab.rawLine = new RawCrontabLine(lineString);
        try {
            String[] elements = lineString.split("\\s+");
            if (elements[0].matches("interval:\\d+?sec")) {
                return this.getIntervalInvocationCrontab(crontab, elements);
            }
            return this.getBasicCrontab(crontab, elements);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.taskunLog.error("Invalid crontab expression...");
            throw new IllegalArgumentException("Invalid crontab expression...");
        }
    }

    public List<Integer> getFixedInvocations(int maxValue, CrontabElement crontabElement) {
        String element = crontabElement.toString();
        int begin = 0;
        int period = 1;
        int end = maxValue;
        ArrayList<Integer> invocations = new ArrayList<Integer>();
        String[] slashDelimited = element.split("/");
        if (element.equals("*")) {
            for (int i = 0; i <= maxValue; ++i) {
                invocations.add(i);
            }
            return invocations;
        }
        if (slashDelimited.length == 1 && element.matches("^[\\d,]+$")) {
            String[] commaDelimited = element.split(",");
            int len = commaDelimited.length;
            for (int i = 0; i < len; ++i) {
                invocations.add(Integer.valueOf(commaDelimited[i]));
            }
            return invocations;
        }
        if (slashDelimited.length == 2) {
            String leftSide = slashDelimited[0];
            if (leftSide.matches("^\\d+$")) {
                begin = Integer.valueOf(slashDelimited[0]);
            } else if (leftSide.matches("^\\d+?-\\d+$")) {
                String[] beginAndEnd = slashDelimited[0].split("-");
                begin = Integer.valueOf(beginAndEnd[0]);
                end = Integer.valueOf(beginAndEnd[1]);
            }
        } else {
            throw new IllegalArgumentException("Invalid crontab configuration value:" + element);
        }
        period = Integer.valueOf(slashDelimited[1]);
        for (int invocation = begin; invocation <= end; invocation += period) {
            invocations.add(invocation);
        }
        return invocations;
    }

    public long getNextInvocationTime(Calendar currentTime, Crontab crontab) {
        int dayOfWeek;
        int millisecond = CalendarUtil.getMillisecond(currentTime);
        if (millisecond > 0) {
            currentTime.set(14, 0);
            currentTime.add(13, 1);
        }
        int second = CalendarUtil.getSecond(currentTime);
        int minute = CalendarUtil.getMinute(currentTime);
        if (second > 0) {
            ++minute;
        }
        minute = crontab.minuteElement.isFixedValue() ? this.getFixedNextInvocationValue(minute, 59, crontab.minuteElement) : this.getFixedSameOrNextInvocationValue(minute, crontab.minuteFixedInvocations);
        int hour = CalendarUtil.get24Hour(currentTime);
        if (crontab.hourElement.isFixedValue()) {
            int newHour = crontab.hourElement.toInt();
            if (newHour > hour) {
                minute = crontab.minuteElement.isFixedValue() ? this.getFixedNextInvocationValue(minute, 59, crontab.minuteElement) : this.getFixedMinimumInvocationValue(crontab.minuteFixedInvocations);
            }
            hour = newHour;
        }
        crontab = this.replaceWildcardsOfMinuteOrHourValue(crontab);
        int day = CalendarUtil.getDay(currentTime);
        if (crontab.dayElement.isFixedValue()) {
            day = crontab.dayElement.toInt();
        }
        if ((dayOfWeek = this.getCrontabDayOfWeekNumber(currentTime)) >= 7) {
            dayOfWeek -= 7;
        }
        int month = CalendarUtil.getMonth(currentTime);
        if (crontab.monthElement.isFixedValue()) {
            month = crontab.monthElement.toInt();
        }
        int year = CalendarUtil.getYear(currentTime);
        Calendar nextInvocationTime = CalendarUtil.getCalendar(year, month, day, hour, minute, 0);
        boolean isMinuteModified = false;
        boolean isHourModified = false;
        boolean isDayModified = false;
        boolean isMonthModified = false;
        boolean isDayOfWeekPrior = true;
        int loopCounter = 0;
        if (crontab.dayOfWeekElement.isNotWildcard()) {
            while (nextInvocationTime.getTimeInMillis() <= currentTime.getTimeInMillis() || isDayOfWeekPrior && this.isDayOfWeekNotCameAt(crontab, nextInvocationTime, dayOfWeek)) {
                if (loopCounter >= 100) {
                    throw new IllegalStateException("Cannot get next invocation time of crontab scheduled task...");
                }
                if (isMinuteModified || crontab.minuteElement.isWildcard()) {
                    if (isHourModified || crontab.hourElement.isNotWildcard()) {
                        if (isHourModified || crontab.hourElement.isFixedValue()) {
                            if (isDayModified) {
                                if (isMonthModified || crontab.monthElement.isNotWildcard()) {
                                    if (isMonthModified || crontab.monthElement.isFixedValue()) {
                                        nextInvocationTime.add(1, 1);
                                    } else {
                                        nextInvocationTime.set(2, this.getFixedNextInvocationValue(month, 12, crontab.monthElement));
                                        isMonthModified = true;
                                    }
                                } else {
                                    nextInvocationTime.add(2, 1);
                                    isMonthModified = true;
                                }
                            } else {
                                boolean isNextInvocationNotInThisDate;
                                boolean isDayOfWeekNotContainedInCrontab = !this.isInvocationValueContainedInCrontabValue(dayOfWeek, 6, crontab.dayOfWeekElement);
                                boolean bl = isNextInvocationNotInThisDate = currentTime.getTimeInMillis() > nextInvocationTime.getTimeInMillis();
                                if (isDayOfWeekNotContainedInCrontab || isNextInvocationNotInThisDate) {
                                    int addDays = 0;
                                    int nextDayOfWeek = this.getFixedNextInvocationValue(dayOfWeek, 6, crontab.dayOfWeekElement);
                                    addDays = nextDayOfWeek > dayOfWeek ? nextDayOfWeek - dayOfWeek : nextDayOfWeek - dayOfWeek + 7;
                                    int addDaysByDayElement = this.getFixedNextInvocationValue(day, crontab.dayFixedInvocations) - day;
                                    if (addDaysByDayElement > 0 && addDaysByDayElement < addDays) {
                                        addDays = addDaysByDayElement;
                                        isDayOfWeekPrior = false;
                                    }
                                    nextInvocationTime.add(5, addDays);
                                }
                                isDayModified = true;
                            }
                        } else {
                            nextInvocationTime.set(11, this.getFixedNextInvocationValue(hour, 23, crontab.hourElement));
                            isHourModified = true;
                        }
                    } else {
                        nextInvocationTime.add(11, 1);
                        isHourModified = true;
                    }
                } else {
                    if (!isDayModified && hour >= CalendarUtil.get24Hour(currentTime)) {
                        nextInvocationTime.set(12, this.getFixedSameOrNextInvocationValue(minute, crontab.minuteFixedInvocations));
                    } else {
                        nextInvocationTime.set(12, this.getFixedMinimumInvocationValue(crontab.minuteFixedInvocations));
                    }
                    isMinuteModified = true;
                }
                ++loopCounter;
            }
        } else {
            while (isMonthModified && (!isDayModified || !isHourModified) || nextInvocationTime.getTimeInMillis() < currentTime.getTimeInMillis()) {
                if (loopCounter >= 100) {
                    throw new IllegalStateException("Cannot get next invocation time of crontab scheduled task...");
                }
                if (isHourModified || crontab.hourElement.isNotWildcard()) {
                    if (isHourModified || crontab.hourElement.isFixedValue()) {
                        if (isDayModified || crontab.dayElement.isNotWildcard()) {
                            if (isDayModified || crontab.dayElement.isFixedValue()) {
                                if (isMonthModified || crontab.monthElement.isNotWildcard()) {
                                    if (isMonthModified || crontab.monthElement.isFixedValue()) {
                                        nextInvocationTime.add(1, 1);
                                    } else {
                                        nextInvocationTime.set(2, this.getFixedNextInvocationValue(month, 12, crontab.monthElement));
                                        isHourModified = true;
                                        isDayModified = true;
                                        isMonthModified = true;
                                    }
                                } else {
                                    nextInvocationTime.add(2, 1);
                                    isHourModified = false;
                                    isDayModified = crontab.dayElement.isFixedValue();
                                    isMonthModified = true;
                                    hour = 0;
                                    if (this.isInvocationValueContainedInCrontabValue(0, 23, crontab.hourElement)) {
                                        nextInvocationTime.set(11, 0);
                                        isHourModified = true;
                                    }
                                    minute = 0;
                                    int newMinuteValue = 0;
                                    newMinuteValue = crontab.minuteElement.isFixedValue() ? this.getFixedNextInvocationValue(minute, 59, crontab.minuteElement) : this.getFixedNextInvocationValue(minute, crontab.minuteFixedInvocations);
                                    nextInvocationTime.set(12, newMinuteValue);
                                    nextInvocationTime.set(13, 0);
                                }
                            } else {
                                nextInvocationTime.set(5, this.getFixedNextInvocationValue(day, 31, crontab.dayElement));
                                isHourModified = true;
                                isDayModified = true;
                            }
                        } else {
                            nextInvocationTime.add(5, 1);
                            isHourModified = true;
                            isDayModified = true;
                        }
                    } else {
                        nextInvocationTime.set(11, this.getFixedNextInvocationValue(hour, 23, crontab.hourElement));
                        isHourModified = true;
                    }
                } else {
                    nextInvocationTime.add(11, 1);
                    isHourModified = true;
                }
                ++loopCounter;
            }
        }
        return nextInvocationTime.getTimeInMillis();
    }

    public Crontab replaceWildcardsOfMinuteOrHourValue(Crontab crontab) {
        int i;
        StringBuilder sb;
        if (crontab.minuteElement.isWildcard()) {
            sb = new StringBuilder();
            sb.append("0");
            for (i = 1; i < 60; ++i) {
                sb.append(",");
                sb.append(i);
            }
            crontab.minuteElement = new CrontabElement(sb.toString());
            crontab.minuteFixedInvocations = this.getFixedInvocations(59, crontab.minuteElement);
        }
        if (crontab.hourElement.isWildcard()) {
            sb = new StringBuilder();
            sb.append("0");
            for (i = 1; i < 24; ++i) {
                sb.append(",");
                sb.append(i);
            }
            crontab.hourElement = new CrontabElement(sb.toString());
            crontab.hourFixedInvocations = this.getFixedInvocations(23, crontab.hourElement);
        }
        return crontab;
    }

    public int getCrontabDayOfWeekNumber(Calendar cal) {
        return CalendarUtil.getDayOfWeekNumber(cal) - 1;
    }

    public int getFixedMinimumInvocationValue(List<Integer> fixedInvocations) {
        int dest = 60;
        if (fixedInvocations == null || fixedInvocations.size() == 0) {
            return 0;
        }
        for (int each : fixedInvocations) {
            if (dest <= each) continue;
            dest = each;
        }
        return dest;
    }

    public int getFixedSameOrNextInvocationValue(int currentValue, List<Integer> fixedInvocations) {
        if (fixedInvocations != null) {
            if (fixedInvocations.size() == 0) {
                throw new IllegalStateException("Invalid configuration...");
            }
            for (int fixed : fixedInvocations) {
                if (fixed < currentValue) continue;
                return fixed;
            }
            return fixedInvocations.get(0);
        }
        return currentValue;
    }

    public int getFixedNextInvocationValue(int currentValue, List<Integer> fixedInvocations) {
        if (fixedInvocations != null) {
            if (fixedInvocations.size() == 0) {
                throw new IllegalStateException("Invalid configuration...");
            }
            for (int fixed : fixedInvocations) {
                if (fixed <= currentValue) continue;
                return fixed;
            }
            return fixedInvocations.get(0);
        }
        return currentValue;
    }

    public int getFixedNextInvocationValue(int currentValue, int maxValue, CrontabElement element) {
        String elementValue = element.toString();
        if (elementValue.matches("^\\d+$")) {
            return Integer.valueOf(elementValue);
        }
        if (elementValue.contains("/") || elementValue.matches("^[\\d,]+$")) {
            List<Integer> fixedInvocations = this.getFixedInvocations(maxValue, element);
            for (int fixed : fixedInvocations) {
                if (fixed <= currentValue) continue;
                return fixed;
            }
            return fixedInvocations.get(0);
        }
        throw new IllegalArgumentException("Invalid crontab configuration value:" + elementValue);
    }

    public boolean isInvocationValueContainedInCrontabValue(int invocationValue, int maxValue, CrontabElement element) {
        String elementValue = element.toString();
        if (elementValue.matches("^\\d+$")) {
            return invocationValue == Integer.valueOf(elementValue);
        }
        if (elementValue.contains("/") || elementValue.matches("^[\\d,]+$")) {
            List<Integer> fixedInvocations = this.getFixedInvocations(maxValue, element);
            for (int fixed : fixedInvocations) {
                if (invocationValue != fixed) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Crontab getIntervalInvocationCrontab(Crontab crontab, String[] elements) {
        crontab.isIntervalInvocation = true;
        crontab.intervalSeconds = this.getLongValue(elements[0].split(":")[1]);
        crontab.initialIntervalSeconds = this.getLongValue(elements[1].split(":")[1]);
        crontab.commandClassName = this.getCommandClassNameElement(elements[2]);
        crontab.multiplicity = this.getMultiplicityOfCommandWorkers(elements[2]);
        if (elements.length == 4 && !StringUtil.isEmpty(elements[3])) {
            String[] servers = elements[3].split(",");
            crontab.namedServers = new ArrayList<String>();
            for (String server : servers) {
                if (StringUtil.isEmpty(server)) continue;
                crontab.namedServers.add(server);
            }
        }
        return crontab;
    }

    long getLongValue(String number) {
        return Long.valueOf(number.replaceAll("[^\\d]+", ""));
    }

    long getMultiplicityOfCommandWorkers(String element) {
        String[] arr = element.split("\\*");
        if (arr.length == 2) {
            return Long.valueOf(arr[1]);
        }
        return 1L;
    }

    CrontabCommandClassNameElement getCommandClassNameElement(String element) {
        return new CrontabCommandClassNameElement(element.split("\\*")[0]);
    }

    Crontab getBasicCrontab(Crontab crontab, String[] elements) {
        crontab.minuteElement = new CrontabElement(elements[0]);
        crontab.minuteFixedInvocations = this.getFixedInvocations(59, crontab.minuteElement);
        crontab.hourElement = new CrontabElement(elements[1]);
        crontab.hourFixedInvocations = this.getFixedInvocations(23, crontab.hourElement);
        crontab = this.replaceWildcardsOfMinuteOrHourValue(crontab);
        crontab.dayElement = new CrontabElement(elements[2]);
        if (crontab.dayElement.isNotWildcard()) {
            crontab.dayFixedInvocations = this.getFixedInvocations(31, crontab.dayElement);
        }
        crontab.monthElement = new CrontabElement(elements[3]);
        if (crontab.monthElement.isNotWildcard()) {
            crontab.monthFixedInvocations = this.getFixedInvocations(12, crontab.monthElement);
        }
        crontab.dayOfWeekElement = new CrontabElement(elements[4]);
        if (crontab.dayOfWeekElement.isNotWildcard()) {
            crontab.dayOfWeekFixedInvocations = this.getFixedInvocations(7, crontab.dayOfWeekElement);
        }
        crontab.commandClassName = this.getCommandClassNameElement(elements[5]);
        crontab.multiplicity = this.getMultiplicityOfCommandWorkers(elements[5]);
        crontab.nextInvocationTime = this.getNextInvocationTime(CalendarUtil.getCurrentTime(), crontab);
        if (elements.length == 7 && !StringUtil.isEmpty(elements[6])) {
            String[] servers = elements[6].split(",");
            crontab.namedServers = new ArrayList<String>();
            for (String server : servers) {
                if (StringUtil.isEmpty(server)) continue;
                crontab.namedServers.add(server);
            }
        }
        return crontab;
    }

    boolean isDayOfWeekNotCameAt(Crontab crontab, Calendar nextInvocationTime, int dayOfWeek) {
        return this.getCrontabDayOfWeekNumber(nextInvocationTime) != this.getFixedNextInvocationValue(dayOfWeek, 6, crontab.dayOfWeekElement) && !this.isInvocationValueContainedInCrontabValue(this.getCrontabDayOfWeekNumber(nextInvocationTime), 6, crontab.dayOfWeekElement);
    }
}

