/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import it.sephiroth.android.library.tooltip.Tooltip;

final class Utils {
    private Utils() {
    }

    @Nullable
    static Activity getActivity(@Nullable Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            return Utils.getActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    static void log(String tag, int level, String format, Object ... args) {
        if (Tooltip.dbg) {
            switch (level) {
                case 3: {
                    Log.d((String)tag, (String)String.format(format, args));
                    break;
                }
                case 6: {
                    Log.e((String)tag, (String)String.format(format, args));
                    break;
                }
                case 4: {
                    Log.i((String)tag, (String)String.format(format, args));
                    break;
                }
                case 5: {
                    Log.w((String)tag, (String)String.format(format, args));
                    break;
                }
                default: {
                    Log.v((String)tag, (String)String.format(format, args));
                }
            }
        }
    }

    static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == null ? b == null : a.equals(b);
    }

    static boolean rectContainsRectWithTolerance(@NonNull Rect parentRect, @NonNull Rect childRect, int t) {
        return parentRect.contains(childRect.left + t, childRect.top + t, childRect.right - t, childRect.bottom - t);
    }
}

