/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipManager;

class TooltipTextDrawable
extends Drawable {
    static final String TAG = "ToolTipTextDrawable";
    private final RectF rectF;
    private final Path path;
    private Point point;
    private final Paint bgPaint;
    private final Paint stPaint;
    private final float arrowRatio;
    private final float ellipseSize;
    private final int strokeWidth;
    private final int strokeColor;
    private final int backgroundColor;
    private int padding = 0;
    private int arrowWeight = 0;
    private TooltipManager.Gravity gravity;

    public TooltipTextDrawable(Context context, TooltipManager.Builder builder) {
        TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.defStyleAttr, builder.defStyleRes);
        this.ellipseSize = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_cornerRadius, 4);
        this.strokeWidth = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_strokeWeight, 30);
        this.backgroundColor = builder.bgColor;
        this.strokeColor = builder.strokeColor;
        this.arrowRatio = theme.getFloat(R.styleable.TooltipLayout_ttlm_arrowRatio, 1.4f);
        theme.recycle();
        this.rectF = new RectF();
        if (this.backgroundColor != 0) {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(this.backgroundColor);
            this.bgPaint.setStyle(Paint.Style.FILL);
        } else {
            this.bgPaint = null;
        }
        if (this.strokeColor != 0) {
            this.stPaint = new Paint(1);
            this.stPaint.setColor(this.strokeColor);
            this.stPaint.setStyle(Paint.Style.STROKE);
            this.stPaint.setStrokeWidth((float)this.strokeWidth);
        } else {
            this.stPaint = null;
        }
        this.path = new Path();
    }

    private void calculatePath(Rect outBounds) {
        int left = outBounds.left + this.padding;
        int top = outBounds.top + this.padding;
        int right = outBounds.right - this.padding;
        int bottom = outBounds.bottom - this.padding;
        float max_y = (float)bottom - this.ellipseSize;
        float max_x = (float)right - this.ellipseSize;
        float min_y = (float)top + this.ellipseSize;
        float min_x = (float)left + this.ellipseSize;
        boolean drawPoint = false;
        if (null != this.point && null != this.gravity) {
            if (this.gravity == TooltipManager.Gravity.RIGHT || this.gravity == TooltipManager.Gravity.LEFT) {
                if (this.point.y >= top && this.point.y <= bottom) {
                    if ((float)(top + this.point.y + this.arrowWeight) > max_y) {
                        this.point.y = (int)(max_y - (float)this.arrowWeight - (float)top);
                    } else if ((float)(top + this.point.y - this.arrowWeight) < min_y) {
                        this.point.y = (int)(min_y + (float)this.arrowWeight - (float)top);
                    }
                    drawPoint = true;
                }
            } else if (this.point.x >= left && this.point.x <= right && this.point.x >= left && this.point.x <= right) {
                if ((float)(left + this.point.x + this.arrowWeight) > max_x) {
                    this.point.x = (int)(max_x - (float)this.arrowWeight - (float)left);
                } else if ((float)(left + this.point.x - this.arrowWeight) < min_x) {
                    this.point.x = (int)(min_x + (float)this.arrowWeight - (float)left);
                }
                drawPoint = true;
            }
            this.path.reset();
            if (this.point.y < top) {
                this.point.y = top;
            } else if (this.point.y > bottom) {
                this.point.y = bottom;
            }
            if (this.point.x < left) {
                this.point.x = left;
            }
            if (this.point.x > right) {
                this.point.x = right;
            }
            this.path.moveTo((float)left + this.ellipseSize, (float)top);
            if (drawPoint && this.gravity == TooltipManager.Gravity.BOTTOM) {
                this.path.lineTo((float)(left + this.point.x - this.arrowWeight), (float)top);
                this.path.lineTo((float)(left + this.point.x), (float)outBounds.top);
                this.path.lineTo((float)(left + this.point.x + this.arrowWeight), (float)top);
            }
            this.path.lineTo((float)right - this.ellipseSize, (float)top);
            this.path.quadTo((float)right, (float)top, (float)right, (float)top + this.ellipseSize);
            if (drawPoint && this.gravity == TooltipManager.Gravity.LEFT) {
                this.path.lineTo((float)right, (float)(top + this.point.y - this.arrowWeight));
                this.path.lineTo((float)outBounds.right, (float)(top + this.point.y));
                this.path.lineTo((float)right, (float)(top + this.point.y + this.arrowWeight));
            }
            this.path.lineTo((float)right, (float)bottom - this.ellipseSize);
            this.path.quadTo((float)right, (float)bottom, (float)right - this.ellipseSize, (float)bottom);
            if (drawPoint && this.gravity == TooltipManager.Gravity.TOP) {
                this.path.lineTo((float)(left + this.point.x + this.arrowWeight), (float)bottom);
                this.path.lineTo((float)(left + this.point.x), (float)outBounds.bottom);
                this.path.lineTo((float)(left + this.point.x - this.arrowWeight), (float)bottom);
            }
            this.path.lineTo((float)left + this.ellipseSize, (float)bottom);
            this.path.quadTo((float)left, (float)bottom, (float)left, (float)bottom - this.ellipseSize);
            if (drawPoint && this.gravity == TooltipManager.Gravity.RIGHT) {
                this.path.lineTo((float)left, (float)(top + this.point.y + this.arrowWeight));
                this.path.lineTo((float)outBounds.left, (float)(top + this.point.y));
                this.path.lineTo((float)left, (float)(top + this.point.y - this.arrowWeight));
            }
            this.path.lineTo((float)left, (float)top + this.ellipseSize);
            this.path.quadTo((float)left, (float)top, (float)left + this.ellipseSize, (float)top);
        } else {
            this.rectF.set((float)left, (float)top, (float)right, (float)bottom);
            this.path.addRoundRect(this.rectF, this.ellipseSize, this.ellipseSize, Path.Direction.CW);
        }
    }

    public void draw(Canvas canvas) {
        if (null != this.bgPaint) {
            canvas.drawPath(this.path, this.bgPaint);
        }
        if (null != this.stPaint) {
            canvas.drawPath(this.path, this.stPaint);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.calculatePath(bounds);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    public void setDestinationPoint(Point point) {
        this.point = new Point(point);
    }

    public void setAnchor(TooltipManager.Gravity gravity, int padding) {
        this.gravity = gravity;
        this.padding = padding;
        this.arrowWeight = (int)((float)padding / this.arrowRatio);
    }
}

