/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.text.Html;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.Tooltip;
import it.sephiroth.android.library.tooltip.TooltipManager;
import it.sephiroth.android.library.tooltip.TooltipTextDrawable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TooltipView
extends ViewGroup
implements Tooltip {
    private static final String TAG = "ToolTipLayout";
    private static final List<TooltipManager.Gravity> gravities = new ArrayList<TooltipManager.Gravity>(Arrays.asList(TooltipManager.Gravity.LEFT, TooltipManager.Gravity.RIGHT, TooltipManager.Gravity.TOP, TooltipManager.Gravity.BOTTOM, TooltipManager.Gravity.CENTER));
    private final List<TooltipManager.Gravity> viewGravities = new ArrayList<TooltipManager.Gravity>(gravities);
    private final long showDelay;
    private View mAnchor;
    private boolean mAttached;
    private boolean mInitialized;
    private boolean mActivated;
    private final int toolTipId;
    private final Rect drawRect;
    private final Rect tempRect;
    private Rect viewRect;
    private final long showDuration;
    private final TooltipManager.ClosePolicy closePolicy;
    private final Point point;
    private final int textResId;
    @ColorInt
    private final int textColor;
    @Size
    private final int textSize;
    private final int textGravity;
    private final int textAlignment;
    private final int textDirection;
    private final int topRule;
    private final int maxWidth;
    private final boolean hideArrow;
    private int padding;
    private final long activateDelay;
    private final boolean restrict;
    private final long fadeDuration;
    private final TooltipManager.onTooltipClosingCallback closeCallback;
    private CharSequence text;
    TooltipManager.Gravity gravity;
    private View mView;
    private TextView mTextView;
    private final TooltipTextDrawable mDrawable;
    Animator mShowAnimation;
    boolean mShowing;
    Runnable activateRunnable = new Runnable(){

        @Override
        public void run() {
            TooltipView.this.mActivated = true;
        }
    };
    Runnable hideRunnable = new Runnable(){

        @Override
        public void run() {
            TooltipView.this.onClose(false, false);
        }
    };
    private OnCloseListener closeListener;
    private OnToolTipListener tooltipListener;

    public TooltipView(Context context, TooltipManager.Builder builder) {
        super(context);
        TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.defStyleAttr, builder.defStyleRes);
        this.padding = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_padding, 30);
        theme.recycle();
        this.toolTipId = builder.id;
        this.text = builder.text;
        this.textColor = builder.textColor;
        this.textSize = builder.textSize;
        this.textGravity = builder.textGravity;
        this.textAlignment = builder.textAlignment;
        this.textDirection = builder.textDirection;
        this.gravity = builder.gravity;
        this.textResId = builder.textResId;
        this.maxWidth = builder.maxWidth;
        this.topRule = builder.actionbarSize;
        this.closePolicy = builder.closePolicy;
        this.showDuration = builder.showDuration;
        this.showDelay = builder.showDelay;
        this.hideArrow = builder.hideArrow;
        this.activateDelay = builder.activateDelay;
        this.restrict = builder.restrictToScreenEdges;
        this.fadeDuration = builder.fadeDuration;
        this.closeCallback = builder.closeCallback;
        this.setContentDescription(builder.contentDescription);
        if (null != builder.point) {
            this.point = new Point(builder.point);
            this.point.y += this.topRule;
        } else {
            this.point = null;
        }
        this.drawRect = new Rect();
        this.tempRect = new Rect();
        if (null != builder.view) {
            this.viewRect = new Rect();
            this.mAnchor = builder.view;
            builder.view.getGlobalVisibleRect(this.viewRect);
        }
        this.mDrawable = !builder.isCustomView ? new TooltipTextDrawable(context, builder) : null;
        this.setVisibility(4);
    }

    int getTooltipId() {
        return this.toolTipId;
    }

    @Override
    public void show() {
        if (!this.isAttached()) {
            return;
        }
        this.fadeIn();
    }

    @Override
    public void hide(boolean remove) {
        if (!this.isAttached()) {
            return;
        }
        this.fadeOut(remove);
    }

    protected void fadeIn() {
        if (this.mShowing) {
            return;
        }
        if (null != this.mShowAnimation) {
            this.mShowAnimation.cancel();
        }
        this.mShowing = true;
        if (this.fadeDuration > 0L) {
            this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            this.mShowAnimation.setDuration(this.fadeDuration);
            if (this.showDelay > 0L) {
                this.mShowAnimation.setStartDelay(this.showDelay);
            }
            this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                boolean cancelled;

                public void onAnimationStart(Animator animation) {
                    TooltipView.this.setVisibility(0);
                    this.cancelled = false;
                }

                public void onAnimationEnd(Animator animation) {
                    if (null != TooltipView.this.tooltipListener && !this.cancelled) {
                        TooltipView.this.tooltipListener.onShowCompleted(TooltipView.this);
                        TooltipView.this.postActivate(TooltipView.this.activateDelay);
                    }
                    if (Build.VERSION.SDK_INT >= 16 && TooltipView.this.mAnchor != null) {
                        TooltipView.this.mAnchor.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener(){

                            public void onDraw() {
                                TooltipView.this.mAnchor.getGlobalVisibleRect(TooltipView.this.viewRect);
                                TooltipView.this.viewGravities.clear();
                                TooltipView.this.viewGravities.addAll(gravities);
                                TooltipView.this.viewGravities.remove((Object)TooltipView.this.gravity);
                                TooltipView.this.viewGravities.add(0, TooltipView.this.gravity);
                                TooltipView.this.calculatePositions(TooltipView.this.viewGravities);
                            }
                        });
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    this.cancelled = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mShowAnimation.start();
        } else {
            this.setVisibility(0);
            this.tooltipListener.onShowCompleted(this);
            if (!this.mActivated) {
                this.postActivate(this.activateDelay);
            }
        }
        if (this.showDuration > 0L) {
            this.getHandler().removeCallbacks(this.hideRunnable);
            this.getHandler().postDelayed(this.hideRunnable, this.showDuration);
        }
    }

    boolean isShowing() {
        return this.mShowing;
    }

    void postActivate(long ms) {
        if (ms > 0L) {
            if (this.isAttached()) {
                this.postDelayed(this.activateRunnable, ms);
            }
        } else {
            this.mActivated = true;
        }
    }

    void removeFromParent() {
        ViewParent parent = this.getParent();
        if (null != parent) {
            if (null != this.getHandler()) {
                this.getHandler().removeCallbacks(this.hideRunnable);
            }
            ((ViewGroup)parent).removeView((View)this);
            if (null != this.mShowAnimation && this.mShowAnimation.isStarted()) {
                this.mShowAnimation.cancel();
            }
        }
    }

    protected void fadeOut(final boolean remove) {
        if (!this.isAttached() || !this.mShowing) {
            return;
        }
        if (null != this.mShowAnimation) {
            this.mShowAnimation.cancel();
        }
        this.mShowing = false;
        if (this.fadeDuration > 0L) {
            float alpha = 1.0f;
            this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{alpha, 0.0f});
            this.mShowAnimation.setDuration(this.fadeDuration);
            this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                boolean cancelled;

                public void onAnimationStart(Animator animation) {
                    this.cancelled = false;
                }

                public void onAnimationEnd(Animator animation) {
                    if (this.cancelled) {
                        return;
                    }
                    if (remove) {
                        TooltipView.this.fireOnHideCompleted();
                    }
                    TooltipView.this.mShowAnimation = null;
                }

                public void onAnimationCancel(Animator animation) {
                    this.cancelled = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mShowAnimation.start();
        } else {
            this.setVisibility(4);
            if (remove) {
                this.fireOnHideCompleted();
            }
        }
    }

    private void fireOnHideCompleted() {
        if (null != this.tooltipListener) {
            this.tooltipListener.onHideCompleted(this);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(child.getLeft(), child.getTop(), child.getMeasuredWidth(), child.getMeasuredHeight());
        }
        if (changed) {
            this.viewGravities.clear();
            this.viewGravities.addAll(gravities);
            this.viewGravities.remove((Object)this.gravity);
            this.viewGravities.add(0, this.gravity);
            this.calculatePositions(this.viewGravities);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int myWidth = -1;
        int myHeight = -1;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myWidth, (int)Integer.MIN_VALUE);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myHeight, (int)Integer.MIN_VALUE);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.setMeasuredDimension(myWidth, myHeight);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttached = true;
        this.initializeView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    private void initializeView() {
        if (!this.isAttached() || this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        this.mView = LayoutInflater.from((Context)this.getContext()).inflate(this.textResId, (ViewGroup)this, false);
        this.mView.setLayoutParams(params);
        if (null != this.mDrawable) {
            this.mView.setBackgroundDrawable((Drawable)this.mDrawable);
            if (this.hideArrow) {
                this.mView.setPadding(this.padding / 2, this.padding / 2, this.padding / 2, this.padding / 2);
            } else {
                this.mView.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
        this.mTextView = (TextView)this.mView.findViewById(16908308);
        this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)this.text)));
        this.mTextView.setTextColor(this.textColor);
        this.mTextView.setTextSize((float)this.textSize);
        this.mTextView.setGravity(this.textGravity);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mTextView.setTextAlignment(this.textAlignment);
            this.mTextView.setTextDirection(this.textDirection);
        }
        if (this.maxWidth > -1) {
            this.mTextView.setMaxWidth(this.maxWidth);
        }
        this.addView(this.mView);
    }

    private static Activity scanForActivity(Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            return TooltipView.scanForActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    private void calculatePositions(List<TooltipManager.Gravity> gravities) {
        if (!this.isAttached()) {
            return;
        }
        if (gravities.size() < 1) {
            if (null != this.tooltipListener) {
                this.tooltipListener.onShowFailed(this);
            }
            this.setVisibility(8);
            return;
        }
        TooltipManager.Gravity gravity = gravities.get(0);
        gravities.remove(0);
        Rect screenRect = new Rect();
        Activity act = TooltipView.scanForActivity(this.getContext());
        if (act != null) {
            Window window = act.getWindow();
            window.getDecorView().getWindowVisibleDisplayFrame(screenRect);
        } else {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            display.getRectSize(screenRect);
        }
        if (this.viewRect == null) {
            int statusbarHeight = screenRect.top;
            this.viewRect = new Rect();
            this.viewRect.set(this.point.x, this.point.y + statusbarHeight, this.point.x, this.point.y + statusbarHeight);
        }
        screenRect.top += this.topRule;
        int width = this.mView.getWidth();
        int height = this.mView.getMeasuredHeight();
        Point point = new Point();
        if (gravity == TooltipManager.Gravity.BOTTOM) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.bottom, this.viewRect.centerX() + width / 2, this.viewRect.bottom + height);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.bottom;
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                this.onClose(false, true);
                return;
            }
        } else if (gravity == TooltipManager.Gravity.TOP) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.top - height, this.viewRect.centerX() + width / 2, this.viewRect.top);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.top;
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                this.onClose(false, true);
                return;
            }
        } else if (gravity == TooltipManager.Gravity.RIGHT) {
            this.drawRect.set(this.viewRect.right, this.viewRect.centerY() - height / 2, this.viewRect.right + width, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.right;
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                this.onClose(false, true);
                return;
            }
        } else if (gravity == TooltipManager.Gravity.LEFT) {
            this.drawRect.set(this.viewRect.left - width, this.viewRect.centerY() - height / 2, this.viewRect.left, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.left;
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                this.onClose(false, true);
                return;
            }
        } else if (this.gravity == TooltipManager.Gravity.CENTER) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.centerY() - height / 2, this.viewRect.centerX() - width / 2, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                this.onClose(false, true);
                return;
            }
        }
        this.mView.setTranslationX((float)this.drawRect.left);
        this.mView.setTranslationY((float)this.drawRect.top);
        if (null != this.mDrawable) {
            this.mView.getGlobalVisibleRect(this.tempRect);
            point.x -= this.tempRect.left;
            point.y -= this.tempRect.top;
            if (!this.hideArrow) {
                if (gravity == TooltipManager.Gravity.LEFT || gravity == TooltipManager.Gravity.RIGHT) {
                    point.y -= this.padding / 2;
                } else if (gravity == TooltipManager.Gravity.TOP || gravity == TooltipManager.Gravity.BOTTOM) {
                    point.x -= this.padding / 2;
                }
            }
            this.mDrawable.setAnchor(gravity, this.hideArrow ? 0 : this.padding / 2);
            if (!this.hideArrow) {
                this.mDrawable.setDestinationPoint(point);
            }
        }
    }

    @Override
    public void setOffsetX(int x) {
        this.setTranslationX(x - this.viewRect.left);
    }

    @Override
    public void setOffsetY(int y) {
        this.setTranslationY(y - this.viewRect.top);
    }

    @Override
    public void offsetTo(int x, int y) {
        this.setTranslationX(x - this.viewRect.left);
        this.setTranslationY(y - this.viewRect.top);
    }

    @Override
    public boolean isAttached() {
        return this.mAttached;
    }

    void setText(CharSequence text) {
        this.text = text;
        if (null != this.mTextView) {
            this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)text)));
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!(this.mAttached && this.mShowing && this.isShown())) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.closePolicy == TooltipManager.ClosePolicy.TouchOutside || this.closePolicy == TooltipManager.ClosePolicy.TouchInside || this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive || this.closePolicy == TooltipManager.ClosePolicy.TouchOutsideExclusive) {
            if (!this.mActivated) {
                return true;
            }
            if (action == 0) {
                boolean containsTouch = this.drawRect.contains((int)event.getX(), (int)event.getY());
                if (this.closePolicy == TooltipManager.ClosePolicy.TouchInside || this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive) {
                    if (containsTouch) {
                        this.onClose(true, true);
                        return true;
                    }
                    return this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive;
                }
                this.onClose(true, containsTouch);
                return this.closePolicy == TooltipManager.ClosePolicy.TouchOutsideExclusive || containsTouch;
            }
        }
        return false;
    }

    private void onClose(boolean fromUser, boolean containsTouch) {
        if (null == this.getHandler()) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        this.getHandler().removeCallbacks(this.hideRunnable);
        if (null != this.closeListener) {
            this.closeListener.onClose(this);
        }
        if (null != this.closeCallback) {
            this.closeCallback.onClosing(this.toolTipId, fromUser, containsTouch);
        }
    }

    void setOnCloseListener(OnCloseListener listener) {
        this.closeListener = listener;
    }

    void setOnToolTipListener(OnToolTipListener listener) {
        this.tooltipListener = listener;
    }

    static interface OnToolTipListener {
        public void onHideCompleted(TooltipView var1);

        public void onShowCompleted(TooltipView var1);

        public void onShowFailed(TooltipView var1);
    }

    static interface OnCloseListener {
        public void onClose(TooltipView var1);
    }
}

