/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.numberpicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.AppCompatImageButton;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import it.sephiroth.android.library.numberpicker.Data;
import it.sephiroth.android.library.numberpicker.ExponentialTracker;
import it.sephiroth.android.library.numberpicker.LinearTracker;
import it.sephiroth.android.library.numberpicker.NumberPicker;
import it.sephiroth.android.library.numberpicker.R;
import it.sephiroth.android.library.numberpicker.Tracker;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import it.sephiroth.android.library.uigestures.UILongPressGestureRecognizer;
import it.sephiroth.android.library.uigestures.UITapGestureRecognizer;
import it.sephiroth.android.library.uigestures.ViewKt;
import it.sephiroth.android.library.xtooltip.ClosePolicy;
import it.sephiroth.android.library.xtooltip.Tooltip;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 H2\u00020\u0001:\u0002HIB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010<\u001a\u00020\u000fH\u0002J\b\u0010=\u001a\u00020\u000fH\u0002J\b\u0010>\u001a\u00020\u000fH\u0002J\b\u0010?\u001a\u00020\u000fH\u0003J\b\u0010@\u001a\u00020\u000fH\u0002J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020CH\u0016J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00072\b\b\u0002\u0010F\u001a\u00020CJ\b\u0010G\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010!\"\u0004\b/\u0010#R$\u00100\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010!\"\u0004\b2\u0010#R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lit/sephiroth/android/library/numberpicker/NumberPicker;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "arrowStyle", "buttonInterval", "Lio/reactivex/disposables/Disposable;", "callback", "Lkotlin/Function1;", "", "data", "Lit/sephiroth/android/library/numberpicker/Data;", "delegate", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizerDelegate;", "downButton", "Landroidx/appcompat/widget/AppCompatImageButton;", "editText", "Landroid/widget/EditText;", "editTextStyleId", "longGesture", "Lit/sephiroth/android/library/uigestures/UILongPressGestureRecognizer;", "longGestureListener", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "maxDistance", "value", "maxValue", "getMaxValue", "()I", "setMaxValue", "(I)V", "minValue", "getMinValue", "setMinValue", "numberPickerChangeListener", "Lit/sephiroth/android/library/numberpicker/NumberPicker$OnNumberPickerChangeListener;", "getNumberPickerChangeListener", "()Lit/sephiroth/android/library/numberpicker/NumberPicker$OnNumberPickerChangeListener;", "setNumberPickerChangeListener", "(Lit/sephiroth/android/library/numberpicker/NumberPicker$OnNumberPickerChangeListener;)V", "progress", "getProgress", "setProgress", "stepSize", "getStepSize", "setStepSize", "tapGesture", "Lit/sephiroth/android/library/uigestures/UITapGestureRecognizer;", "tapGestureListener", "tooltip", "Lit/sephiroth/android/library/xtooltip/Tooltip;", "tooltipStyleId", "tracker", "Lit/sephiroth/android/library/numberpicker/Tracker;", "upButton", "endInteraction", "hideKeyboard", "inflateChildren", "initializeButtonActions", "initializeGestures", "setBackgroundFocused", "hasFocus", "", "setEnabled", "enabled", "fromUser", "startInteraction", "Companion", "OnNumberPickerChangeListener", "numberpicker_release"})
public final class NumberPicker
extends LinearLayout {
    @Nullable
    private OnNumberPickerChangeListener numberPickerChangeListener;
    private EditText editText;
    private AppCompatImageButton upButton;
    private AppCompatImageButton downButton;
    private Tracker tracker;
    private int arrowStyle;
    private int editTextStyleId;
    private int tooltipStyleId;
    private final UIGestureRecognizerDelegate delegate;
    private UILongPressGestureRecognizer longGesture;
    private UITapGestureRecognizer tapGesture;
    private Tooltip tooltip;
    private int maxDistance;
    private Data data;
    private Function1<? super Integer, Unit> callback;
    private Disposable buttonInterval;
    private final Function1<UIGestureRecognizer, Unit> longGestureListener;
    private final Function1<UIGestureRecognizer, Unit> tapGestureListener;
    public static final int TRACKER_LINEAR = 0;
    public static final int TRACKER_EXPONENTIAL = 1;
    public static final long ARROW_BUTTON_INITIAL_DELAY = 800L;
    public static final long ARROW_BUTTON_FRAME_DELAY = 16L;
    public static final long LONG_TAP_TIMEOUT = 300L;
    @NotNull
    private static final int[] FOCUSED_STATE_ARRAY;
    @NotNull
    private static final int[] UNFOCUSED_STATE_ARRAY;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Nullable
    public final OnNumberPickerChangeListener getNumberPickerChangeListener() {
        return this.numberPickerChangeListener;
    }

    public final void setNumberPickerChangeListener(@Nullable OnNumberPickerChangeListener onNumberPickerChangeListener) {
        this.numberPickerChangeListener = onNumberPickerChangeListener;
    }

    public final void setProgress(int value, boolean fromUser) {
        block10: {
            Data data = this.data;
            if (data == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            if (value == data.getValue()) break block10;
            Data data2 = this.data;
            if (data2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            data2.setValue(value);
            Tooltip tooltip = this.tooltip;
            if (tooltip != null) {
                Data data3 = this.data;
                if (data3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                tooltip.update((CharSequence)String.valueOf(data3.getValue()));
            }
            EditText editText = this.editText;
            if (editText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
            }
            String string = editText.getText().toString();
            Data data4 = this.data;
            if (data4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            if (Intrinsics.areEqual((Object)string, (Object)String.valueOf(data4.getValue())) ^ true) {
                EditText editText2 = this.editText;
                if (editText2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
                }
                Data data5 = this.data;
                if (data5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                editText2.setText((CharSequence)String.valueOf(data5.getValue()));
            }
            OnNumberPickerChangeListener onNumberPickerChangeListener = this.numberPickerChangeListener;
            if (onNumberPickerChangeListener != null) {
                onNumberPickerChangeListener.onProgressChanged(this, this.getProgress(), fromUser);
            }
        }
    }

    public static /* synthetic */ void setProgress$default(NumberPicker numberPicker, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        numberPicker.setProgress(n, bl);
    }

    public final int getProgress() {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        return data.getValue();
    }

    public final void setProgress(int value) {
        this.setProgress(value, false);
    }

    public final int getMinValue() {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        return data.getMinValue();
    }

    public final void setMinValue(int value) {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        data.setMinValue(value);
    }

    public final int getMaxValue() {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        return data.getMaxValue();
    }

    public final void setMaxValue(int value) {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        data.setMaxValue(value);
    }

    public final int getStepSize() {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        return data.getStepSize();
    }

    public final void setStepSize(int value) {
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        data.setStepSize(value);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.delegate.setEnabled(enabled);
    }

    private final void hideKeyboard() {
        Object object = this.getContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private final void inflateChildren() {
        AppCompatImageButton appCompatImageButton = this.upButton = new AppCompatImageButton(this.getContext());
        if (appCompatImageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
        }
        appCompatImageButton.setImageResource(R.drawable.arrow_up_selector_24);
        AppCompatImageButton appCompatImageButton2 = this.upButton;
        if (appCompatImageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
        }
        appCompatImageButton2.setBackgroundResource(R.drawable.arrow_up_background);
        Data data = this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        if (data.getOrientation() == 0) {
            AppCompatImageButton appCompatImageButton3 = this.upButton;
            if (appCompatImageButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
            }
            appCompatImageButton3.setRotation(90.0f);
        }
        EditText editText = this.editText = new EditText((Context)new ContextThemeWrapper(this.getContext(), this.editTextStyleId), null, 0);
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText.setLines(1);
        EditText editText2 = this.editText;
        if (editText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        int n = this.getMaxValue();
        EditText editText3 = editText2;
        int n2 = Math.abs(n);
        n = String.valueOf(n2).length();
        int n3 = this.getMinValue();
        n2 = Math.abs(n3);
        n3 = String.valueOf(n2).length();
        n2 = Math.max(n, n3);
        editText3.setEms(n2);
        EditText editText4 = this.editText;
        if (editText4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText4.setFocusableInTouchMode(true);
        EditText editText5 = this.editText;
        if (editText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText5.setFocusable(true);
        EditText editText6 = this.editText;
        if (editText6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText6.setClickable(true);
        EditText editText7 = this.editText;
        if (editText7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText7.setLongClickable(false);
        AppCompatImageButton appCompatImageButton4 = this.downButton = new AppCompatImageButton(this.getContext());
        if (appCompatImageButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        appCompatImageButton4.setImageResource(R.drawable.arrow_up_selector_24);
        AppCompatImageButton appCompatImageButton5 = this.downButton;
        if (appCompatImageButton5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        appCompatImageButton5.setBackgroundResource(R.drawable.arrow_up_background);
        AppCompatImageButton appCompatImageButton6 = this.downButton;
        if (appCompatImageButton6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        Data data2 = this.data;
        if (data2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        appCompatImageButton6.setRotation(data2.getOrientation() == 1 ? 180.0f : -90.0f);
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(-2, -2);
        params1.weight = 0.0f;
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(0, -2);
        params2.weight = 1.0f;
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-2, -2);
        params3.weight = 0.0f;
        AppCompatImageButton appCompatImageButton7 = this.downButton;
        if (appCompatImageButton7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        this.addView((View)appCompatImageButton7, (ViewGroup.LayoutParams)params3);
        EditText editText8 = this.editText;
        if (editText8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        this.addView((View)editText8, (ViewGroup.LayoutParams)params2);
        AppCompatImageButton appCompatImageButton8 = this.upButton;
        if (appCompatImageButton8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
        }
        this.addView((View)appCompatImageButton8, (ViewGroup.LayoutParams)params1);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void initializeButtonActions() {
        TextView $receiver$iv;
        AppCompatImageButton appCompatImageButton = this.upButton;
        if (appCompatImageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
        }
        appCompatImageButton.setOnTouchListener(new View.OnTouchListener(this){
            final /* synthetic */ NumberPicker this$0;

            public final boolean onTouch(View $noName_0, MotionEvent event) {
                boolean bl;
                if (!this.this$0.isEnabled()) {
                    bl = false;
                } else {
                    MotionEvent motionEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                    int action = motionEvent.getActionMasked();
                    switch (action) {
                        case 0: {
                            this.this$0.requestFocus();
                            NumberPicker.setProgress$default(this.this$0, this.this$0.getProgress() + this.this$0.getStepSize(), false, 2, null);
                            NumberPicker.access$getEditText$p(this.this$0).clearFocus();
                            NumberPicker.access$hideKeyboard(this.this$0);
                            NumberPicker.access$getUpButton$p(this.this$0).requestFocus();
                            NumberPicker.access$getUpButton$p(this.this$0).setPressed(true);
                            Disposable disposable = NumberPicker.access$getButtonInterval$p(this.this$0);
                            if (disposable != null) {
                                disposable.dispose();
                            }
                            NumberPicker.access$setButtonInterval$p(this.this$0, Observable.interval((long)800L, (long)16L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(this){
                                final /* synthetic */ initializeButtonActions.1 this$0;

                                public final void accept(Long it) {
                                    NumberPicker.setProgress$default(this.this$0.this$0, this.this$0.this$0.getProgress() + this.this$0.this$0.getStepSize(), false, 2, null);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            break;
                        }
                        case 1: {
                            NumberPicker.access$getUpButton$p(this.this$0).setPressed(false);
                            Disposable disposable = NumberPicker.access$getButtonInterval$p(this.this$0);
                            if (disposable != null) {
                                disposable.dispose();
                            }
                            NumberPicker.access$setButtonInterval$p(this.this$0, null);
                        }
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = numberPicker;
            }
        });
        AppCompatImageButton appCompatImageButton2 = this.downButton;
        if (appCompatImageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        appCompatImageButton2.setOnTouchListener(new View.OnTouchListener(this){
            final /* synthetic */ NumberPicker this$0;

            public final boolean onTouch(View $noName_0, MotionEvent event) {
                boolean bl;
                if (!this.this$0.isEnabled()) {
                    bl = false;
                } else {
                    MotionEvent motionEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                    int action = motionEvent.getActionMasked();
                    switch (action) {
                        case 0: {
                            this.this$0.requestFocus();
                            NumberPicker.setProgress$default(this.this$0, this.this$0.getProgress() - this.this$0.getStepSize(), false, 2, null);
                            NumberPicker.access$getEditText$p(this.this$0).clearFocus();
                            NumberPicker.access$hideKeyboard(this.this$0);
                            NumberPicker.access$getDownButton$p(this.this$0).requestFocus();
                            NumberPicker.access$getDownButton$p(this.this$0).setPressed(true);
                            Disposable disposable = NumberPicker.access$getButtonInterval$p(this.this$0);
                            if (disposable != null) {
                                disposable.dispose();
                            }
                            NumberPicker.access$setButtonInterval$p(this.this$0, Observable.interval((long)800L, (long)16L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(this){
                                final /* synthetic */ initializeButtonActions.2 this$0;

                                public final void accept(Long it) {
                                    NumberPicker.setProgress$default(this.this$0.this$0, this.this$0.this$0.getProgress() - this.this$0.this$0.getStepSize(), false, 2, null);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            break;
                        }
                        case 1: {
                            NumberPicker.access$getDownButton$p(this.this$0).setPressed(false);
                            Disposable disposable = NumberPicker.access$getButtonInterval$p(this.this$0);
                            if (disposable != null) {
                                disposable.dispose();
                            }
                            NumberPicker.access$setButtonInterval$p(this.this$0, null);
                        }
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = numberPicker;
            }
        });
        EditText editText = this.editText;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        TextView $receiver$iv$iv = $receiver$iv = (TextView)editText;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ NumberPicker this$0;
            {
                this.this$0 = numberPicker;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable it = s;
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence text2 = text;
                boolean bl = false;
                CharSequence charSequence = text2;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    try {
                        Integer n4 = Integer.valueOf(((Object)text2).toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"Integer.valueOf(text.toString())");
                        NumberPicker.setProgress$default(this.this$0, n4, false, 2, null);
                    }
                    catch (NumberFormatException e) {
                        Timber.e((Throwable)e);
                    }
                }
            }
        };
        $receiver$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        EditText editText2 = this.editText;
        if (editText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText2.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ NumberPicker this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                CharSequence charSequence;
                NumberPicker.access$setBackgroundFocused(this.this$0, hasFocus);
                if (!hasFocus && ((charSequence = (CharSequence)NumberPicker.access$getEditText$p(this.this$0).getText()) == null || charSequence.length() == 0)) {
                    NumberPicker.access$getEditText$p(this.this$0).setText((CharSequence)String.valueOf(NumberPicker.access$getData$p(this.this$0).getValue()));
                }
            }
            {
                this.this$0 = numberPicker;
            }
        });
        EditText editText3 = this.editText;
        if (editText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        editText3.setOnEditorActionListener(new TextView.OnEditorActionListener(this){
            final /* synthetic */ NumberPicker this$0;

            public final boolean onEditorAction(TextView $noName_0, int actionId, KeyEvent $noName_2) {
                boolean bl;
                switch (actionId) {
                    case 6: {
                        NumberPicker.access$getEditText$p(this.this$0).clearFocus();
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.this$0 = numberPicker;
            }
        });
    }

    private final void setBackgroundFocused(boolean hasFocus) {
        block1: {
            block0: {
                if (!hasFocus) break block0;
                Drawable drawable2 = this.getBackground();
                if (drawable2 == null) break block1;
                drawable2.setState(FOCUSED_STATE_ARRAY);
                break block1;
            }
            Drawable drawable3 = this.getBackground();
            if (drawable3 == null) break block1;
            drawable3.setState(UNFOCUSED_STATE_ARRAY);
        }
    }

    private final void initializeGestures() {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        UILongPressGestureRecognizer uILongPressGestureRecognizer = this.longGesture = new UILongPressGestureRecognizer(context);
        if (uILongPressGestureRecognizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"longGesture");
        }
        uILongPressGestureRecognizer.setLongPressTimeout(300L);
        UILongPressGestureRecognizer uILongPressGestureRecognizer2 = this.longGesture;
        if (uILongPressGestureRecognizer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"longGesture");
        }
        uILongPressGestureRecognizer2.setActionListener(this.longGestureListener);
        UILongPressGestureRecognizer uILongPressGestureRecognizer3 = this.longGesture;
        if (uILongPressGestureRecognizer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"longGesture");
        }
        uILongPressGestureRecognizer3.setCancelsTouchesInView(false);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        UITapGestureRecognizer uITapGestureRecognizer = this.tapGesture = new UITapGestureRecognizer(context2);
        if (uITapGestureRecognizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tapGesture");
        }
        uITapGestureRecognizer.setCancelsTouchesInView(false);
        UILongPressGestureRecognizer uILongPressGestureRecognizer4 = this.longGesture;
        if (uILongPressGestureRecognizer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"longGesture");
        }
        this.delegate.addGestureRecognizer((UIGestureRecognizer)uILongPressGestureRecognizer4);
        UITapGestureRecognizer uITapGestureRecognizer2 = this.tapGesture;
        if (uITapGestureRecognizer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tapGesture");
        }
        this.delegate.addGestureRecognizer((UIGestureRecognizer)uITapGestureRecognizer2);
        UITapGestureRecognizer uITapGestureRecognizer3 = this.tapGesture;
        if (uITapGestureRecognizer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tapGesture");
        }
        uITapGestureRecognizer3.setActionListener(this.tapGestureListener);
        this.delegate.setEnabled(this.isEnabled());
        EditText editText = this.editText;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        ViewKt.setGestureDelegate((View)((View)editText), (UIGestureRecognizerDelegate)this.delegate);
    }

    private final void startInteraction() {
        block5: {
            this.animate().alpha(0.5f).start();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Tooltip.Builder builder = new Tooltip.Builder(context);
            EditText editText = this.editText;
            if (editText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
            }
            Tooltip tooltip = this.tooltip = builder.anchor((View)editText, 0, 0, false).styleId(Integer.valueOf(this.tooltipStyleId)).arrow(true).closePolicy(ClosePolicy.Companion.getTOUCH_NONE()).overlay(false).showDuration(0L).text((CharSequence)(String.valueOf(this.getMinValue()).length() > String.valueOf(this.getMaxValue()).length() ? String.valueOf(this.getMinValue()) : String.valueOf(this.getMaxValue()))).animationStyle(this.getOrientation() == 1 ? R.style.NumberPicker_AnimationVertical : R.style.NumberPicker_AnimationHorizontal).create();
            if (tooltip != null) {
                tooltip.doOnPrepare((Function1)startInteraction.1.INSTANCE);
            }
            Tooltip tooltip2 = this.tooltip;
            if (tooltip2 != null) {
                tooltip2.doOnShown((Function1)new Function1<Tooltip, Unit>(this){
                    final /* synthetic */ NumberPicker this$0;

                    public final void invoke(@NotNull Tooltip it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        it.update((CharSequence)String.valueOf(NumberPicker.access$getData$p(this.this$0).getValue()));
                    }
                    {
                        this.this$0 = numberPicker;
                        super(1);
                    }
                });
            }
            Tooltip tooltip3 = this.tooltip;
            if (tooltip3 != null) {
                View view = (View)this;
                Data data = this.data;
                if (data == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                tooltip3.show(view, data.getOrientation() == 1 ? Tooltip.Gravity.LEFT : Tooltip.Gravity.TOP, false);
            }
            OnNumberPickerChangeListener onNumberPickerChangeListener = this.numberPickerChangeListener;
            if (onNumberPickerChangeListener == null) break block5;
            onNumberPickerChangeListener.onStartTrackingTouch(this);
        }
    }

    private final void endInteraction() {
        block1: {
            Timber.i((String)"endInteraction", (Object[])new Object[0]);
            this.animate().alpha(1.0f).start();
            Tooltip tooltip = this.tooltip;
            if (tooltip != null) {
                tooltip.dismiss();
            }
            this.tooltip = null;
            OnNumberPickerChangeListener onNumberPickerChangeListener = this.numberPickerChangeListener;
            if (onNumberPickerChangeListener == null) break block1;
            onNumberPickerChangeListener.onStopTrackingTouch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public NumberPicker(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.delegate = new UIGestureRecognizerDelegate();
        this.callback = (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ NumberPicker this$0;

            public final void invoke(int newValue) {
                NumberPicker.setProgress$default(this.this$0, newValue, false, 2, null);
            }
            {
                this.this$0 = numberPicker;
                super(1);
            }
        };
        this.longGestureListener = (Function1)new Function1<UIGestureRecognizer, Unit>(this){
            final /* synthetic */ NumberPicker this$0;

            public final void invoke(@NotNull UIGestureRecognizer it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getState() == UIGestureRecognizer.State.Began) {
                    this.this$0.requestFocus();
                    NumberPicker.access$getEditText$p(this.this$0).setSelected(false);
                    NumberPicker.access$getEditText$p(this.this$0).clearFocus();
                    NumberPicker.access$getTracker$p(this.this$0).begin(it.getDownLocationX(), it.getDownLocationY());
                    NumberPicker.access$startInteraction(this.this$0);
                } else if (it.getState() == UIGestureRecognizer.State.Ended) {
                    NumberPicker.access$getTracker$p(this.this$0).end();
                    NumberPicker.access$endInteraction(this.this$0);
                } else if (it.getState() == UIGestureRecognizer.State.Changed) {
                    float diff;
                    float f = diff = NumberPicker.access$getData$p(this.this$0).getOrientation() == 1 ? it.getCurrentLocationY() - it.getDownLocationY() : it.getCurrentLocationX() - it.getDownLocationX();
                    if (diff > NumberPicker.access$getTracker$p(this.this$0).getMinDistance()) {
                        diff = NumberPicker.access$getTracker$p(this.this$0).getMinDistance();
                    } else if (diff < -NumberPicker.access$getTracker$p(this.this$0).getMinDistance()) {
                        diff = -NumberPicker.access$getTracker$p(this.this$0).getMinDistance();
                    }
                    double d = (double)(diff / NumberPicker.access$getTracker$p(this.this$0).getMinDistance()) * Math.PI / (double)2;
                    float final2 = (float)Math.sin(d);
                    Tooltip tooltip = NumberPicker.access$getTooltip$p(this.this$0);
                    if (tooltip != null) {
                        Tooltip tooltip2;
                        Tooltip tooltip3 = tooltip2 = tooltip;
                        boolean bl = false;
                        switch (NumberPicker.access$getData$p(this.this$0).getOrientation()) {
                            case 1: {
                                tooltip3.offsetTo(tooltip3.getOffsetX(), final2 / (float)2 * NumberPicker.access$getTracker$p(this.this$0).getMinDistance());
                                break;
                            }
                            case 0: {
                                tooltip3.offsetTo(final2 / (float)2 * NumberPicker.access$getTracker$p(this.this$0).getMinDistance(), tooltip3.getOffsetY());
                            }
                        }
                    }
                    NumberPicker.access$getTracker$p(this.this$0).addMovement(it.getCurrentLocationX(), it.getCurrentLocationY());
                }
            }
            {
                this.this$0 = numberPicker;
                super(1);
            }
        };
        this.tapGestureListener = (Function1)new Function1<UIGestureRecognizer, Unit>(this){
            final /* synthetic */ NumberPicker this$0;

            public final void invoke(@NotNull UIGestureRecognizer $noName_0) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.this$0.requestFocus();
                if (!NumberPicker.access$getEditText$p(this.this$0).isFocused()) {
                    NumberPicker.access$getEditText$p(this.this$0).requestFocus();
                }
            }
            {
                this.this$0 = numberPicker;
                super(1);
            }
        };
        this.setWillNotDraw(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setOrientation(0);
        this.setGravity(17);
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyleAttr, defStyleRes);
        try {
            Tracker tracker;
            int maxValue = array.getInteger(R.styleable.NumberPicker_picker_max, 100);
            int minValue = array.getInteger(R.styleable.NumberPicker_picker_min, 0);
            int stepSize = array.getInteger(R.styleable.NumberPicker_picker_stepSize, 1);
            int orientation = array.getInteger(R.styleable.NumberPicker_picker_orientation, 1);
            int value = array.getInteger(R.styleable.NumberPicker_android_progress, 0);
            this.arrowStyle = array.getResourceId(R.styleable.NumberPicker_picker_arrowStyle, 0);
            this.setBackground(array.getDrawable(R.styleable.NumberPicker_android_background));
            this.editTextStyleId = array.getResourceId(R.styleable.NumberPicker_picker_editTextStyle, R.style.NumberPicker_EditTextStyle);
            this.tooltipStyleId = array.getResourceId(R.styleable.NumberPicker_picker_tooltipStyle, R.style.NumberPicker_ToolTipStyle);
            this.maxDistance = context.getResources().getDimensionPixelSize(R.dimen.picker_distance_max);
            this.data = new Data(value, minValue, maxValue, stepSize, orientation);
            int tracker_type = array.getInteger(R.styleable.NumberPicker_picker_tracker, 0);
            switch (tracker_type) {
                case 0: {
                    tracker = new LinearTracker(this, this.maxDistance, orientation, this.callback);
                    break;
                }
                case 1: {
                    tracker = new ExponentialTracker(this, this.maxDistance, orientation, this.callback);
                    break;
                }
                default: {
                    tracker = new LinearTracker(this, this.maxDistance, orientation, this.callback);
                }
            }
            this.tracker = tracker;
            this.inflateChildren();
            EditText editText = this.editText;
            if (editText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
            }
            Data data = this.data;
            if (data == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            editText.setText((CharSequence)String.valueOf(data.getValue()));
        }
        finally {
            array.recycle();
        }
        this.initializeButtonActions();
        this.initializeGestures();
    }

    @JvmOverloads
    public /* synthetic */ NumberPicker(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = R.attr.pickerStyle;
        }
        if ((n3 & 8) != 0) {
            n2 = R.style.NumberPicker_Filled;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public NumberPicker(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public NumberPicker(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public NumberPicker(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    static {
        Companion = new Companion(null);
        FOCUSED_STATE_ARRAY = new int[]{16842908};
        UNFOCUSED_STATE_ARRAY = new int[]{0, -16842908};
    }

    public static final /* synthetic */ EditText access$getEditText$p(NumberPicker $this) {
        EditText editText = $this.editText;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editText");
        }
        return editText;
    }

    public static final /* synthetic */ void access$setEditText$p(NumberPicker $this, EditText editText) {
        $this.editText = editText;
    }

    public static final /* synthetic */ void access$hideKeyboard(NumberPicker $this) {
        $this.hideKeyboard();
    }

    public static final /* synthetic */ AppCompatImageButton access$getUpButton$p(NumberPicker $this) {
        AppCompatImageButton appCompatImageButton = $this.upButton;
        if (appCompatImageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upButton");
        }
        return appCompatImageButton;
    }

    public static final /* synthetic */ void access$setUpButton$p(NumberPicker $this, AppCompatImageButton appCompatImageButton) {
        $this.upButton = appCompatImageButton;
    }

    public static final /* synthetic */ Disposable access$getButtonInterval$p(NumberPicker $this) {
        return $this.buttonInterval;
    }

    public static final /* synthetic */ void access$setButtonInterval$p(NumberPicker $this, Disposable disposable) {
        $this.buttonInterval = disposable;
    }

    public static final /* synthetic */ AppCompatImageButton access$getDownButton$p(NumberPicker $this) {
        AppCompatImageButton appCompatImageButton = $this.downButton;
        if (appCompatImageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"downButton");
        }
        return appCompatImageButton;
    }

    public static final /* synthetic */ void access$setDownButton$p(NumberPicker $this, AppCompatImageButton appCompatImageButton) {
        $this.downButton = appCompatImageButton;
    }

    public static final /* synthetic */ void access$setBackgroundFocused(NumberPicker $this, boolean hasFocus) {
        $this.setBackgroundFocused(hasFocus);
    }

    public static final /* synthetic */ Data access$getData$p(NumberPicker $this) {
        Data data = $this.data;
        if (data == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
        }
        return data;
    }

    public static final /* synthetic */ void access$setData$p(NumberPicker $this, Data data) {
        $this.data = data;
    }

    public static final /* synthetic */ Tracker access$getTracker$p(NumberPicker $this) {
        Tracker tracker = $this.tracker;
        if (tracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
        }
        return tracker;
    }

    public static final /* synthetic */ void access$setTracker$p(NumberPicker $this, Tracker tracker) {
        $this.tracker = tracker;
    }

    public static final /* synthetic */ void access$startInteraction(NumberPicker $this) {
        $this.startInteraction();
    }

    public static final /* synthetic */ void access$endInteraction(NumberPicker $this) {
        $this.endInteraction();
    }

    public static final /* synthetic */ Tooltip access$getTooltip$p(NumberPicker $this) {
        return $this.tooltip;
    }

    public static final /* synthetic */ void access$setTooltip$p(NumberPicker $this, Tooltip tooltip) {
        $this.tooltip = tooltip;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lit/sephiroth/android/library/numberpicker/NumberPicker$OnNumberPickerChangeListener;", "", "onProgressChanged", "", "numberPicker", "Lit/sephiroth/android/library/numberpicker/NumberPicker;", "progress", "", "fromUser", "", "onStartTrackingTouch", "onStopTrackingTouch", "numberpicker_release"})
    public static interface OnNumberPickerChangeListener {
        public void onProgressChanged(@NotNull NumberPicker var1, int var2, boolean var3);

        public void onStartTrackingTouch(@NotNull NumberPicker var1);

        public void onStopTrackingTouch(@NotNull NumberPicker var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lit/sephiroth/android/library/numberpicker/NumberPicker$Companion;", "", "()V", "ARROW_BUTTON_FRAME_DELAY", "", "ARROW_BUTTON_INITIAL_DELAY", "FOCUSED_STATE_ARRAY", "", "getFOCUSED_STATE_ARRAY", "()[I", "LONG_TAP_TIMEOUT", "TRACKER_EXPONENTIAL", "", "TRACKER_LINEAR", "UNFOCUSED_STATE_ARRAY", "getUNFOCUSED_STATE_ARRAY", "numberpicker_release"})
    public static final class Companion {
        @NotNull
        public final int[] getFOCUSED_STATE_ARRAY() {
            return FOCUSED_STATE_ARRAY;
        }

        @NotNull
        public final int[] getUNFOCUSED_STATE_ARRAY() {
            return UNFOCUSED_STATE_ARRAY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

