/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.kotlin.android;

import android.content.Context;
import android.content.SharedPreferences;
import com.segment.analytics.kotlin.android.AndroidStorage$WhenMappings;
import com.segment.analytics.kotlin.android.utilities.AndroidKVS;
import com.segment.analytics.kotlin.core.Analytics;
import com.segment.analytics.kotlin.core.Storage;
import com.segment.analytics.kotlin.core.System;
import com.segment.analytics.kotlin.core.UserInfo;
import com.segment.analytics.kotlin.core.utilities.EventsFileManager;
import com.segment.analytics.kotlin.core.utilities.KVS;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sovran.kotlin.Store;
import sovran.kotlin.Subscriber;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/segment/analytics/kotlin/android/AndroidStorage;", "Lsovran/kotlin/Subscriber;", "Lcom/segment/analytics/kotlin/core/Storage;", "analytics", "Lcom/segment/analytics/kotlin/core/Analytics;", "context", "Landroid/content/Context;", "store", "Lsovran/kotlin/Store;", "writeKey", "", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/segment/analytics/kotlin/core/Analytics;Landroid/content/Context;Lsovran/kotlin/Store;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;)V", "getAnalytics$android_release", "()Lcom/segment/analytics/kotlin/core/Analytics;", "eventsFile", "Lcom/segment/analytics/kotlin/core/utilities/EventsFileManager;", "getEventsFile$android_release", "()Lcom/segment/analytics/kotlin/core/utilities/EventsFileManager;", "sharedPreferences", "Landroid/content/SharedPreferences;", "storageDirectory", "Ljava/io/File;", "read", "key", "Lcom/segment/analytics/kotlin/core/Storage$Constants;", "remove", "", "removeFile", "filePath", "subscribeToStore", "", "write", "value", "android_release"})
public final class AndroidStorage
implements Subscriber,
Storage {
    private final SharedPreferences sharedPreferences;
    private final File storageDirectory;
    @NotNull
    private final EventsFileManager eventsFile;
    @NotNull
    private final Analytics analytics;
    private final Store store;
    private final CoroutineDispatcher ioDispatcher;

    @NotNull
    public final EventsFileManager getEventsFile$android_release() {
        return this.eventsFile;
    }

    public void subscribeToStore() {
        this.store.subscribe((Subscriber)this, Reflection.getOrCreateKotlinClass(UserInfo.class), true, this.ioDispatcher, (Function1)new Function1<UserInfo, Unit>(this){

            public final void invoke(@NotNull UserInfo p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((AndroidStorage)this.receiver).userInfoUpdate(p1);
            }
        });
        this.store.subscribe((Subscriber)this, Reflection.getOrCreateKotlinClass(System.class), true, this.ioDispatcher, (Function1)new Function1<System, Unit>(this){

            public final void invoke(@NotNull System p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((AndroidStorage)this.receiver).systemUpdate(p1);
            }
        });
    }

    public void write(@NotNull Storage.Constants key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1: {
                if (value.length() < 32000) {
                    this.eventsFile.storeEvent(value);
                    break;
                }
                throw (Throwable)new Exception("enqueued payload is too large");
            }
            default: {
                this.sharedPreferences.edit().putString(key.getRawVal(), value).apply();
            }
        }
    }

    @Nullable
    public String read(@NotNull Storage.Constants key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$1[key.ordinal()]) {
            case 1: {
                string = CollectionsKt.joinToString$default((Iterable)this.eventsFile.read(), null, null, null, (int)0, null, null, (int)63, null);
                break;
            }
            default: {
                string = this.sharedPreferences.getString(key.getRawVal(), null);
            }
        }
        return string;
    }

    public boolean remove(@NotNull Storage.Constants key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$2[key.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                this.sharedPreferences.edit().putString(key.getRawVal(), null).apply();
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.eventsFile.remove(filePath);
    }

    @NotNull
    public final Analytics getAnalytics$android_release() {
        return this.analytics;
    }

    public AndroidStorage(@NotNull Analytics analytics, @NotNull Context context, @NotNull Store store, @NotNull String writeKey, @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)writeKey, (String)"writeKey");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        this.analytics = analytics;
        this.store = store;
        this.ioDispatcher = ioDispatcher;
        SharedPreferences sharedPreferences = context.getSharedPreferences("analytics-android-" + writeKey, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026y\", Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        File file = context.getDir("segment-disk-queue", 0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDir(\"segment-\u2026e\", Context.MODE_PRIVATE)");
        this.storageDirectory = file;
        this.eventsFile = new EventsFileManager(this.storageDirectory, writeKey, (KVS)new AndroidKVS(this.sharedPreferences));
    }

    public void systemUpdate(@NotNull System system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        Storage.DefaultImpls.systemUpdate((Storage)this, (System)system);
    }

    public void userInfoUpdate(@NotNull UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Storage.DefaultImpls.userInfoUpdate((Storage)this, (UserInfo)userInfo);
    }
}

