/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.google.common.base.Predicate;
import org.apache.maven.plugin.logging.Log;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

class WebDriverWaiter {
    static final String EXECUTION_FINISHED_SCRIPT = "return (window.jsApiReporter === undefined) ? false : window.jsApiReporter.finished";

    WebDriverWaiter() {
    }

    void waitForRunnerToFinish(WebDriver driver, int timeout, boolean debug, Log log) throws InterruptedException {
        final JavascriptExecutor executor = (JavascriptExecutor)driver;
        try {
            new WebDriverWait(driver, (long)timeout, 1000L).until((Predicate)new Predicate<WebDriver>(){

                public boolean apply(WebDriver input) {
                    return WebDriverWaiter.this.executionFinished(executor);
                }
            });
        }
        catch (TimeoutException e) {
            this.handleTimeout(timeout, debug, log);
        }
    }

    private Boolean executionFinished(JavascriptExecutor driver) {
        return (Boolean)driver.executeScript(EXECUTION_FINISHED_SCRIPT, new Object[0]);
    }

    private void handleTimeout(int timeout, boolean debug, Log log) {
        log.warn((CharSequence)("Attempted to wait for your specs to finish processing over the course of " + timeout + " seconds, but it still appears to be running."));
        if (!debug) {
            throw new IllegalStateException("Timeout occurred. Aborting execution of specs. (Try configuring 'debug' to 'true' for more details.)");
        }
        log.warn((CharSequence)"Debug mode: will attempt to parse the incomplete spec runner results");
    }
}

