/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;

public class ResourceRetriever {
    private final ResourceManager locator;
    private static final String ERROR_FILE_DNE = "Invalid value for parameter '%s'. File does not exist: %s";

    public ResourceRetriever(ResourceManager locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getResourceAsFile(String parameter, String resourceLocation, MavenProject mavenProject) throws MojoExecutionException {
        File file = null;
        if (resourceLocation != null) {
            this.locator.addSearchPath("url", "");
            this.locator.addSearchPath("file", mavenProject.getFile().getParentFile().getAbsolutePath());
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    file = this.locator.getResourceAsFile(resourceLocation);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format(ERROR_FILE_DNE, parameter, resourceLocation));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
        return file;
    }
}

