/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import java.io.Serializable;

public class ParsedHost
implements Serializable {
    private static final long serialVersionUID = 4L;
    private static final EmbeddedAddress NO_EMBEDDED_ADDRESS = new EmbeddedAddress();
    static final ParsedHostIdentifierStringQualifier NO_QUALIFIER = new ParsedHostIdentifierStringQualifier();
    private String[] normalizedLabels;
    private int[] separatorIndices;
    private boolean[] normalizedFlags;
    private final ParsedHostIdentifierStringQualifier labelsQualifier;
    private String service;
    private EmbeddedAddress embeddedAddress;
    String host;
    private final String originalStr;

    public ParsedHost(String originalStr, IPAddressProvider valueProvider) {
        this(originalStr, null, null, NO_QUALIFIER, new EmbeddedAddress());
        this.embeddedAddress.addressProvider = valueProvider;
    }

    public ParsedHost(String originalStr, IPAddressProvider valueProvider, ParsedHostIdentifierStringQualifier portQualifier) {
        this(originalStr, null, null, portQualifier, new EmbeddedAddress());
        this.embeddedAddress.addressProvider = valueProvider;
    }

    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier) {
        this(originalStr, separatorIndices, normalizedFlags, labelsQualifier, null);
    }

    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier, EmbeddedAddress embeddedAddress) {
        this.labelsQualifier = labelsQualifier;
        this.normalizedFlags = normalizedFlags;
        this.separatorIndices = separatorIndices;
        this.originalStr = originalStr;
        this.embeddedAddress = embeddedAddress == null ? NO_EMBEDDED_ADDRESS : embeddedAddress;
    }

    public boolean isIPv6Address() {
        return this.hasEmbeddedAddress() && this.getAddressProvider().isProvidingIPv6();
    }

    public Integer getPort() {
        return this.labelsQualifier.getPort();
    }

    public String getService() {
        CharSequence sv;
        String serv = this.service;
        if (serv == null && (sv = this.labelsQualifier.getService()) != null) {
            this.service = serv = sv.toString();
        }
        return serv;
    }

    public Integer getNetworkPrefixLength() {
        return this.labelsQualifier.getNetworkPrefixLength();
    }

    public Integer getEquivalentPrefixLength() {
        return this.labelsQualifier.getEquivalentPrefixLength();
    }

    public IPAddress getMask() {
        return this.labelsQualifier.getMask();
    }

    public IPAddressProvider getAddressProvider() {
        return this.embeddedAddress.addressProvider;
    }

    private boolean hasEmbeddedAddress() {
        return this.embeddedAddress.addressProvider != null;
    }

    public boolean isAddressString() {
        return this.getAddressProvider() != null;
    }

    public IPAddress asAddress(IPAddress.IPVersion version) {
        if (this.hasEmbeddedAddress()) {
            return this.getAddressProvider().getProviderAddress(version);
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.hasEmbeddedAddress()) {
            return this.getAddressProvider().getProviderAddress();
        }
        return null;
    }

    public IPAddressString asGenericAddressString() {
        if (this.hasEmbeddedAddress()) {
            IPAddressProvider addressProvider = this.getAddressProvider();
            if (addressProvider.isProvidingAllAddresses()) {
                return new IPAddressString(IPAddress.SEGMENT_WILDCARD_STR, addressProvider.getParameters());
            }
            if (addressProvider.isProvidingPrefixOnly()) {
                return new IPAddressString(IPAddressNetwork.getPrefixString(addressProvider.getProviderNetworkPrefixLength()), addressProvider.getParameters());
            }
            if (addressProvider.isProvidingEmpty()) {
                return new IPAddressString("", addressProvider.getParameters());
            }
            IPAddress addr = addressProvider.getProviderAddress();
            return addr.toAddressString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNormalizedLabels() {
        String[] labels = this.normalizedLabels;
        if (labels == null) {
            ParsedHost parsedHost = this;
            synchronized (parsedHost) {
                labels = this.normalizedLabels;
                if (labels == null) {
                    if (this.hasEmbeddedAddress()) {
                        IPAddressProvider addressProvider = this.getAddressProvider();
                        IPAddress addr = addressProvider.getProviderAddress();
                        if (addr == null) {
                            if (addressProvider.isProvidingEmpty()) {
                                return new String[0];
                            }
                            return new String[]{this.asGenericAddressString().toString()};
                        }
                        IPAddressSection section = addr.getSection();
                        labels = section.getSegmentStrings();
                    } else {
                        labels = new String[this.separatorIndices.length];
                        int i = 0;
                        int lastSep = -1;
                        while (i < labels.length) {
                            int index = this.separatorIndices[i];
                            if (this.normalizedFlags != null && !this.normalizedFlags[i]) {
                                StringBuilder second = new StringBuilder(index - lastSep - 1);
                                int j = lastSep + 1;
                                while (j < index) {
                                    char c = this.originalStr.charAt(j);
                                    second.append(c >= 'A' && c <= 'Z' ? (char)(c + 32) : c);
                                    ++j;
                                }
                                labels[i] = second.toString();
                            } else {
                                labels[i] = this.originalStr.substring(lastSep + 1, index);
                            }
                            lastSep = index;
                            ++i;
                        }
                        this.separatorIndices = null;
                        this.normalizedFlags = null;
                    }
                    this.normalizedLabels = labels;
                }
            }
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        String str = this.host;
        if (str == null) {
            if (this.originalStr.length() > 0) {
                ParsedHost parsedHost = this;
                synchronized (parsedHost) {
                    str = this.host;
                    if (str == null) {
                        if (this.hasEmbeddedAddress()) {
                            IPAddressProvider addressProvider = this.getAddressProvider();
                            IPAddress addr = addressProvider.getProviderAddress();
                            if (addr == null) {
                                return this.asGenericAddressString().toString();
                            }
                            return addr.getSection().toCanonicalWildcardString();
                        }
                        StringBuilder builder = new StringBuilder(this.originalStr.length());
                        String[] labels = this.getNormalizedLabels();
                        builder.append(labels[0]);
                        int i = 1;
                        while (i < labels.length) {
                            builder.append('.').append(labels[i]);
                            ++i;
                        }
                        str = builder.toString();
                    }
                }
            } else {
                str = this.originalStr;
            }
            this.host = str;
        }
        return str;
    }

    public AddressStringException getAddressStringException() {
        return this.embeddedAddress.addressStringException;
    }

    public boolean isUNCIPv6Literal() {
        return this.embeddedAddress.isUNCIPv6Literal;
    }

    public boolean isReverseDNS() {
        return this.embeddedAddress.isReverseDNS;
    }

    static class EmbeddedAddress
    implements Serializable {
        private static final long serialVersionUID = 4L;
        boolean isUNCIPv6Literal;
        boolean isReverseDNS;
        AddressStringException addressStringException;
        IPAddressProvider addressProvider;

        EmbeddedAddress() {
        }
    }
}

