/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.InconsistentPrefixException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressStringDivision;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressStringWriter;
import java.util.Arrays;

public class IPAddressDivisionGrouping
extends AddressDivisionGrouping
implements IPAddressStringDivisionSeries {
    private static final long serialVersionUID = 4L;
    private final IPAddressNetwork<?, ?, ?, ?, ?> network;
    protected static final RangeCache ZEROS_CACHE = new RangeCache();

    static {
        if (RangeCache.PRELOAD_CACHE) {
            ZEROS_CACHE.preloadCache(-1);
        }
    }

    public IPAddressDivisionGrouping(IPAddressDivision[] divisions, IPAddressNetwork<?, ?, ?, ?, ?> network) throws AddressValueException {
        super(divisions);
        if (network == null) {
            throw new NullPointerException(IPAddressDivisionGrouping.getMessage("ipaddress.error.nullNetwork"));
        }
        this.network = network;
        int totalPrefixBits = 0;
        int i = 0;
        while (i < divisions.length) {
            IPAddressDivision division = divisions[i];
            Integer divPrefix = division.getDivisionPrefixLength();
            if (divPrefix != null) {
                this.cachedPrefixLength = totalPrefixBits + divPrefix;
                ++i;
                while (i < divisions.length) {
                    division = divisions[i];
                    divPrefix = division.getDivisionPrefixLength();
                    if (divPrefix == null || divPrefix != 0) {
                        throw new InconsistentPrefixException((AddressItem)divisions[i - 1], (AddressItem)division, divPrefix);
                    }
                    ++i;
                }
                return;
            }
            totalPrefixBits += division.getBitCount();
            ++i;
        }
        this.cachedPrefixLength = -1;
    }

    protected IPAddressDivisionGrouping(IPAddressDivision[] divisions, boolean checkSegs) {
        super(divisions, checkSegs);
        this.network = this.getNetwork();
        if (this.network == null) {
            throw new NullPointerException(IPAddressDivisionGrouping.getMessage("ipaddress.error.nullNetwork"));
        }
    }

    @Override
    public IPAddressNetwork<?, ?, ?, ?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public IPAddressDivision getDivision(int index) {
        return (IPAddressDivision)super.getDivision(index);
    }

    @Override
    public int isMore(AddressDivisionSeries other) {
        if (!this.isMultiple()) {
            return other.isMultiple() ? -1 : 0;
        }
        if (!other.isMultiple()) {
            return 1;
        }
        if (this.isSinglePrefixBlock() && other.isSinglePrefixBlock()) {
            int bits = this.getBitCount() - this.getPrefixLength();
            int otherBits = other.getBitCount() - other.getPrefixLength();
            return bits - otherBits;
        }
        return this.getCount().compareTo(other.getCount());
    }

    @Override
    public boolean isPrefixed() {
        return this.getNetworkPrefixLength() != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.getNetworkPrefixLength();
    }

    protected Integer calculatePrefix() {
        int result = 0;
        int count = this.getDivisionCount();
        int i = 0;
        while (i < count) {
            IPAddressDivision div = this.getDivision(i);
            Integer prefix = div.getDivisionPrefixLength();
            if (prefix != null) {
                return result += prefix.intValue();
            }
            result += div.getBitCount();
            ++i;
        }
        return null;
    }

    public Integer getNetworkPrefixLength() {
        Integer ret = this.cachedPrefixLength;
        if (ret == null) {
            Integer result;
            int count = this.getDivisionCount();
            if (count > 0 && (!this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() || this.getDivision(count - 1).isPrefixed()) && (result = this.calculatePrefix()) != null) {
                this.cachedPrefixLength = result;
                return this.cachedPrefixLength;
            }
            this.cachedPrefixLength = -1;
            return null;
        }
        if (ret == -1) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean isPrefixBlock() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null) {
            return false;
        }
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            IPAddressDivision div = this.getDivision(i);
            Integer segmentPrefixLength = div.getDivisionPrefixLength();
            if (segmentPrefixLength != null) {
                if (!div.isPrefixBlock(segmentPrefixLength)) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isSinglePrefixBlock() {
        int count = this.getDivisionCount();
        boolean isAllSubnets = this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int i = 0;
        while (i < count) {
            IPAddressDivision div = this.getDivision(i);
            Integer divPrefix = div.getDivisionPrefixLength();
            if (isAllSubnets && divPrefix != null && divPrefix == 0) break;
            if (!div.isSinglePrefixBlock()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            int totalPrefix = 0;
            int divCount = this.getDivisionCount();
            int i = 0;
            while (i < divCount) {
                int segPrefix;
                IPAddressDivision div = this.getDivision(i);
                if (!div.isSinglePrefixBlock(segPrefix = div.getMinPrefixLengthForBlock())) {
                    return null;
                }
                if (div.isPrefixed()) {
                    return totalPrefix + segPrefix;
                }
                if (segPrefix < div.getBitCount()) {
                    ++i;
                    while (i < divCount) {
                        IPAddressDivision laterDiv = this.getDivision(i);
                        if (!laterDiv.isFullRange()) {
                            return null;
                        }
                        if (laterDiv.isPrefixed()) break;
                        ++i;
                    }
                    return totalPrefix + segPrefix;
                }
                totalPrefix += segPrefix;
                ++i;
            }
            return totalPrefix;
        }
        return super.getPrefixLengthForSingleBlock();
    }

    public boolean includesZeroHost() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return false;
        }
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            IPAddressDivision div = this.getDivision(i);
            Integer segmentPrefixLength = div.getDivisionPrefixLength();
            if (segmentPrefixLength != null) {
                long mask = ~(-1 << div.getBitCount() - segmentPrefixLength);
                if ((mask & div.getLowerValue()) != 0L) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.getDivision(i);
                    if (!div.includesZero()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressDivisionGrouping) {
            IPAddressDivisionGrouping other = (IPAddressDivisionGrouping)o;
            return other.isSameGrouping(this);
        }
        return false;
    }

    public RangeList getZeroSegments() {
        return this.getZeroSegments(false);
    }

    public RangeList getZeroRangeSegments() {
        if (this.isPrefixed()) {
            return this.getZeroSegments(true);
        }
        return this.getZeroSegments();
    }

    protected static RangeList getNoZerosRange() {
        return RangeCache.NO_ZEROS;
    }

    protected static RangeList getSingleRange(int index, int len) {
        RangeCache cache = ZEROS_CACHE.addRange(index, -1, len);
        return cache.get();
    }

    protected RangeList getZeroSegments(boolean includeRanges) {
        RangeCache cache = ZEROS_CACHE;
        int divisionCount = this.getDivisionCount();
        boolean isFullRangeHost = !this.getNetwork().getPrefixConfiguration().prefixedSubnetsAreExplicit() && this.isPrefixBlock();
        includeRanges &= isFullRangeHost;
        int currentIndex = -1;
        int lastIndex = -1;
        int currentCount = 0;
        int i = 0;
        while (i < divisionCount) {
            boolean isCompressible;
            IPAddressDivision division = this.getDivision(i);
            boolean bl = isCompressible = division.isZero() || includeRanges && division.isSinglePrefixBlock(0L, division.getDivisionPrefixLength());
            if (isCompressible) {
                if (++currentCount == 1) {
                    currentIndex = i;
                }
                if (i == divisionCount - 1) {
                    cache = cache.addRange(currentIndex, lastIndex, currentCount);
                    lastIndex = currentIndex + currentCount;
                }
            } else if (currentCount > 0) {
                cache = cache.addRange(currentIndex, lastIndex, currentCount);
                lastIndex = currentIndex + currentCount;
                currentCount = 0;
            }
            ++i;
        }
        return cache.get();
    }

    protected static class IPAddressStringParams<T extends IPAddressStringDivisionSeries>
    extends AddressDivisionGrouping.AddressStringParams<T>
    implements IPAddressStringWriter<T> {
        public static final IPAddressSection.WildcardOptions.WildcardOption DEFAULT_WILDCARD_OPTION = IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY;
        protected static final int EXTRA_SPACE = 16;
        private IPAddressSection.WildcardOptions.WildcardOption wildcardOption = DEFAULT_WILDCARD_OPTION;
        private int[] expandSegment;
        private String addressSuffix = "";

        public IPAddressStringParams(int radix, Character separator, boolean uppercase) {
            this(radix, separator, uppercase, '\u0000');
        }

        public IPAddressStringParams(int radix, Character separator, boolean uppercase, char zoneSeparator) {
            super(radix, separator, uppercase, zoneSeparator);
        }

        public String getAddressSuffix() {
            return this.addressSuffix;
        }

        public void setAddressSuffix(String suffix) {
            this.addressSuffix = suffix;
        }

        @Override
        public boolean preferWildcards() {
            return this.wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
        }

        public void setWildcardOption(IPAddressSection.WildcardOptions.WildcardOption option) {
            this.wildcardOption = option;
        }

        public int getExpandedSegmentLength(int segmentIndex) {
            if (this.expandSegment == null || this.expandSegment.length <= segmentIndex) {
                return 0;
            }
            return this.expandSegment[segmentIndex];
        }

        public void expandSegment(int index, int expansionLength, int segmentCount) {
            if (this.expandSegment == null) {
                this.expandSegment = new int[segmentCount];
            }
            this.expandSegment[index] = expansionLength;
        }

        @Override
        public char getTrailingSegmentSeparator() {
            return this.separator.charValue();
        }

        public StringBuilder appendSuffix(StringBuilder builder) {
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                builder.append(suffix);
            }
            return builder;
        }

        public int getAddressSuffixLength() {
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                return suffix.length();
            }
            return 0;
        }

        @Override
        public int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            if (this.expandSegment != null && this.expandSegment.length > segmentIndex) {
                return this.expandSegment[segmentIndex];
            }
            return 0;
        }

        @Override
        public IPAddressStringParams<T> clone() {
            IPAddressStringParams parms = (IPAddressStringParams)super.clone();
            if (this.expandSegment != null) {
                parms.expandSegment = (int[])this.expandSegment.clone();
            }
            return parms;
        }

        @Override
        public int getTrailingSeparatorCount(T addr) {
            int count = addr.getDivisionCount();
            if (count > 0) {
                return count - 1;
            }
            return 0;
        }

        public static int getPrefixIndicatorStringLength(IPAddressStringDivisionSeries addr) {
            if (addr.isPrefixed()) {
                return AddressDivision.toUnsignedStringLengthFast(addr.getPrefixLength(), 10) + 1;
            }
            return 0;
        }

        @Override
        public int getStringLength(T addr) {
            int count = this.getSegmentsStringLength(addr);
            if (!this.isReverse() && !this.preferWildcards()) {
                count += IPAddressStringParams.getPrefixIndicatorStringLength(addr);
            }
            return count + this.getAddressSuffixLength() + this.getAddressLabelLength();
        }

        public void appendPrefixIndicator(StringBuilder builder, IPAddressStringDivisionSeries addr) {
            if (addr.isPrefixed()) {
                builder.append('/').append(addr.getPrefixLength());
            }
        }

        @Override
        public StringBuilder append(StringBuilder builder, T addr, CharSequence zone) {
            this.appendLabel(builder);
            this.appendSegments(builder, addr);
            if (zone != null) {
                this.appendZone(builder, zone);
            }
            this.appendSuffix(builder);
            if (!this.isReverse() && !this.preferWildcards()) {
                this.appendPrefixIndicator(builder, (IPAddressStringDivisionSeries)addr);
            }
            return builder;
        }

        @Override
        protected int appendSegment(int segmentIndex, StringBuilder builder, T part) {
            Integer prefix;
            IPAddressStringDivision seg = part.getDivision(segmentIndex);
            AddressNetwork.PrefixConfiguration config = part.getNetwork().getPrefixConfiguration();
            if (config.prefixedSubnetsAreExplicit() || this.preferWildcards() || (prefix = seg.getDivisionPrefixLength()) == null || prefix >= seg.getBitCount() || config.zeroHostsAreSubnets() && !part.isPrefixBlock() || this.isSplitDigits()) {
                return seg.getStandardString(segmentIndex, this, builder);
            }
            if (seg.isSinglePrefixBlock()) {
                return seg.getLowerStandardString(segmentIndex, this, builder);
            }
            return seg.getPrefixAdjustedRangeString(segmentIndex, this, builder);
        }
    }

    public static class Range {
        public final int index;
        public final int length;

        Range(int index, int length) {
            this.index = index;
            this.length = length;
        }

        public String toString() {
            return "[" + this.index + ',' + (this.index + this.length) + ']';
        }
    }

    private static class RangeCache {
        static boolean PRELOAD_CACHE;
        static final int MAX_DIVISION_COUNT = 8;
        static final RangeList NO_ZEROS;
        RangeCache[][] nextRange;
        RangeCache parent;
        RangeList zeroRanges;
        Range range;

        static {
            NO_ZEROS = new RangeList(new Range[0]);
        }

        RangeCache() {
            this(null, 8, null);
            this.zeroRanges = NO_ZEROS;
        }

        private RangeCache(RangeCache parent, int potentialZeroOffsets, Range range) {
            if (potentialZeroOffsets > 0) {
                this.nextRange = new RangeCache[potentialZeroOffsets][];
                int i = 0;
                while (i < potentialZeroOffsets) {
                    this.nextRange[i] = new RangeCache[potentialZeroOffsets - i];
                    ++i;
                }
            }
            this.parent = parent;
            this.range = range;
        }

        private void get(Range[] ranges, int rangesIndex) {
            ranges[--rangesIndex] = this.range;
            if (rangesIndex > 0) {
                this.parent.get(ranges, rangesIndex);
            }
        }

        public RangeList get() {
            RangeList result = this.zeroRanges;
            if (result == null) {
                int depth = 0;
                RangeCache up = this.parent;
                while (up != null) {
                    ++depth;
                    up = up.parent;
                }
                Range[] ranges = new Range[depth];
                if (depth > 0) {
                    ranges[--depth] = this.range;
                    if (depth > 0) {
                        this.parent.get(ranges, depth);
                    }
                }
                this.zeroRanges = result = new RangeList(ranges);
            }
            return result;
        }

        void preloadCache(int lastIndex) {
            if (this.nextRange != null) {
                int j;
                RangeCache[] next;
                int i = 0;
                while (i < this.nextRange.length) {
                    next = this.nextRange[i];
                    j = 0;
                    while (j < next.length) {
                        Range newRange = lastIndex == -1 ? new Range(i + lastIndex + 1, j + 1) : IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[i + lastIndex + 1][j].range;
                        int nextPotentialZeroIndex = i + lastIndex + j + 3;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        RangeCache newRangeCache = new RangeCache(this, remainingPotentialZeroOffsets, newRange);
                        newRangeCache.get();
                        next[j] = newRangeCache;
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.nextRange.length) {
                    next = this.nextRange[i];
                    j = 0;
                    while (j < next.length) {
                        RangeCache nextCache = next[j];
                        Range nextRange = nextCache.range;
                        nextCache.preloadCache(nextRange.index + nextRange.length);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RangeCache addRange(int currentIndex, int lastIndex, int currentCount) {
            int offset = currentIndex - lastIndex;
            int cacheOffset = offset - 1;
            int cacheCount = currentCount - 1;
            RangeCache next = this.nextRange[cacheOffset][cacheCount];
            if (next == null) {
                RangeCache rangeCache = this;
                synchronized (rangeCache) {
                    next = this.nextRange[cacheOffset][cacheCount];
                    if (next == null) {
                        Range newRange;
                        int nextPotentialZeroIndex = lastIndex + 1;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        if (this == ZEROS_CACHE) {
                            newRange = new Range(currentIndex, currentCount);
                        } else {
                            RangeCache rootNext = IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[currentIndex][currentCount - 1];
                            if (rootNext == null) {
                                newRange = new Range(currentIndex, currentCount);
                                IPAddressDivisionGrouping.ZEROS_CACHE.nextRange[currentIndex][currentCount - 1] = new RangeCache(ZEROS_CACHE, 8, newRange);
                            } else {
                                newRange = rootNext.range;
                            }
                        }
                        this.nextRange[cacheOffset][cacheCount] = next = new RangeCache(this, remainingPotentialZeroOffsets, newRange);
                    }
                }
            }
            return next;
        }
    }

    public static class RangeList {
        final Range[] ranges;

        RangeList(Range[] ranges) {
            if (ranges == null) {
                throw new NullPointerException();
            }
            this.ranges = ranges;
        }

        public int size() {
            return this.ranges.length;
        }

        public Range getRange(int index) {
            return this.ranges[index];
        }

        public String toString() {
            return Arrays.asList(this.ranges).toString();
        }
    }
}

