/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import java.util.Iterator;

public abstract class IPAddressSegment
extends IPAddressDivision
implements AddressSegment {
    private static final long serialVersionUID = 4L;
    private final int value;
    private final int upperValue;

    protected IPAddressSegment(int value) {
        if (value < 0) {
            throw new AddressValueException(value);
        }
        this.value = this.upperValue = value;
    }

    protected IPAddressSegment(int value, Integer segmentPrefixLength) {
        this(value, value, segmentPrefixLength);
    }

    protected IPAddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(segmentPrefixLength);
        if (lower < 0 || upper < 0) {
            throw new AddressValueException(lower < 0 ? lower : upper);
        }
        if (lower > upper) {
            int tmp = lower;
            lower = upper;
            upper = tmp;
        }
        if ((segmentPrefixLength = this.getSegmentPrefixLength()) == null || segmentPrefixLength >= this.getBitCount() || !this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            this.value = lower;
            this.upperValue = upper;
        } else {
            int mask = this.getSegmentNetworkMask(segmentPrefixLength);
            this.value = lower & mask;
            this.upperValue = upper | this.getSegmentHostMask(segmentPrefixLength);
        }
    }

    public abstract IPAddressNetwork<?, ?, ?, ?, ?> getNetwork();

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public abstract IPAddress.IPVersion getIPVersion();

    protected static Integer getSplitSegmentPrefix(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        return IPAddressSection.getSplitSegmentPrefixLength(bitsPerSegment, networkPrefixLength, segmentIndex);
    }

    @Override
    protected long getDivisionNetworkMask(int bits) {
        return this.getSegmentNetworkMask(bits);
    }

    @Override
    protected long getDivisionHostMask(int bits) {
        return this.getSegmentHostMask(bits);
    }

    protected abstract int getSegmentNetworkMask(int var1);

    protected abstract int getSegmentHostMask(int var1);

    @Override
    public int getMinPrefixLengthForBlock() {
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && this.isPrefixed() && this.getSegmentPrefixLength() == 0) {
            return 0;
        }
        return super.getMinPrefixLengthForBlock();
    }

    public static int getMaxSegmentValue(IPAddress.IPVersion version) {
        return version.isIPv4() ? 255 : 65535;
    }

    protected boolean isChangedByPrefix(Integer bits, boolean smallerOnly) {
        boolean hasBits;
        boolean bl = hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, bits);
        }
        if (smallerOnly) {
            if (this.isPrefixed()) {
                return hasBits && bits < this.getSegmentPrefixLength();
            }
        } else if (this.isPrefixed()) {
            return !hasBits || bits.intValue() != this.getSegmentPrefixLength().intValue();
        }
        return hasBits;
    }

    protected <S extends IPAddressSegment> S toPrefixedSegment(Integer segmentPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        boolean hasBits;
        int lower = this.getLowerSegmentValue();
        int upper = this.getUpperSegmentValue();
        boolean bl = hasBits = segmentPrefixLength != null;
        if (lower != upper) {
            if (!hasBits) {
                return (S)((IPAddressSegment)creator.createSegment(lower, upper, null));
            }
            return (S)((IPAddressSegment)creator.createSegment(lower, upper, segmentPrefixLength));
        }
        return (S)(hasBits ? (IPAddressSegment)creator.createSegment(lower, segmentPrefixLength) : (IPAddressSegment)creator.createSegment(lower));
    }

    @Override
    public boolean isPrefixBlock() {
        return this.isPrefixed() && this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() || super.isPrefixBlock();
    }

    protected boolean isNetworkChangedByPrefix(Integer bits, boolean withPrefixLength) {
        boolean hasBits;
        boolean bl = hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, bits);
        }
        boolean thisHasPrefix = this.isPrefixed();
        if ((withPrefixLength &= hasBits) != thisHasPrefix) {
            return true;
        }
        return !this.isPrefixBlock(bits);
    }

    public IPAddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        return this.toNetworkSegment(segmentPrefixLength, true);
    }

    public abstract IPAddressSegment toNetworkSegment(Integer var1, boolean var2);

    protected <S extends IPAddressSegment> S toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        int newLower = this.getLowerSegmentValue();
        int newUpper = this.getUpperSegmentValue();
        if (segmentPrefixLength != null) {
            int mask = this.getSegmentNetworkMask(segmentPrefixLength);
            newLower &= mask;
            newUpper |= this.getSegmentHostMask(segmentPrefixLength);
        }
        boolean hasBits = segmentPrefixLength != null;
        withPrefixLength &= hasBits;
        if (newLower != newUpper) {
            if (!withPrefixLength) {
                return (S)((IPAddressSegment)creator.createSegment(newLower, newUpper, null));
            }
            return (S)((IPAddressSegment)creator.createSegment(newLower, newUpper, segmentPrefixLength));
        }
        return (S)(withPrefixLength ? (IPAddressSegment)creator.createSegment(newLower, segmentPrefixLength) : (IPAddressSegment)creator.createSegment(newLower));
    }

    public abstract IPAddressSegment toHostSegment(Integer var1);

    protected <S extends IPAddressSegment> S toHostSegment(Integer segmentPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        int newUpper;
        int mask = segmentPrefixLength == null ? 0 : this.getSegmentHostMask(segmentPrefixLength);
        int newLower = this.getLowerSegmentValue() & mask;
        if (newLower != (newUpper = this.getUpperSegmentValue() & mask)) {
            return (S)((IPAddressSegment)creator.createSegment(newLower, newUpper, null));
        }
        return (S)((IPAddressSegment)creator.createSegment(newLower));
    }

    protected boolean isHostChangedByPrefix(Integer bits) {
        boolean hasBits;
        boolean bl = hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, bits);
        }
        if (this.isPrefixed()) {
            return true;
        }
        int mask = !hasBits ? 0 : this.getSegmentHostMask(bits);
        int value = this.getLowerSegmentValue();
        int upperValue = this.getUpperSegmentValue();
        return value != (value & mask) || upperValue != (upperValue & mask);
    }

    protected boolean isChangedByMask(int maskValue, Integer segmentPrefixLength) throws IncompatibleAddressException {
        boolean hasBits;
        boolean bl = hasBits = segmentPrefixLength != null;
        if (hasBits && (segmentPrefixLength < 0 || segmentPrefixLength > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, segmentPrefixLength);
        }
        int value = this.getLowerSegmentValue();
        int upperValue = this.getUpperSegmentValue();
        return value != (value & maskValue) || upperValue != (upperValue & maskValue) || !(this.isPrefixed() ? this.getSegmentPrefixLength().equals(segmentPrefixLength) : !hasBits);
    }

    protected boolean isChangedByOr(int maskValue, Integer segmentPrefixLength) throws IncompatibleAddressException {
        boolean hasBits;
        boolean bl = hasBits = segmentPrefixLength != null;
        if (hasBits && (segmentPrefixLength < 0 || segmentPrefixLength > this.getBitCount())) {
            throw new PrefixLenException((AddressItem)this, segmentPrefixLength);
        }
        int value = this.getLowerSegmentValue();
        int upperValue = this.getUpperSegmentValue();
        return value != (value | maskValue) || upperValue != (upperValue | maskValue) || !(this.isPrefixed() ? this.getSegmentPrefixLength().equals(segmentPrefixLength) : !hasBits);
    }

    public boolean isMaskCompatibleWithRange(int maskValue, Integer segmentPrefixLength) throws PrefixLenException {
        return super.isMaskCompatibleWithRange(maskValue, segmentPrefixLength, this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets());
    }

    public boolean isBitwiseOrCompatibleWithRange(int maskValue, Integer segmentPrefixLength) throws PrefixLenException {
        return super.isBitwiseOrCompatibleWithRange(maskValue, segmentPrefixLength, this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets());
    }

    @Override
    public abstract IPAddressSegment getLower();

    @Override
    public abstract IPAddressSegment getUpper();

    protected static <S extends IPAddressSegment> S getLowestOrHighest(S original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, boolean lowest) {
        if (!original.isMultiple() && !original.isPrefixed()) {
            return original;
        }
        return (S)((IPAddressSegment)segmentCreator.createSegment(lowest ? original.getLowerSegmentValue() : original.getUpperSegmentValue(), original.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() ? null : original.getSegmentPrefixLength()));
    }

    public abstract Iterable<? extends IPAddressSegment> getIterable();

    public abstract Iterator<? extends IPAddressSegment> iterator();

    public static int getBitCount(IPAddress.IPVersion version) {
        return version.isIPv4() ? 8 : 16;
    }

    public static int getByteCount(IPAddress.IPVersion version) {
        return version.isIPv4() ? 1 : 2;
    }

    public static int getDefaultTextualRadix(IPAddress.IPVersion version) {
        return version.isIPv4() ? 10 : 16;
    }

    @Override
    public boolean matches(int value) {
        return super.matches(value);
    }

    public boolean matchesWithPrefixMask(int value, Integer segmentPrefixLength) {
        return super.matchesWithPrefixMask(value, segmentPrefixLength);
    }

    @Override
    public boolean matchesWithMask(int value, int mask) {
        return super.matchesWithMask(value, mask);
    }

    @Override
    public boolean matchesWithMask(int lowerValue, int upperValue, int mask) {
        return super.matchesWithMask(lowerValue, upperValue, mask);
    }

    @Override
    public int getValueCount() {
        return this.getUpperSegmentValue() - this.getLowerSegmentValue() + 1;
    }

    @Override
    public long getDivisionValueCount() {
        return this.getValueCount();
    }

    protected int highByte() {
        return IPAddressSegment.highByte(this.getLowerSegmentValue());
    }

    protected int lowByte() {
        return IPAddressSegment.lowByte(this.getLowerSegmentValue());
    }

    protected static int highByte(int value) {
        return value >> 8;
    }

    protected static int lowByte(int value) {
        return value & 0xFF;
    }

    @Override
    public long getMaxValue() {
        return this.getMaxSegmentValue();
    }

    @Override
    public boolean isMultiple() {
        return this.getLowerSegmentValue() != this.getUpperSegmentValue();
    }

    @Override
    public int getLowerSegmentValue() {
        return this.value;
    }

    @Override
    public int getUpperSegmentValue() {
        return this.upperValue;
    }

    @Override
    public long getLowerValue() {
        return this.getLowerSegmentValue();
    }

    @Override
    public long getUpperValue() {
        return this.getUpperSegmentValue();
    }

    @Override
    public abstract IPAddressSegment reverseBits(boolean var1);

    @Override
    public abstract IPAddressSegment reverseBytes();

    public abstract IPAddressSegment removePrefixLength();

    public abstract IPAddressSegment removePrefixLength(boolean var1);

    protected static <S extends IPAddressSegment> S removePrefix(S original, boolean zeroed, AddressNetwork.AddressSegmentCreator<S> creator) {
        if (original.isPrefixed()) {
            int lower = original.getLowerSegmentValue();
            int upper = original.getUpperSegmentValue();
            if (zeroed) {
                int maskBits = original.getSegmentNetworkMask(original.getSegmentPrefixLength());
                if (!original.isMaskCompatibleWithRange(maskBits, null)) {
                    throw new IncompatibleAddressException(original, maskBits, "ipaddress.error.maskMismatch");
                }
                return (S)((IPAddressSegment)creator.createSegment(lower & maskBits, upper & maskBits, null));
            }
            return (S)((IPAddressSegment)creator.createSegment(lower, upper, null));
        }
        return original;
    }

    @Override
    public boolean isBoundedBy(int value) {
        return this.getUpperSegmentValue() < value;
    }

    public Integer getSegmentPrefixLength() {
        return this.getDivisionPrefixLength();
    }

    @Override
    protected boolean isSameValues(AddressDivision other) {
        if (other instanceof IPAddressSegment) {
            return this.isSameValues((IPAddressSegment)other);
        }
        return false;
    }

    protected boolean isSameValues(IPAddressSegment otherSegment) {
        return this.getLowerSegmentValue() == otherSegment.getLowerSegmentValue() && this.getUpperSegmentValue() == otherSegment.getUpperSegmentValue();
    }

    public int hashCode() {
        return IPAddressSegment.hash(this.getLowerSegmentValue(), this.getUpperSegmentValue(), this.getBitCount());
    }

    static int hash(int lower, int upper, int bitCount) {
        return lower | upper << bitCount;
    }

    @Override
    public boolean contains(AddressSegment other) {
        return other instanceof IPAddressSegment && other.getLowerSegmentValue() >= this.getLowerSegmentValue() && other.getUpperSegmentValue() <= this.getUpperSegmentValue();
    }

    @Override
    public boolean includesZero() {
        return this.getLowerSegmentValue() == 0;
    }

    @Override
    public boolean includesMax() {
        return this.getUpperSegmentValue() == this.getMaxSegmentValue();
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        return this.toNormalizedString(with0xPrefix ? IPAddressSection.IPStringCache.hexPrefixedParams : IPAddressSection.IPStringCache.hexParams);
    }

    @Override
    public String toNormalizedString() {
        return this.toNormalizedString(IPAddressSection.IPStringCache.canonicalSegmentParams);
    }

    public String toNormalizedString(IPAddressSection.IPStringOptions options) {
        IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPAddressSection.toIPParams(options);
        StringBuilder builder = new StringBuilder(params.getDivisionStringLength(this));
        return params.appendDivision(builder, this).toString();
    }

    protected static int toUnsignedStringLength(int value, int radix) {
        return AddressDivision.toUnsignedStringLength(value, radix);
    }

    protected static StringBuilder toUnsignedString(int value, int radix, StringBuilder appendable) {
        return IPAddressSegment.toUnsignedString(value, radix, 0, false, DIGITS, appendable);
    }

    void setStandardString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int originalLowerValue) {
        if (this.cachedString == null && isStandardString && (long)originalLowerValue == this.getLowerValue()) {
            this.cachedString = addressStr.subSequence(lowerStringStartIndex, lowerStringEndIndex).toString();
        }
    }

    void setWildcardString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int lowerValue) {
        if (this.cachedWildcardString == null && isStandardString && (long)lowerValue == this.getLowerValue() && (long)lowerValue == this.getUpperValue()) {
            this.cachedWildcardString = addressStr.subSequence(lowerStringStartIndex, lowerStringEndIndex).toString();
        }
    }

    void setStandardString(CharSequence addressStr, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedString == null) {
            if (this.isSinglePrefixBlock()) {
                if (isStandardString && (long)rangeLower == this.getLowerValue()) {
                    this.cachedString = addressStr.subSequence(lowerStringStartIndex, lowerStringEndIndex).toString();
                }
            } else if (this.isFullRange()) {
                this.cachedString = IPAddress.SEGMENT_WILDCARD_STR;
            } else if (isStandardRangeString && (long)rangeLower == this.getLowerValue()) {
                long upper = this.getUpperValue();
                if (this.isPrefixed()) {
                    upper &= this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                }
                if ((long)rangeUpper == upper) {
                    this.cachedString = addressStr.subSequence(lowerStringStartIndex, upperStringEndIndex).toString();
                }
            }
        }
    }

    void setWildcardString(CharSequence addressStr, boolean isStandardRangeString, int lowerStringStartIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedWildcardString == null) {
            if (this.isFullRange()) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
            } else if (isStandardRangeString && (long)rangeLower == this.getLowerValue() && (long)rangeUpper == this.getUpperValue()) {
                this.cachedWildcardString = addressStr.subSequence(lowerStringStartIndex, upperStringEndIndex).toString();
            }
        }
    }
}

