/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;

public class IPv6Address
extends IPAddress
implements Iterable<IPv6Address> {
    private static final long serialVersionUID = 3L;
    public static final char SEGMENT_SEPARATOR = ':';
    public static final char ZONE_SEPARATOR = '%';
    public static final char ALTERNATIVE_ZONE_SEPARATOR = '\u00a7';
    public static final char UNC_SEGMENT_SEPARATOR = '-';
    public static final char UNC_ZONE_SEPARATOR = 's';
    public static final char UNC_RANGE_SEPARATOR = '\u203a';
    public static final String UNC_RANGE_SEPARATOR_STR = String.valueOf('\u203a');
    public static final String UNC_SUFFIX = ".ipv6-literal.net";
    public static final String REVERSE_DNS_SUFFIX = ".ip6.arpa";
    public static final String REVERSE_DNS_SUFFIX_DEPRECATED = ".ip6.int";
    public static final int BITS_PER_SEGMENT = 16;
    public static final int BYTES_PER_SEGMENT = 2;
    public static final int SEGMENT_COUNT = 8;
    public static final int MIXED_REPLACED_SEGMENT_COUNT = 2;
    public static final int MIXED_ORIGINAL_SEGMENT_COUNT = 6;
    public static final int BYTE_COUNT = 16;
    public static final int BIT_COUNT = 128;
    public static final int DEFAULT_TEXTUAL_RADIX = 16;
    public static final int MAX_VALUE_PER_SEGMENT = 65535;
    protected static IPv6AddressNetwork network = new IPv6AddressNetwork();
    private final String zone;
    private transient IPv6AddressSection.IPv6StringCache stringCache;
    transient IPv6AddressSection.AddressCache sectionCache;
    private transient IPv6AddressNetwork.IPv6AddressCreator creator;

    public IPv6Address(IPv6AddressSegment[] segments) {
        this(IPv6Address.network().getAddressCreator().createSection(segments));
    }

    public IPv6Address(IPv6AddressSegment[] segments, Integer networkPrefixLength) {
        this(IPv6Address.network().getAddressCreator().createSection(segments, networkPrefixLength));
    }

    public IPv6Address(IPv6AddressSegment[] segments, CharSequence zone) {
        this(IPv6Address.network().getAddressCreator().createSection(segments), zone);
    }

    public IPv6Address(IPv6AddressSection section, CharSequence zone) {
        super(section);
        if (section.getSegmentCount() != 8) {
            throw new IllegalArgumentException(String.valueOf(IPv6Address.getMessage("ipaddress.error.ipv6.invalid.segment.count")) + ' ' + section.getSegmentCount());
        }
        this.zone = zone == null ? "" : zone.toString();
    }

    public IPv6Address(IPv6AddressSection section) throws AddressTypeException {
        super(section);
        if (section.getSegmentCount() != 8) {
            throw new IllegalArgumentException(String.valueOf(IPv6Address.getMessage("ipaddress.error.ipv6.invalid.segment.count")) + ' ' + section.getSegmentCount());
        }
        this.zone = "";
    }

    public IPv6Address(byte[] bytes, CharSequence zone) {
        super(IPv6Address.network().getAddressCreator().createSection(bytes, null));
        if (bytes.length != 16) {
            throw new IllegalArgumentException(String.valueOf(IPv6Address.getMessage("ipaddress.error.ipv6.invalid.byte.count")) + ' ' + bytes.length);
        }
        this.zone = zone == null ? "" : zone.toString();
    }

    public IPv6Address(byte[] bytes) {
        this(bytes, (Integer)null);
    }

    public IPv6Address(byte[] bytes, Integer networkPrefixLength) {
        super(IPv6Address.network().getAddressCreator().createSection(bytes, networkPrefixLength));
        if (bytes.length != 16) {
            throw new IllegalArgumentException(String.valueOf(IPv6Address.getMessage("ipaddress.error.ipv6.invalid.byte.count")) + ' ' + bytes.length);
        }
        this.zone = "";
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer networkPrefixLength) {
        super(IPv6Address.network().getAddressCreator().createSection(lowerValueProvider, upperValueProvider, networkPrefixLength));
        this.zone = "";
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider) {
        this(lowerValueProvider, upperValueProvider, (Integer)null);
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, CharSequence zone) {
        super(IPv6Address.network().getAddressCreator().createSection(lowerValueProvider, upperValueProvider, null));
        this.zone = zone == null ? "" : zone.toString();
    }

    public IPv6Address(IPv6Address prefix, MACAddress eui) {
        this(prefix.getSection(), eui.getSection());
    }

    public IPv6Address(IPv6AddressSection section, MACAddress eui) {
        this(section, eui.getSection());
    }

    public IPv6Address(IPv6AddressSection section, MACAddressSection eui) {
        this(section, eui, (CharSequence)"");
    }

    public IPv6Address(IPv6AddressSection section, MACAddressSection eui, CharSequence zone) {
        super(IPv6Address.toEUI64Segments(section, eui));
        this.zone = zone.toString();
    }

    private static IPv6AddressSection toEUI64Segments(IPv6AddressSection section, MACAddressSection eui) {
        boolean euiIsExtended = eui.isExtended();
        if (eui.startIndex != 0 || section.startIndex != 0 || section.getSegmentCount() < 4 || eui.getSegmentCount() != (euiIsExtended ? 8 : 6)) {
            throw new AddressTypeException(eui, "ipaddress.mac.error.not.eui.convertible");
        }
        if (section.isPrefixed()) {
            section = section.removePrefixLength();
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        AddressSegment[] segments = creator.createSegmentArray(8);
        section.getSegments(0, 4, segments, 0);
        return creator.createSectionInternal(IPv6Address.toEUI64Segments((IPv6AddressSegment[])segments, 4, eui, 0, eui.isExtended()));
    }

    static IPv6AddressSegment[] toEUI64Segments(IPv6AddressSegment[] segments, int ipv6StartIndex, MACAddressSection eui, int euiStartIndex, boolean isExtended) {
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        int euiSegmentIndex = 0;
        int euiSegmentCount = eui.getSegmentCount();
        MACAddressSegment seg0 = euiStartIndex == 0 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg1 = euiStartIndex <= 1 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg2 = euiStartIndex <= 2 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg3 = euiStartIndex <= 3 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg4 = euiStartIndex <= 4 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg5 = euiStartIndex <= 5 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg6 = euiStartIndex <= 6 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg7 = euiStartIndex <= 7 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex) : null;
        MACAddressSegment ZERO_SEGMENT = MACAddressSegment.ZERO_SEGMENT;
        MACAddressSegment FF_SEGMENT = MACAddressSegment.FF_SEGMENT;
        MACAddressSegment FE_SEGMENT = MACAddressSegment.FE_SEGMENT;
        boolean isNotNull = seg0 != null;
        if (isNotNull || seg1 != null) {
            if (isNotNull) {
                if (seg1 == null) {
                    seg1 = ZERO_SEGMENT;
                }
            } else {
                seg0 = ZERO_SEGMENT;
            }
            segments[ipv6StartIndex++] = IPv6Address.join(creator, seg0, seg1, true);
        }
        if (isExtended) {
            isNotNull = seg2 != null;
            if (isNotNull || seg3 != null) {
                if (!isNotNull) {
                    seg2 = ZERO_SEGMENT;
                    if (!seg3.matches(255)) {
                        throw new AddressTypeException(eui, "ipaddress.mac.error.not.eui.convertible");
                    }
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg2, FF_SEGMENT);
            }
            if ((isNotNull = seg4 != null) || seg5 != null) {
                if (isNotNull) {
                    if (!seg4.matches(254)) {
                        throw new AddressTypeException(eui, "ipaddress.mac.error.not.eui.convertible");
                    }
                    if (seg5 == null) {
                        seg5 = ZERO_SEGMENT;
                    }
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, FE_SEGMENT, seg5);
            }
        } else {
            if (seg2 != null) {
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg2, FF_SEGMENT);
            }
            if (seg3 != null) {
                segments[ipv6StartIndex++] = IPv6Address.join(creator, FE_SEGMENT, seg3);
            }
            if ((isNotNull = seg4 != null) || seg5 != null) {
                if (isNotNull) {
                    if (seg5 == null) {
                        seg5 = ZERO_SEGMENT;
                    }
                } else {
                    seg4 = ZERO_SEGMENT;
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg4, seg5);
            }
        }
        if ((isNotNull = seg6 != null) || seg7 != null) {
            if (isNotNull) {
                if (seg7 == null) {
                    seg7 = ZERO_SEGMENT;
                }
            } else {
                seg6 = ZERO_SEGMENT;
            }
            segments[ipv6StartIndex] = IPv6Address.join(creator, seg6, seg7);
        }
        return segments;
    }

    private static IPv6AddressSegment join(IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressSegment macSegment0, MACAddressSegment macSegment1) {
        return IPv6Address.join(creator, macSegment0, macSegment1, false);
    }

    private static IPv6AddressSegment join(IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressSegment macSegment0, MACAddressSegment macSegment1, boolean flip) {
        int lower0 = macSegment0.getLowerSegmentValue();
        int upper0 = macSegment0.getUpperSegmentValue();
        if (flip) {
            int mask2ndBit = 2;
            if (!macSegment0.matchesWithMask(mask2ndBit & lower0, mask2ndBit)) {
                throw new AddressTypeException(macSegment0, "ipaddress.mac.error.not.eui.convertible");
            }
            lower0 ^= mask2ndBit;
            upper0 ^= mask2ndBit;
        }
        return creator.createSegment(lower0 << 8 | macSegment1.getLowerSegmentValue(), upper0 << 8 | macSegment1.getUpperSegmentValue(), null);
    }

    public static IPv6AddressNetwork network() {
        return network;
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return IPv6Address.network();
    }

    public static IPv6Address getLoopback() {
        return (IPv6Address)IPv6Address.network().getLoopback();
    }

    public static String[] getStandardLoopbackStrings() {
        return IPv6Address.network().getStandardLoopbackStrings();
    }

    @Override
    public IPv6AddressSection getSection() {
        return (IPv6AddressSection)super.getSection();
    }

    @Override
    public IPv6AddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public IPv6AddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    @Override
    public IPv6AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    public IPv6AddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    public boolean isEUI64() {
        return this.getSection().isEUI64();
    }

    public MACAddress toEUI(boolean extended) {
        MACAddressSection section = this.getSection().toEUI(extended);
        if (section == null) {
            return null;
        }
        MACAddressNetwork.MACAddressCreator creator = MACAddress.getAddressCreator();
        return creator.createAddress(section);
    }

    @Override
    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv6AddressSection.IPv6StringBuilderOptions.from(options));
    }

    public IPAddressStringDivisionSeries[] getParts(IPv6AddressSection.IPv6StringBuilderOptions options) {
        IPAddressStringDivisionSeries[] parts = this.getSection().getParts(options);
        IPv4Address ipv4Addr = this.getConverted(options);
        if (ipv4Addr != null) {
            IPAddressStringDivisionSeries[] ipv4Parts = ipv4Addr.getParts(options.ipv4ConverterOptions);
            IPAddressStringDivisionSeries[] tmp = parts;
            parts = new IPAddressStringDivisionSeries[tmp.length + ipv4Parts.length];
            System.arraycopy(tmp, 0, parts, 0, tmp.length);
            System.arraycopy(ipv4Parts, 0, parts, tmp.length, ipv4Parts.length);
        }
        return parts;
    }

    private static IPv6AddressSection createSection(IPv6AddressSegment[] nonMixedSection, IPv4Address mixedSection) throws AddressTypeException {
        IPv4AddressSection ipv4Section = mixedSection.getSection();
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        IPv6AddressSegment[] newSegs = creator.createSegmentArray(8);
        newSegs[0] = nonMixedSection[0];
        newSegs[1] = nonMixedSection[1];
        newSegs[2] = nonMixedSection[2];
        newSegs[3] = nonMixedSection[3];
        newSegs[4] = nonMixedSection[4];
        newSegs[5] = nonMixedSection[5];
        newSegs[6] = IPv6AddressSegment.join(ipv4Section.getSegment(0), ipv4Section.getSegment(1));
        newSegs[7] = IPv6AddressSegment.join(ipv4Section.getSegment(2), ipv4Section.getSegment(3));
        IPv6AddressSection result = creator.createSectionInternal(newSegs);
        result.embeddedIPv4Section = ipv4Section;
        return result;
    }

    @Override
    public int getSegmentCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 16;
    }

    @Override
    public int getBitCount() {
        return 128;
    }

    private IPv6Address getLowestOrHighest(boolean lowest) {
        return this.getSection().getLowestOrHighest(this.getCreator(), this, lowest);
    }

    @Override
    public IPv6Address getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public IPv6Address getUpper() {
        return this.getLowestOrHighest(false);
    }

    @Override
    public IPv6Address reverseBits(boolean perByte) {
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getCreator();
        return creator.createAddress(this.getSection().reverseBits(perByte));
    }

    @Override
    public IPv6Address reverseBytes() {
        return this.checkIdentity(this.getSection().reverseBytes());
    }

    @Override
    public IPv6Address reverseBytesPerSegment() {
        return this.checkIdentity(this.getSection().reverseBytesPerSegment());
    }

    @Override
    public IPv6Address reverseSegments() {
        return this.checkIdentity(this.getSection().reverseSegments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPv6AddressNetwork.IPv6AddressCreator getCreator() {
        IPv6AddressNetwork.IPv6AddressCreator result = this.creator;
        if (result == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                result = this.creator;
                if (result == null) {
                    result = !this.hasZone() ? IPv6Address.network().getAddressCreator() : new IPv6AddressNetwork.IPv6AddressCreator(){

                        @Override
                        protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
                            IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
                            return creator.createAddressInternal(segments, (CharSequence)IPv6Address.this.zone);
                        }

                        @Override
                        public IPv6Address createAddress(IPv6AddressSection section) {
                            IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
                            return creator.createAddress(section, (CharSequence)IPv6Address.this.zone);
                        }
                    };
                }
            }
        }
        return result;
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return this.getSection().iterator(this, this.getCreator());
    }

    public Iterable<IPv6Address> getIterable() {
        return this;
    }

    public static IPv6Address from(byte[] bytes, Integer prefix, CharSequence zone) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException(String.valueOf(IPv6Address.getMessage("ipaddress.error.ipv6.invalid.byte.count")) + ' ' + bytes.length);
        }
        return (IPv6Address)IPAddress.from(bytes, prefix, zone);
    }

    public static IPv6Address from(byte[] bytes, CharSequence zone) {
        return IPv6Address.from(bytes, null, zone);
    }

    @Override
    public IPv4Address toIPv4() {
        IPAddressConverter conv = addressConverter;
        if (conv != null) {
            return conv.toIPv4(this);
        }
        return null;
    }

    @Override
    public IPv6Address toIPv6() {
        return this;
    }

    @Override
    public boolean isIPv4Convertible() {
        IPAddressConverter conv = addressConverter;
        return conv != null && conv.isIPv4Convertible(this);
    }

    @Override
    public boolean isIPv6Convertible() {
        return true;
    }

    public static IPv6Address toIPv4Mapped(IPv4Address addr) throws AddressTypeException {
        IPv6AddressSegment zero = IPv6AddressSegment.ZERO_SEGMENT;
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        IPv6AddressSegment[] segs = creator.createSegmentArray(6);
        segs[3] = segs[4] = zero;
        segs[2] = segs[4];
        segs[1] = segs[4];
        segs[0] = segs[4];
        segs[5] = IPv6AddressSegment.ALL_SEGMENT;
        return creator.createAddress(IPv6Address.createSection(segs, addr));
    }

    public IPv4AddressSection toMappedIPv4Segments() {
        if (this.isIPv4Mapped()) {
            return this.getSection().getEmbeddedIPv4AddressSection();
        }
        return null;
    }

    public IPv4Address get6to4IPv4Address() {
        return this.getEmbeddedIPv4Address(2);
    }

    public IPv4Address getEmbeddedIPv4Address() {
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection());
    }

    public IPv4Address getEmbeddedIPv4Address(int byteIndex) {
        if (byteIndex == 12) {
            return this.getEmbeddedIPv4Address();
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection(byteIndex, byteIndex + 4));
    }

    @Override
    public boolean isLinkLocal() {
        return this.getSegment(0).matchesWithPrefix(65152, (Integer)10);
    }

    @Override
    public boolean isSiteLocal() {
        return this.getSegment(0).matchesWithPrefix(65216, (Integer)10);
    }

    public boolean isUniqueLocal() {
        return this.getSegment(0).matchesWithPrefix(64512, (Integer)7);
    }

    public boolean isIPv4Mapped() {
        if (this.getSegment(5).matches(IPv6AddressSegment.ALL_SEGMENT.getLowerSegmentValue())) {
            int i = 0;
            while (i < 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isIPv4Compatible() {
        return this.getSegment(0).isZero() && this.getSegment(1).isZero() && this.getSegment(2).isZero() && this.getSegment(3).isZero() && this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean is6To4() {
        return this.getSegment(0).matches(8194);
    }

    public boolean is6Over4() {
        return this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean isTeredo() {
        return this.getSegment(0).matches(8193) && this.getSegment(1).isZero();
    }

    public boolean isIsatap() {
        return this.getSegment(4).isZero() && this.getSegment(5).matches(24318);
    }

    public boolean isIPv4Translatable() {
        if (this.getSegment(4).matches(65535) && this.getSegment(5).isZero()) {
            int i = 0;
            while (i < 3) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isWellKnownIPv4Translatable() {
        if (this.getSegment(0).matches(100) && this.getSegment(1).matches(65435)) {
            int i = 2;
            while (i <= 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithPrefix(255, (Integer)8);
    }

    @Override
    public boolean isLoopback() {
        int i = 0;
        while (i < this.getSegmentCount() - 1) {
            if (!this.getSegment(i).isZero()) {
                return false;
            }
            ++i;
        }
        return this.getSegment(i).matches(1);
    }

    public IPv6Address[] subtract(IPAddress other) {
        IPv6AddressSection thisSection = this.getSection();
        IPv6AddressSection[] sections = thisSection.subtract(this.convertArg(other).getSection());
        if (sections == null) {
            return null;
        }
        IPv6Address[] result = new IPv6Address[sections.length];
        int i = 0;
        while (i < result.length) {
            result[i] = IPv6Address.network().getAddressCreator().createAddress(sections[i], (CharSequence)this.zone);
            ++i;
        }
        return result;
    }

    private IPv6Address checkIdentity(IPv6AddressSection newSection) {
        if (newSection == this.getSection()) {
            return this;
        }
        return this.getCreator().createAddress(newSection);
    }

    @Override
    public IPv6Address adjustPrefixBySegment(boolean nextSegment) {
        return this.checkIdentity(this.getSection().adjustPrefixBySegment(nextSegment));
    }

    @Override
    public IPv6Address adjustPrefixLength(int adjustment) {
        return this.checkIdentity(this.getSection().adjustPrefixLength(adjustment));
    }

    @Override
    public IPv6Address setPrefixLength(int prefixLength) {
        return this.setPrefixLength(prefixLength, true);
    }

    @Override
    public IPv6Address setPrefixLength(int prefixLength, boolean zeroed) {
        return this.checkIdentity(this.getSection().setPrefixLength(prefixLength, zeroed));
    }

    @Override
    public IPv6Address applyPrefixLength(int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().applyPrefixLength(networkPrefixLength));
    }

    private IPv6Address convertArg(IPAddress arg) {
        IPv6Address converted = arg.toIPv6();
        if (converted == null) {
            throw new AddressTypeException(this, "ipaddress.error.prefix.mask.mismatch");
        }
        return converted;
    }

    @Override
    public IPv6Address removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public IPv6Address removePrefixLength(boolean zeroed) {
        return this.checkIdentity(this.getSection().removePrefixLength(zeroed));
    }

    @Override
    protected IPAddress removePrefixLength(boolean zeroed, boolean onlyPrefixZeroed) {
        return this.checkIdentity(this.getSection().removePrefixLength(zeroed, onlyPrefixZeroed));
    }

    @Override
    public IPv6Address mask(IPAddress mask) throws AddressTypeException {
        return this.checkIdentity(this.getSection().mask(this.convertArg(mask).getSection()));
    }

    @Override
    public IPv6Address maskNetwork(IPAddress mask, int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().maskNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv6Address bitwiseOr(IPAddress mask) throws AddressTypeException {
        return this.checkIdentity(this.getSection().bitwiseOr(this.convertArg(mask).getSection()));
    }

    @Override
    public IPv6Address bitwiseOrNetwork(IPAddress mask, int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().bitwiseOrNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength, withPrefixLength);
    }

    @Override
    public IPv6AddressSection getNetworkSection() {
        if (this.isPrefixed()) {
            return this.getNetworkSection(this.getNetworkPrefixLength(), true);
        }
        return this.getNetworkSection(this.getBitCount(), true);
    }

    @Override
    public IPv6AddressSection getHostSection(int networkPrefixLength) {
        return this.getSection().getHostSection(networkPrefixLength);
    }

    @Override
    public IPv6AddressSection getHostSection() {
        if (this.isPrefixed()) {
            return this.getHostSection(this.getNetworkPrefixLength());
        }
        return this.getHostSection(0);
    }

    public boolean hasZone() {
        return this.zone.length() > 0;
    }

    public String getZone() {
        if (this.hasZone()) {
            return this.zone;
        }
        return null;
    }

    public IPv6Address removeZone() {
        return IPv6Address.network().getAddressCreator().createAddress(this.getSection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Inet6Address toInetAddress() {
        Inet6Address result = (Inet6Address)this.inetAddress;
        if (result == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                result = (Inet6Address)this.inetAddress;
                if (result == null) {
                    byte[] bytes = this.getBytes();
                    try {
                        if (this.hasZone()) {
                            try {
                                int scopeId = Integer.valueOf(this.zone);
                                result = Inet6Address.getByAddress(null, bytes, scopeId);
                            }
                            catch (NumberFormatException e) {
                                result = (Inet6Address)InetAddress.getByName(this.toNormalizedString());
                            }
                        } else {
                            result = (Inet6Address)InetAddress.getByAddress(bytes);
                        }
                    }
                    catch (UnknownHostException e) {
                        result = null;
                    }
                    this.inetAddress = result;
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.hasZone()) {
            result *= this.zone.hashCode();
        }
        return result;
    }

    @Override
    public boolean isSameAddress(IPAddress other) {
        if (super.isSameAddress(other)) {
            IPv6Address otherIPv6Address = other.toIPv6();
            String otherZone = otherIPv6Address.zone;
            return this.zone.equals(otherZone);
        }
        return false;
    }

    @Override
    public boolean contains(IPAddress other) {
        if (super.contains(other)) {
            if (other != this) {
                IPv6Address otherIPv6Address = other.toIPv6();
                String otherZone = otherIPv6Address.zone;
                return this.zone.equals(otherZone);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                block6: {
                    if (this.stringCache != null) break block6;
                    if (!this.hasZone()) {
                        IPv6AddressSection section = this.getSection();
                        boolean result = section.hasNoStringCache();
                        this.stringCache = section.getStringCache();
                        return result;
                    }
                    this.stringCache = new IPv6AddressSection.IPv6StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    public String toMixedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.mixedString) == null) {
            if (this.hasZone()) {
                this.stringCache.mixedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.mixedParams);
            } else {
                result = this.getSection().toMixedString();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.canonicalParams);
            } else {
                result = this.getSection().toCanonicalString();
            }
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            if (this.hasZone()) {
                this.stringCache.fullString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.fullParams);
            } else {
                result = this.getSection().toFullString();
            }
        }
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.normalizedParams);
            } else {
                result = this.getSection().toNormalizedString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.compressedParams);
            } else {
                result = this.getSection().toCompressedString();
            }
        }
        return result;
    }

    @Override
    public String toSubnetString() {
        return this.toPrefixLengthString();
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardNormalizedParams);
            } else {
                result = this.getSection().toNormalizedWildcardString();
            }
        }
        return result;
    }

    public String toBase85String() {
        String result;
        IPAddressString originator = this.getAddressfromString();
        if (originator != null && (!this.isPrefixed() || this.getNetworkPrefixLength() == 128) && originator.isBase85IPv6()) {
            return originator.toString();
        }
        if (this.hasNoStringCache() || (result = this.stringCache.base85String) == null) {
            if (this.hasZone()) {
                this.stringCache.base85String = result = this.getSection().toBase85String(this.getZone());
            } else {
                result = this.getSection().toBase85String();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCanonicalParams);
            } else {
                result = this.getSection().toCanonicalWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCompressedParams);
            } else {
                result = this.getSection().toCompressedWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.sqlWildcardParams);
            } else {
                result = this.getSection().toSQLWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0xPrefix ? this.stringCache.hexStringPrefixed : this.stringCache.hexString) == null) {
            if (this.hasZone()) {
                result = this.getSection().toHexString(with0xPrefix, this.zone);
                if (with0xPrefix) {
                    this.stringCache.hexStringPrefixed = result;
                } else {
                    this.stringCache.hexString = result;
                }
            } else {
                result = this.getSection().toHexString(with0xPrefix);
            }
        }
        return result;
    }

    @Override
    public String toBinaryString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.binaryString) == null) {
            if (this.hasZone()) {
                this.stringCache.binaryString = result = this.getSection().toBinaryString(this.zone);
            } else {
                result = this.getSection().toBinaryString();
            }
        }
        return result;
    }

    @Override
    public String toOctalString(boolean with0Prefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0Prefix ? this.stringCache.octalStringPrefixed : this.stringCache.octalString) == null) {
            if (this.hasZone()) {
                result = this.getSection().toOctalString(with0Prefix, this.zone);
                if (with0Prefix) {
                    this.stringCache.octalStringPrefixed = result;
                } else {
                    this.stringCache.octalString = result;
                }
            } else {
                result = this.getSection().toOctalString(with0Prefix);
            }
        }
        return result;
    }

    @Override
    public String toPrefixLengthString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.networkPrefixLengthString) == null) {
            if (this.hasZone()) {
                this.stringCache.networkPrefixLengthString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.networkPrefixLengthParams);
            } else {
                result = this.getSection().toPrefixLengthString();
            }
        }
        return result;
    }

    @Override
    public String toConvertedString() {
        if (this.isIPv4Convertible()) {
            return this.toMixedString();
        }
        return this.toNormalizedString();
    }

    @Override
    public String toNormalizedString(IPAddressSection.IPStringOptions params) {
        return this.getSection().toNormalizedString(params, (CharSequence)this.zone);
    }

    public String toNormalizedString(IPv6AddressSection.IPv6StringOptions params) {
        return this.getSection().toNormalizedString(params, (CharSequence)this.zone);
    }

    public String toNormalizedString(boolean keepMixed, IPv6AddressSection.IPv6StringOptions params) {
        if (keepMixed && this.fromString != null && this.getAddressfromString().isMixedIPv6() && !params.makeMixed()) {
            params = new IPv6AddressSection.IPv6StringOptions(params.base, params.expandSegments, params.wildcardOption, params.wildcards, params.segmentStrPrefix, true, params.ipv4Opts, params.compressOptions, params.separator, params.zoneSeparator, params.addrLabel, params.addrSuffix, params.reverse, params.splitDigits, params.uppercase);
        }
        return this.toNormalizedString(params);
    }

    @Override
    public String toUNCHostName() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.uncString) == null) {
            this.stringCache.uncString = result = this.getSection().toNormalizedString(IPv6AddressSection.IPv6StringCache.uncParams, (CharSequence)this.zone.replace('%', 's').replace(':', '-'));
        }
        return result;
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.from(opts));
    }

    private IPv4Address getConverted(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        if (!this.hasZone() && opts.includes(65536)) {
            IPv4Address.IPv4AddressConverter converter = opts.converter;
            return converter.toIPv4(this);
        }
        return null;
    }

    public IPAddressPartStringCollection toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        IPv6AddressSection.IPv6StringCollection coll = this.getSection().toStringCollection(opts, this.zone);
        IPv4Address ipv4Addr = this.getConverted(opts);
        if (ipv4Addr != null) {
            IPAddressPartStringCollection ipv4StringCollection = ipv4Addr.toStringCollection(opts.ipv4ConverterOptions);
            coll.addAll(ipv4StringCollection);
        }
        return coll;
    }

    public Iterator<IPv6AddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    public static /* bridge */ /* synthetic */ IPAddress from(byte[] byArray, Integer n, CharSequence charSequence) {
        return IPv6Address.from(byArray, n, charSequence);
    }

    public static interface IPv6AddressConverter {
        public IPv6Address toIPv6(IPAddress var1);
    }
}

