/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressStringDivision;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartStringSubCollection;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4JoinedSegments;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IPv4AddressSection
extends IPAddressSection
implements Iterable<IPv4AddressSection> {
    private static final long serialVersionUID = 3L;
    transient IPv4StringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<IPv4AddressSection> sectionCache;

    public IPv4AddressSection(IPv4AddressSegment[] segments, Integer networkPrefixLength) {
        this((IPv4AddressSegment[])IPv4AddressSection.toPrefixedSegments((Integer)networkPrefixLength, (AddressSegment[])segments, (int)8, (AddressNetwork.AddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), IPv4AddressSegment::toNetworkSegment, (boolean)true), false);
    }

    public IPv4AddressSection(IPv4AddressSegment[] segments) {
        this(segments, true);
    }

    public IPv4AddressSection(IPv4AddressSegment segment) {
        this(new IPv4AddressSegment[]{segment}, false);
    }

    IPv4AddressSection(IPv4AddressSegment[] segments, boolean cloneSegments) {
        super(segments, null, cloneSegments, false);
        if (segments.length > 4) {
            throw new IllegalArgumentException(String.valueOf(IPv4AddressSection.getMessage("ipaddress.error.exceeds.size")) + ' ' + segments.length);
        }
    }

    public IPv4AddressSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefix) {
        super((IPAddressSegment[])IPv4AddressSection.toSegments((Address.SegmentValueProvider)lowerValueProvider, (Address.SegmentValueProvider)upperValueProvider, (int)4, (int)1, (int)8, (int)255, (AddressNetwork.AddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), (Integer)prefix), null, false, false);
    }

    public IPv4AddressSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider) {
        this(lowerValueProvider, upperValueProvider, null);
    }

    IPv4AddressSection(byte[] bytes, Integer prefix, boolean cloneBytes) {
        super((IPAddressSegment[])IPv4AddressSection.toSegments((byte[])bytes, (int)4, (int)1, (int)8, (int)255, (AddressNetwork.AddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), (Integer)prefix), bytes, false, cloneBytes);
        if (bytes.length > 4) {
            throw new IllegalArgumentException(String.valueOf(IPv4AddressSection.getMessage("ipaddress.error.exceeds.size")) + ' ' + bytes.length);
        }
    }

    public IPv4AddressSection(int value, Integer prefix) {
        super((IPAddressSegment[])IPv4AddressSection.toSegments((long)value, (int)4, (int)4, (int)1, (int)8, (int)255, (AddressNetwork.AddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), (Integer)prefix), null, false, false);
    }

    public IPv4AddressSection(int value) {
        super((IPAddressSegment[])IPv4AddressSection.toSegments((long)value, (int)4, (int)4, (int)1, (int)8, (int)255, (AddressNetwork.AddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), null), null, false, false);
    }

    public IPv4AddressSection(byte[] bytes, Integer prefix) {
        this(bytes, prefix, true);
    }

    public IPv4AddressSection(byte[] bytes) {
        this(bytes, null, true);
    }

    public IPv4AddressSegment[] getSegments() {
        return (IPv4AddressSegment[])this.divisions.clone();
    }

    @Override
    public IPv4AddressSection getSection(int index) {
        return this.getSection(index, this.getSegmentCount());
    }

    @Override
    public IPv4AddressSection getSection(int index, int endIndex) {
        return IPv4AddressSection.getSection(index, endIndex, this, this.getAddressCreator());
    }

    private IPv4AddressSection getLowestOrHighestSection(boolean lowest) {
        return IPv4AddressSection.getLowestOrHighestSection(this, this.getAddressCreator(), lowest, i -> lowest ? this.getSegment(i).getLower() : this.getSegment(i).getUpper(), () -> IPv4AddressSection.getSectionCache(this, () -> this.sectionCache, () -> {
            this.sectionCache = new AddressDivisionGrouping.SectionCache();
            return this.sectionCache;
        }));
    }

    IPv4Address getLowestOrHighest(IPv4Address addr, boolean lowest) {
        return IPv4AddressSection.getLowestOrHighestAddress(addr, this.getAddressCreator(), lowest, () -> this.getLowestOrHighestSection(lowest), () -> IPv4AddressSection.getSectionCache(addr, () -> iPv4Address.sectionCache, () -> {
            iPv4Address.sectionCache = new AddressCache();
            return iPv4Address.sectionCache;
        }));
    }

    @Override
    public IPv4AddressSection getLower() {
        return this.getLowestOrHighestSection(true);
    }

    @Override
    public IPv4AddressSection getUpper() {
        return this.getLowestOrHighestSection(false);
    }

    @Override
    public IPv4AddressSection reverseBits(boolean perByte) {
        return IPv4AddressSection.reverseBits(perByte, this, this.getAddressCreator(), i -> this.getSegment(i).reverseBits(perByte), true);
    }

    @Override
    public IPv4AddressSection reverseBytes() {
        return this.reverseSegments();
    }

    @Override
    public IPv4AddressSection reverseBytesPerSegment() {
        if (!this.isPrefixed()) {
            return this;
        }
        return IPv4AddressSection.reverseBytes(true, this, this.getAddressCreator(), i -> this.getSegment(i).reverseBytes(), true);
    }

    @Override
    public IPv4AddressSection reverseSegments() {
        if (this.getSegmentCount() <= 1) {
            if (this.isPrefixed()) {
                return this.removePrefixLength(false);
            }
            return this;
        }
        return IPv4AddressSection.reverseSegments(this, this.getAddressCreator(), i -> this.getSegment(i).removePrefixLength(false), true);
    }

    public Iterable<IPv4AddressSection> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv4AddressSection> iterator() {
        boolean useOriginal = !this.isMultiple() && !this.isPrefixed();
        return IPv4AddressSection.iterator(useOriginal, this, this.getAddressCreator(), useOriginal ? null : this.segmentsIterator());
    }

    public Iterator<IPv4AddressSegment[]> segmentsIterator() {
        return super.iterator(this.getSegmentCreator(), () -> this.getLower().getSegments(), index -> this.getSegment(index).iterator());
    }

    protected Iterator<IPv4Address> iterator(IPv4Address original, AddressCreator<IPv4Address, ?, ?, IPv4AddressSegment> creator) {
        boolean useOriginal = !this.isMultiple() && !this.isPrefixed();
        return IPv4AddressSection.iterator(original, creator, useOriginal, useOriginal ? null : this.iterator(creator, () -> (IPv4AddressSegment[])this.getLower().divisions, index -> this.getSegment(index).iterator()));
    }

    @Override
    protected BigInteger getCountImpl() {
        int segCount = this.getSegmentCount();
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        long result = this.getSegment(0).getValueCount();
        int i = 1;
        while (i < segCount) {
            result *= (long)this.getSegment(i).getValueCount();
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    private IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return IPv4AddressSection.getIPv4SegmentCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return IPv4AddressSection.getIPv4SegmentCreator();
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getIPv4SegmentCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    @Override
    public IPv4AddressSegment getSegment(int index) {
        return (IPv4AddressSegment)super.getSegment(index);
    }

    public void getSegments(Collection<? super IPv4AddressSegment> segs) {
        this.getSegments(0, this.getSegmentCount(), segs);
    }

    public void getSegments(int start, int end, Collection<? super IPv4AddressSegment> segs) {
        int i = start;
        while (i < end) {
            segs.add(this.getSegment(i));
            ++i;
        }
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        byte[] bytes = new byte[this.getBitCount() + 7 >> 3];
        int segmentCount = this.getSegmentCount();
        int i = 0;
        while (i < segmentCount) {
            IPv4AddressSegment seg = this.getSegment(i);
            int val = low ? seg.getLowerSegmentValue() : seg.getUpperSegmentValue();
            bytes[i] = (byte)val;
            ++i;
        }
        return bytes;
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    @Override
    protected boolean isSameGrouping(AddressDivisionGrouping other) {
        return other instanceof IPv4AddressSection && super.isSameGrouping(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPv4AddressSection) {
            return super.isSameGrouping((IPv4AddressSection)o);
        }
        return false;
    }

    public IPv4AddressSection replace(IPv4AddressSection other, int index) {
        if (index > 0 && this.getSegment(index - 1).isPrefixed()) {
            throw new AddressTypeException(this, "ipaddress.error.index.exceeds.prefix.length");
        }
        IPv4AddressSection result = IPv4AddressSection.replace(this, other, this.getAddressCreator(), index, true);
        return result;
    }

    public IPv4AddressSection prepend(IPv4AddressSection other) {
        IPv4AddressSection result = this.appendPreamble(other);
        if (result != null) {
            return result;
        }
        return IPv4AddressSection.append(other, this, this.getAddressCreator(), true);
    }

    public IPv4AddressSection append(IPv4AddressSection other) {
        IPv4AddressSection result = this.appendPreamble(other);
        if (result != null) {
            return result;
        }
        return IPv4AddressSection.append(this, other, this.getAddressCreator(), true);
    }

    private IPv4AddressSection appendPreamble(IPv4AddressSection other) {
        int otherSegmentCount;
        int segmentCount = this.getSegmentCount();
        if (segmentCount + (otherSegmentCount = other.getSegmentCount()) > 4) {
            throw new AddressTypeException((AddressSection)this, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return this;
        }
        if (segmentCount == 0) {
            return other;
        }
        return null;
    }

    @Override
    public boolean contains(AddressSection other) {
        return other instanceof IPv4AddressSection && super.contains((IPAddressSection)other);
    }

    public IPv4AddressSection[] subtract(IPv4AddressSection other) {
        return (IPv4AddressSection[])IPv4AddressSection.subtract((IPAddressSection)this, (IPAddressSection)other, (IPAddressTypeNetwork.IPAddressCreator)this.getAddressCreator(), this::getSegment, (T section, U prefix) -> section.applyPrefixLength((int)prefix));
    }

    @Override
    public int getByteIndex(int networkPrefixLength) {
        return IPv4AddressSection.getByteIndex(networkPrefixLength, 4);
    }

    @Override
    public int getSegmentIndex(int networkPrefixLength) {
        return this.getByteIndex(networkPrefixLength);
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return IPv4Address.network();
    }

    @Override
    public IPv4AddressSection adjustPrefixBySegment(boolean nextSegment) {
        return (IPv4AddressSection)super.adjustPrefixBySegment(nextSegment);
    }

    @Override
    public IPv4AddressSection adjustPrefixLength(int adjustment) {
        return (IPv4AddressSection)IPv4AddressSection.adjustPrefixLength(this, adjustment, this.getAddressCreator(), this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    @Override
    public IPv4AddressSection applyPrefixLength(int networkPrefixLength) {
        return this.setPrefixLength(networkPrefixLength, false, true);
    }

    @Override
    public IPv4AddressSection setPrefixLength(int networkPrefixLength) {
        return this.setPrefixLength(networkPrefixLength, true, false);
    }

    @Override
    public IPv4AddressSection setPrefixLength(int networkPrefixLength, boolean withZeros) {
        return this.setPrefixLength(networkPrefixLength, withZeros, false);
    }

    private IPv4AddressSection setPrefixLength(int networkPrefixLength, boolean withZeros, boolean noShrink) {
        return IPv4AddressSection.setPrefixLength(this, this.getAddressCreator(), networkPrefixLength, withZeros, noShrink, this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    public IPv4AddressSection bitwiseOrNetwork(IPv4AddressSection mask, int networkPrefixLength) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv4AddressSection.getOredSegments(this, networkPrefixLength, this.getAddressCreator(), this::getSegment, mask::getSegment);
    }

    public IPv4AddressSection bitwiseOr(IPv4AddressSection mask) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv4AddressSection.getOredSegments(this, null, this.getAddressCreator(), this::getSegment, mask::getSegment);
    }

    @Override
    public IPv4AddressSection removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public IPv4AddressSection removePrefixLength(boolean zeroed) {
        return this.removePrefixLength(zeroed, true);
    }

    protected IPv4AddressSection removePrefixLength(boolean zeroed, boolean onlyPrefixZeroed) {
        return IPv4AddressSection.removePrefixLength(this, zeroed, onlyPrefixZeroed, this.getAddressCreator(), this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    public IPv4AddressSection mask(IPv4AddressSection mask) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv4AddressSection.getSubnetSegments(this, null, this.getAddressCreator(), true, this::getSegment, mask::getSegment);
    }

    public IPv4AddressSection maskNetwork(IPv4AddressSection mask, int networkPrefixLength) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv4AddressSection.getSubnetSegments(this, networkPrefixLength, this.getAddressCreator(), true, this::getSegment, mask::getSegment);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getNetworkSection(networkPrefixLength, true);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int cidrSegmentCount = this.getNetworkSegmentCount(networkPrefixLength);
        return IPv4AddressSection.getNetworkSection(this, networkPrefixLength, cidrSegmentCount, withPrefixLength, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toNetworkSegment((Integer)prefix, withPrefixLength));
    }

    @Override
    public IPv4AddressSection getHostSection(int networkPrefixLength) {
        int cidrSegmentCount = this.getHostSegmentCount(networkPrefixLength);
        return IPv4AddressSection.getHostSection(this, networkPrefixLength, cidrSegmentCount, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toHostSegment((Integer)prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv4AddressSection iPv4AddressSection = this;
            synchronized (iPv4AddressSection) {
                block5: {
                    if (this.stringCache != null) break block5;
                    this.stringCache = new IPv4StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected IPv4StringCache getStringCache() {
        return this.stringCache;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv4StringCache.canonicalParams);
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            this.stringCache.fullString = result = this.toNormalizedString(IPv4StringCache.fullParams);
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        return this.toCanonicalString();
    }

    @Override
    public String toNormalizedString() {
        return this.toCanonicalString();
    }

    @Override
    protected void cacheNormalizedString(String str) {
        if (this.hasNoStringCache() || this.stringCache.canonicalString == null) {
            this.stringCache.canonicalString = str;
        }
    }

    @Override
    public String toCompressedWildcardString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toSubnetString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toPrefixLengthString() {
        return this.toCanonicalString();
    }

    public String toInetAtonString(IPv4Address.inet_aton_radix radix) {
        String result;
        if (radix == IPv4Address.inet_aton_radix.OCTAL) {
            if (this.hasNoStringCache() || (result = this.stringCache.octalString) == null) {
                this.stringCache.octalString = result = this.toNormalizedString(IPv4StringCache.inetAtonOctalParams);
            }
        } else if (radix == IPv4Address.inet_aton_radix.HEX) {
            if (this.hasNoStringCache() || (result = this.stringCache.hexString) == null) {
                this.stringCache.hexString = result = this.toNormalizedString(IPv4StringCache.inetAtonHexParams);
            }
        } else {
            result = this.toCanonicalString();
        }
        return result;
    }

    public String toInetAtonString(IPv4Address.inet_aton_radix radix, int joinedCount) {
        if (joinedCount <= 0) {
            return this.toInetAtonString(radix);
        }
        IPAddressSection.IPStringOptions stringParams = radix == IPv4Address.inet_aton_radix.OCTAL ? IPv4StringCache.inetAtonOctalParams : (radix == IPv4Address.inet_aton_radix.HEX ? IPv4StringCache.inetAtonHexParams : IPv4StringCache.canonicalParams);
        return this.toNormalizedString(stringParams, joinedCount);
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv4StringCache.normalizedWildcardParams);
        }
        return result;
    }

    @Override
    public String toCanonicalWildcardString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv4StringCache.sqlWildcardParams);
        }
        return result;
    }

    @Override
    public String toReverseDNSLookupString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.reverseDNSString) == null) {
            this.stringCache.reverseDNSString = result = this.toNormalizedString(IPv4StringCache.reverseDNSParams);
        }
        return result;
    }

    public String toNormalizedString(IPAddressSection.IPStringOptions stringParams, int joinCount) {
        if (joinCount <= 0) {
            return this.toNormalizedString(stringParams);
        }
        int thisCount = this.getSegmentCount();
        if (thisCount <= 1) {
            return this.toNormalizedString(stringParams);
        }
        IPAddressDivisionGrouping equivalentPart = this.toJoinedSegments(joinCount);
        return IPv4AddressSection.toNormalizedString(stringParams, equivalentPart);
    }

    public IPAddressDivisionGrouping toJoinedSegments(int joinCount) {
        int totalCount;
        int thisCount = this.getSegmentCount();
        if (joinCount <= 0 || thisCount <= 1) {
            return this;
        }
        if (joinCount >= thisCount) {
            joinCount = thisCount - 1;
            totalCount = 1;
        } else {
            totalCount = thisCount - joinCount;
        }
        int notJoinedCount = totalCount - 1;
        IPAddressDivision[] segs = new IPAddressDivision[totalCount];
        int i = 0;
        while (i < notJoinedCount) {
            segs[i] = this.getDivision(i);
            ++i;
        }
        IPv4JoinedSegments joinedSegment = this.joinSegments(joinCount);
        segs[notJoinedCount] = joinedSegment;
        IPAddressDivisionGrouping equivalentPart = new IPAddressDivisionGrouping(segs);
        return equivalentPart;
    }

    private IPv4JoinedSegments joinSegments(int joinCount) {
        long lower = 0L;
        long upper = 0L;
        int networkPrefixLength = 0;
        Integer prefix = null;
        int firstSegIndex = 0;
        IPv4AddressSegment firstRange = null;
        int firstJoinedIndex = this.getSegmentCount() - 1 - joinCount;
        int j = 0;
        while (j <= joinCount) {
            IPv4AddressSegment thisSeg = this.getSegment(firstJoinedIndex + j);
            if (firstRange != null) {
                if (!thisSeg.isFullRange()) {
                    throw new AddressTypeException(firstRange, firstSegIndex, thisSeg, firstJoinedIndex + j, "ipaddress.error.segmentMismatch");
                }
            } else if (thisSeg.isMultiple()) {
                firstSegIndex = firstJoinedIndex + j;
                firstRange = thisSeg;
            }
            lower = lower << 8 | (long)thisSeg.getLowerSegmentValue();
            upper = upper << 8 | (long)thisSeg.getUpperSegmentValue();
            if (prefix == null) {
                Integer thisSegPrefix = thisSeg.getSegmentPrefixLength();
                if (thisSegPrefix != null) {
                    prefix = networkPrefixLength + thisSegPrefix;
                } else {
                    networkPrefixLength += thisSeg.getBitCount();
                }
            }
            ++j;
        }
        IPv4JoinedSegments joinedSegment = new IPv4JoinedSegments(joinCount, lower, upper, prefix);
        return joinedSegment;
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.DATABASE_SEARCH_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv4StringBuilderOptions.from(opts));
    }

    public IPAddressPartStringCollection toStringCollection(IPv4StringBuilderOptions opts) {
        IPAddressStringDivisionSeries[] parts;
        IPv4SectionStringCollection collection = new IPv4SectionStringCollection();
        IPAddressStringDivisionSeries[] iPAddressStringDivisionSeriesArray = parts = this.getParts(opts);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressStringDivisionSeries part = iPAddressStringDivisionSeriesArray[n2];
            IPv4StringCollection.IPv4StringBuilder builder = new IPv4StringCollection.IPv4StringBuilder(part, opts, new IPv4StringCollection.IPv4AddressSectionStringCollection(part));
            IPv4StringCollection.IPv4AddressSectionStringCollection subCollection = (IPv4StringCollection.IPv4AddressSectionStringCollection)builder.getVariations();
            collection.add(subCollection);
            ++n2;
        }
        return collection;
    }

    @Override
    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv4StringBuilderOptions.from(options));
    }

    public IPAddressStringDivisionSeries[] getParts(IPv4StringBuilderOptions options) {
        if (!options.includesAny(14)) {
            return super.getParts(options);
        }
        ArrayList<IPAddressDivisionGrouping> parts = new ArrayList<IPAddressDivisionGrouping>(4);
        if (options.includes(1)) {
            parts.add(this);
        }
        boolean[] joined = new boolean[4];
        int segmentCount = this.getSegmentCount();
        joined[Math.max((int)3, (int)(segmentCount - 1))] = options.includes(2);
        int n = Math.max(2, Math.min(2, segmentCount - 1));
        joined[n] = joined[n] | options.includes(4);
        int n2 = Math.max(1, Math.min(1, segmentCount - 1));
        joined[n2] = joined[n2] | options.includes(8);
        int i = 1;
        while (i < joined.length) {
            if (joined[i]) {
                parts.add(this.toJoinedSegments(i));
            }
            ++i;
        }
        return parts.toArray(new IPAddressStringDivisionSeries[parts.size()]);
    }

    static class AddressCache
    extends AddressDivisionGrouping.SectionCache<IPv4Address> {
        AddressCache() {
        }
    }

    static class IPv4SectionStringCollection
    extends IPAddressPartStringCollection {
        IPv4SectionStringCollection() {
        }

        @Override
        protected void add(IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>> collection) {
            super.add(collection);
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }
    }

    public static class IPv4StringBuilderOptions
    extends IPAddressSection.IPStringBuilderOptions {
        public static final int JOIN_ALL = 2;
        public static final int JOIN_TWO = 4;
        public static final int JOIN_ONE = 8;
        public static final int ALL_JOINS = 14;
        public static final int IPV6_CONVERSIONS = 65536;
        public static final int OCTAL = 256;
        public static final int HEX = 512;
        public final IPv6AddressSection.IPv6StringBuilderOptions ipv6ConverterOptions;
        public final IPv6Address.IPv6AddressConverter converter;
        public static final IPv4StringBuilderOptions STANDARD_OPTS = new IPv4StringBuilderOptions(17);
        public static final IPv4StringBuilderOptions DATABASE_SEARCH_OPTS = new IPv4StringBuilderOptions();
        public static final IPv4StringBuilderOptions ALL_OPTS = new IPv4StringBuilderOptions(66367, null, new IPv6AddressSection.IPv6StringBuilderOptions(3895));

        public IPv4StringBuilderOptions() {
            this.ipv6ConverterOptions = null;
            this.converter = null;
        }

        public IPv4StringBuilderOptions(int options) {
            this(options, null, null);
        }

        public IPv4StringBuilderOptions(int options, IPv6Address.IPv6AddressConverter ipv6AddressConverter, IPv6AddressSection.IPv6StringBuilderOptions ipv6ConverterOptions) {
            super(options | (ipv6ConverterOptions == null ? 0 : 65536));
            if (this.includes(65536)) {
                if (ipv6ConverterOptions == null) {
                    ipv6ConverterOptions = new IPv6AddressSection.IPv6StringBuilderOptions(3863);
                }
                if (ipv6AddressConverter == null && (ipv6AddressConverter = IPAddress.addressConverter) == null) {
                    ipv6AddressConverter = new IPAddressConverter.DefaultAddressConverter();
                }
            }
            this.ipv6ConverterOptions = ipv6ConverterOptions;
            this.converter = ipv6AddressConverter;
        }

        public static IPv4StringBuilderOptions from(IPAddressSection.IPStringBuilderOptions opts) {
            if (opts instanceof IPv4StringBuilderOptions) {
                return (IPv4StringBuilderOptions)opts;
            }
            return new IPv4StringBuilderOptions(opts.options & 0xFFFEFCF1);
        }
    }

    static class IPv4StringCache
    extends IPAddressSection.IPStringCache {
        private static final IPAddressSection.IPStringOptions fullParams;
        private static final IPAddressSection.IPStringOptions normalizedWildcardParams;
        private static final IPAddressSection.IPStringOptions sqlWildcardParams;
        private static final IPAddressSection.IPStringOptions inetAtonOctalParams;
        private static final IPAddressSection.IPStringOptions inetAtonHexParams;
        private static final IPAddressSection.IPStringOptions canonicalParams;
        static final IPAddressSection.IPStringOptions reverseDNSParams;
        public String octalString;
        public String hexString;

        static {
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            IPAddressSection.WildcardOptions wildcardsRangeOnlyNetworkOnly = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR));
            fullParams = new IPv4StringOptions.Builder().setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).toParams();
            normalizedWildcardParams = new IPv4StringOptions.Builder().setWildcardOptions(allWildcards).toParams();
            sqlWildcardParams = new IPv4StringOptions.Builder().setWildcardOptions(allSQLWildcards).toParams();
            inetAtonOctalParams = new IPv4StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.OCTAL.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix()).toParams();
            inetAtonHexParams = new IPv4StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.HEX.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.HEX.getSegmentStrPrefix()).toParams();
            canonicalParams = new IPv4StringOptions.Builder(10, '.').toParams();
            reverseDNSParams = new IPv4StringOptions.Builder().setWildcardOptions(allWildcards).setReverse(true).setAddressSuffix(".in-addr.arpa").toParams();
        }

        IPv4StringCache() {
        }
    }

    static class IPv4StringCollection
    extends IPAddressPartStringCollection {
        IPv4StringCollection() {
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }

        static class IPv4AddressSectionStringCollection
        extends IPAddressPartStringSubCollection<IPAddressStringDivisionSeries, IPv4StringParams, IPAddressPartConfiguredString<IPAddressStringDivisionSeries, IPv4StringParams>> {
            IPv4AddressSectionStringCollection(IPAddressStringDivisionSeries addr) {
                super(addr);
            }

            @Override
            public Iterator<IPAddressPartConfiguredString<IPAddressStringDivisionSeries, IPv4StringParams>> iterator() {
                return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                    @Override
                    public IPAddressPartConfiguredString<IPAddressStringDivisionSeries, IPv4StringParams> next() {
                        return new IPAddressPartConfiguredString<IPAddressStringDivisionSeries, IPv4StringParams>(part, (IPv4StringParams)this.iterator.next());
                    }
                };
            }
        }

        static class IPv4StringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPAddressStringDivisionSeries, IPv4StringParams, IPAddressPartConfiguredString<IPAddressStringDivisionSeries, IPv4StringParams>, IPv4AddressSectionStringCollection, IPv4StringBuilderOptions> {
            private IPv4StringBuilder(IPAddressStringDivisionSeries address, IPv4StringBuilderOptions options, IPv4AddressSectionStringCollection collection) {
                super(address, options, collection);
            }

            public static boolean isDecimalSameAsOctal(IPAddressStringDivisionSeries part) {
                int count = part.getDivisionCount();
                int i = 0;
                while (i < count) {
                    AddressStringDivision seg = part.getDivision(i);
                    if (!seg.isBoundedBy(8)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            @Override
            public void addAllVariations() {
                ArrayList allParams = new ArrayList();
                ArrayList<Integer> radices = new ArrayList<Integer>();
                radices.add(10);
                if (((IPv4StringBuilderOptions)this.options).includes(512)) {
                    radices.add(16);
                }
                boolean hasDecimalOctalDups = false;
                if (((IPv4StringBuilderOptions)this.options).includes(256)) {
                    radices.add(8);
                    hasDecimalOctalDups = ((IPv4StringBuilderOptions)this.options).includes(112) && IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix().equals("0") && IPv4StringBuilder.isDecimalSameAsOctal(this.addressSection);
                }
                Iterator iterator = radices.iterator();
                while (iterator.hasNext()) {
                    ArrayList<IPv4StringParams> radixParams;
                    block20: {
                        boolean allExpandable;
                        int radix;
                        block17: {
                            radix = (Integer)iterator.next();
                            radixParams = new ArrayList<IPv4StringParams>();
                            IPv4StringParams stringParams = new IPv4StringParams(radix);
                            radixParams.add(stringParams);
                            switch (radix) {
                                case 8: {
                                    stringParams.setSegmentStrPrefix(IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix());
                                    break;
                                }
                                case 16: {
                                    stringParams.setSegmentStrPrefix(IPv4Address.inet_aton_radix.HEX.getSegmentStrPrefix());
                                }
                            }
                            if (!((IPv4StringBuilderOptions)this.options).includes(48)) break block17;
                            int[] expandables = this.getExpandableSegments(radix);
                            int i = 0;
                            while (i < this.addressSection.getDivisionCount()) {
                                int expansionLength = expandables[i];
                                int len = radixParams.size();
                                while (expansionLength > 0) {
                                    int j = 0;
                                    while (j < len) {
                                        block19: {
                                            IPv4StringParams clone;
                                            block18: {
                                                clone = (IPv4StringParams)radixParams.get(j);
                                                if (!hasDecimalOctalDups || radix != 10) break block18;
                                                boolean isDup = true;
                                                int k = 0;
                                                while (k < this.addressSection.getDivisionCount()) {
                                                    int length;
                                                    if (k != i && (length = clone.getExpandedSegmentLength(k)) == 0) {
                                                        isDup = false;
                                                        break;
                                                    }
                                                    ++k;
                                                }
                                                if (isDup) break block19;
                                            }
                                            clone = clone.clone();
                                            clone.expandSegment(i, expansionLength, this.addressSection.getDivisionCount());
                                            radixParams.add(clone);
                                        }
                                        ++j;
                                    }
                                    if (!((IPv4StringBuilderOptions)this.options).includes(112)) break;
                                    --expansionLength;
                                }
                                ++i;
                            }
                            break block20;
                        }
                        if (((IPv4StringBuilderOptions)this.options).includes(16) && (allExpandable = this.isExpandable(radix))) {
                            IPv4StringParams expandParams = new IPv4StringParams(10);
                            expandParams.expandSegments(true);
                            radixParams.add(expandParams);
                        }
                    }
                    allParams.addAll(radixParams);
                }
                int i = 0;
                while (i < allParams.size()) {
                    IPv4StringParams param = (IPv4StringParams)allParams.get(i);
                    this.addStringParam(param);
                    ++i;
                }
            }

            @Override
            protected void addStringParam(IPv4StringParams stringParams) {
                super.addStringParam(stringParams);
            }
        }
    }

    public static class IPv4StringOptions
    extends IPAddressSection.IPStringOptions {
        protected IPv4StringOptions(int base, boolean expandSegments, IPAddressSection.WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, String label, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcardOption, wildcards, segmentStrPrefix, separator, ' ', label, suffix, reverse, splitDigits, uppercase);
        }

        public static class Builder
        extends IPAddressSection.IPStringOptions.Builder {
            public Builder() {
                this(10, '.');
            }

            protected Builder(int base, char separator) {
                super(base, separator);
            }

            @Override
            public IPv4StringOptions toParams() {
                return new IPv4StringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    private static class IPv4StringParams
    extends IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> {
        IPv4StringParams(int radix) {
            super(radix, Character.valueOf('.'), false);
        }

        @Override
        public IPv4StringParams clone() {
            return (IPv4StringParams)super.clone();
        }
    }
}

