/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.IPAddress;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressPart;
import java.math.BigInteger;
import java.util.Arrays;

public class IPAddressSegmentGrouping
implements IPAddressPart,
Comparable<IPAddressSegmentGrouping> {
    private static final long serialVersionUID = 1L;
    protected static final RangeCache ZEROS_CACHE = new RangeCache();
    protected final IPAddressDivision[] divisions;
    protected String string;
    private transient BigInteger cachedCount;
    private transient Integer cachedNetworkPrefix;
    private transient Boolean isMultiple;
    protected int hashCode;

    static {
        if (RangeCache.PRELOAD_CACHE) {
            ZEROS_CACHE.preloadCache(-1);
        }
    }

    public IPAddressSegmentGrouping(IPAddressDivision[] divisions) {
        this.divisions = divisions;
    }

    protected void initCachedValues(Integer cachedNetworkPrefix, BigInteger cachedCount) {
        this.cachedNetworkPrefix = cachedNetworkPrefix;
        this.cachedCount = cachedCount;
    }

    @Override
    public IPAddressDivision getDivision(int index) {
        return this.divisions[index];
    }

    @Override
    public int getDivisionCount() {
        return this.divisions.length;
    }

    @Override
    public int getByteCount() {
        int bytes = 0;
        IPAddressDivision[] iPAddressDivisionArray = this.divisions;
        int n = this.divisions.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressDivision combo = iPAddressDivisionArray[n2];
            bytes += combo.getByteCount();
            ++n2;
        }
        return bytes;
    }

    public int getBitCount() {
        int bits = 0;
        IPAddressDivision[] iPAddressDivisionArray = this.divisions;
        int n = this.divisions.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressDivision combo = iPAddressDivisionArray[n2];
            bits += combo.getBitCount();
            ++n2;
        }
        return bits;
    }

    public boolean isPrefixed() {
        return this.divisions.length > 0 && this.divisions[this.divisions.length - 1].isPrefixed();
    }

    @Override
    public Integer getNetworkPrefixLength() {
        Integer ret = this.cachedNetworkPrefix;
        if (ret == null) {
            if (this.isPrefixed()) {
                int result = 0;
                int i = 0;
                while (i < this.divisions.length) {
                    IPAddressDivision div = this.divisions[i];
                    Integer prefix = div.getDivisionPrefixLength();
                    if (prefix != null) {
                        result += prefix.intValue();
                        break;
                    }
                    result += div.getBitCount();
                    ++i;
                }
                this.cachedNetworkPrefix = result;
                return this.cachedNetworkPrefix;
            }
            this.cachedNetworkPrefix = -1;
            return null;
        }
        if (ret < 0) {
            return null;
        }
        return ret;
    }

    public BigInteger getCount() {
        if (this.cachedCount != null) {
            return this.cachedCount;
        }
        BigInteger result = BigInteger.ONE;
        if (this.isMultiple()) {
            int i = 0;
            while (i < this.divisions.length) {
                long segCount = this.divisions[i].getCount();
                result = result.multiply(BigInteger.valueOf(segCount));
                ++i;
            }
        }
        this.cachedCount = result;
        return this.cachedCount;
    }

    @Override
    public boolean isMultiple() {
        Boolean result = this.isMultiple;
        if (result == null) {
            int i = this.divisions.length - 1;
            while (i >= 0) {
                IPAddressDivision seg = this.divisions[i];
                if (seg.isMultiple()) {
                    this.isMultiple = true;
                    return this.isMultiple;
                }
                --i;
            }
            this.isMultiple = false;
            return this.isMultiple;
        }
        return result;
    }

    public boolean isMultipleByNetworkPrefix() {
        if (!this.isPrefixed()) {
            return false;
        }
        IPAddressDivision div = this.divisions[this.divisions.length - 1];
        return div.getDivisionPrefixLength() < div.getBitCount();
    }

    public boolean isRangeEquivalentToPrefix() {
        if (!this.isMultipleByNetworkPrefix()) {
            return !this.isMultiple();
        }
        int i = 0;
        while (i < this.divisions.length) {
            IPAddressDivision div = this.divisions[i];
            if (div.isPrefixed() && div.getDivisionPrefixLength() == 0) break;
            if (!div.isRangeEquivalentToPrefix()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int res = this.hashCode;
        if (res == 0) {
            int fullResult = 1;
            int i = 0;
            while (i < this.getDivisionCount()) {
                IPAddressDivision combo = this.getDivision(i);
                long value = combo.getLowerValue();
                long shifted = value >>> 32;
                int adjusted = (int)(shifted == 0L ? value : value ^ shifted);
                fullResult = 31 * fullResult + adjusted;
                long upperValue = combo.getUpperValue();
                if (upperValue != value) {
                    shifted = upperValue >>> 32;
                    adjusted = (int)(shifted == 0L ? upperValue : upperValue ^ shifted);
                    fullResult = 31 * fullResult + adjusted;
                }
                ++i;
            }
            this.hashCode = res = fullResult;
        }
        return res;
    }

    protected boolean isSameGrouping(IPAddressSegmentGrouping other) {
        IPAddressDivision[] oneSegs = this.divisions;
        IPAddressDivision[] twoSegs = other.divisions;
        if (oneSegs.length != twoSegs.length) {
            return false;
        }
        int i = 0;
        while (i < oneSegs.length) {
            IPAddressDivision one = oneSegs[i];
            IPAddressDivision two = twoSegs[i];
            if (!one.isSameValues(two)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressSegmentGrouping) {
            IPAddressSegmentGrouping other = (IPAddressSegmentGrouping)o;
            return other.isSameGrouping(this);
        }
        return false;
    }

    @Override
    public int compareTo(IPAddressSegmentGrouping other) {
        return IPAddress.addressComparator.compare(this, other);
    }

    public String toString() {
        if (this.string == null) {
            this.string = Arrays.asList(this.divisions).toString();
        }
        return this.string;
    }

    public boolean isZero() {
        int i = 0;
        while (i < this.getDivisionCount()) {
            if (!this.getDivision(i).isZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public RangeList getZeroSegments() {
        return this.getZeroSegments(false);
    }

    public RangeList getZeroRangeSegments() {
        if (this.isPrefixed()) {
            return this.getZeroSegments(true);
        }
        return this.getZeroSegments();
    }

    protected static RangeList getNoZerosRange() {
        return RangeCache.NO_ZEROS;
    }

    protected static RangeList getSingleRange(int index, int len) {
        RangeCache cache = ZEROS_CACHE.addRange(index, -1, len);
        return cache.get();
    }

    protected RangeList getZeroSegments(boolean includeRanges) {
        RangeCache cache = ZEROS_CACHE;
        int divisionCount = this.getDivisionCount();
        int currentIndex = -1;
        int lastIndex = -1;
        int currentCount = 0;
        int i = 0;
        while (i < divisionCount) {
            boolean isCompressible;
            IPAddressDivision division = this.getDivision(i);
            boolean bl = isCompressible = division.isZero() || includeRanges && division.isSamePrefixedRange(0L);
            if (isCompressible) {
                if (++currentCount == 1) {
                    currentIndex = i;
                }
                if (i == divisionCount - 1) {
                    cache = cache.addRange(currentIndex, lastIndex, currentCount);
                    lastIndex = currentIndex + currentCount;
                }
            } else if (currentCount > 0) {
                cache = cache.addRange(currentIndex, lastIndex, currentCount);
                lastIndex = currentIndex + currentCount;
                currentCount = 0;
            }
            ++i;
        }
        return cache.get();
    }

    public static class Range {
        public final int index;
        public final int length;

        Range(int index, int length) {
            this.index = index;
            this.length = length;
        }

        public String toString() {
            return "[" + this.index + ',' + (this.index + this.length) + ']';
        }
    }

    private static class RangeCache {
        static boolean PRELOAD_CACHE;
        static final int MAX_DIVISION_COUNT = 8;
        static final RangeList NO_ZEROS;
        RangeCache[][] nextRange;
        RangeCache parent;
        RangeList zeroRanges;
        Range range;

        static {
            NO_ZEROS = new RangeList(new Range[0]);
        }

        RangeCache() {
            this(null, 8, null);
            this.zeroRanges = NO_ZEROS;
        }

        private RangeCache(RangeCache parent, int potentialZeroOffsets, Range range) {
            if (potentialZeroOffsets > 0) {
                this.nextRange = new RangeCache[potentialZeroOffsets][];
                int i = 0;
                while (i < potentialZeroOffsets) {
                    this.nextRange[i] = new RangeCache[potentialZeroOffsets - i];
                    ++i;
                }
            }
            this.parent = parent;
            this.range = range;
        }

        private void get(Range[] ranges, int rangesIndex) {
            ranges[--rangesIndex] = this.range;
            if (rangesIndex > 0) {
                this.parent.get(ranges, rangesIndex);
            }
        }

        public RangeList get() {
            RangeList result = this.zeroRanges;
            if (result == null) {
                int depth = 0;
                RangeCache up = this.parent;
                while (up != null) {
                    ++depth;
                    up = up.parent;
                }
                Range[] ranges = new Range[depth];
                if (depth > 0) {
                    ranges[--depth] = this.range;
                    if (depth > 0) {
                        this.parent.get(ranges, depth);
                    }
                }
                this.zeroRanges = result = new RangeList(ranges);
            }
            return result;
        }

        void preloadCache(int lastIndex) {
            if (this.nextRange != null) {
                int j;
                RangeCache[] next;
                int i = 0;
                while (i < this.nextRange.length) {
                    next = this.nextRange[i];
                    j = 0;
                    while (j < next.length) {
                        Range newRange = lastIndex == -1 ? new Range(i + lastIndex + 1, j + 1) : IPAddressSegmentGrouping.ZEROS_CACHE.nextRange[i + lastIndex + 1][j].range;
                        int nextPotentialZeroIndex = i + lastIndex + j + 3;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        RangeCache newRangeCache = new RangeCache(this, remainingPotentialZeroOffsets, newRange);
                        newRangeCache.get();
                        next[j] = newRangeCache;
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.nextRange.length) {
                    next = this.nextRange[i];
                    j = 0;
                    while (j < next.length) {
                        RangeCache nextCache = next[j];
                        Range nextRange = nextCache.range;
                        nextCache.preloadCache(nextRange.index + nextRange.length);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RangeCache addRange(int currentIndex, int lastIndex, int currentCount) {
            int offset = currentIndex - lastIndex;
            int cacheOffset = offset - 1;
            int cacheCount = currentCount - 1;
            RangeCache next = this.nextRange[cacheOffset][cacheCount];
            if (next == null) {
                RangeCache rangeCache = this;
                synchronized (rangeCache) {
                    next = this.nextRange[cacheOffset][cacheCount];
                    if (next == null) {
                        Range newRange;
                        int nextPotentialZeroIndex = lastIndex + 1;
                        int remainingPotentialZeroOffsets = 8 - nextPotentialZeroIndex;
                        if (this == ZEROS_CACHE) {
                            newRange = new Range(currentIndex, currentCount);
                        } else {
                            RangeCache rootNext = IPAddressSegmentGrouping.ZEROS_CACHE.nextRange[currentIndex][currentCount - 1];
                            if (rootNext == null) {
                                newRange = new Range(currentIndex, currentCount);
                                IPAddressSegmentGrouping.ZEROS_CACHE.nextRange[currentIndex][currentCount - 1] = new RangeCache(ZEROS_CACHE, 8, newRange);
                            } else {
                                newRange = rootNext.range;
                            }
                        }
                        this.nextRange[cacheOffset][cacheCount] = next = new RangeCache(this, remainingPotentialZeroOffsets, newRange);
                    }
                }
            }
            return next;
        }
    }

    public static class RangeList {
        final Range[] ranges;

        RangeList(Range[] ranges) {
            this.ranges = ranges;
        }

        public int size() {
            return this.ranges.length;
        }

        public Range getRange(int index) {
            return this.ranges[index];
        }
    }
}

