/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.util.function.BiFunction;

public class IPv6AddressNetwork
extends IPAddressTypeNetwork<IPv6Address, IPv6AddressSegment> {
    private static final IPv6AddressSegment[] emptySegments = new IPv6AddressSegment[0];
    private static final IPv6AddressSection[] emptySection = new IPv6AddressSection[0];

    IPv6AddressNetwork() {
        super(IPv6Address.class);
    }

    @Override
    protected BiFunction<IPv6Address, Integer, IPv6AddressSegment> getSegmentProducer() {
        return (address, index) -> address.getSegment((int)index);
    }

    protected IPv6AddressCreator createAddressCreator() {
        return new IPv6AddressCreator();
    }

    @Override
    protected IPv6Address createLoopback() {
        IPv6AddressCreator creator = this.getAddressCreator();
        IPv6AddressSegment zero = IPv6AddressSegment.ZERO_SEGMENT;
        IPv6AddressSegment[] segs = creator.createSegmentArray(8);
        segs[5] = segs[6] = zero;
        segs[4] = segs[6];
        segs[3] = segs[6];
        segs[2] = segs[6];
        segs[1] = segs[6];
        segs[0] = segs[6];
        segs[7] = creator.createSegment(1);
        return creator.createAddressInternal(segs);
    }

    public IPv6AddressCreator getAddressCreator() {
        return (IPv6AddressCreator)super.getAddressCreator();
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    public static class IPv6AddressCreator
    extends IPAddressTypeNetwork.IPAddressCreator<IPv6Address, IPv6AddressSection, IPv6AddressSegment>
    implements IPv6AddressSegmentCreator {
        static boolean CACHE_SEGMENTS_BY_PREFIX = true;
        private static IPv6AddressSegment[][] segmentCache = new IPv6AddressSegment[511][];
        private static IPv6AddressSegment[][][] segmentPrefixCache = new IPv6AddressSegment[16][][];
        private static IPv6AddressSegment[] allPrefixedCache = new IPv6AddressSegment[16];

        public IPv6AddressSegment[] createSegmentArray(int length) {
            if (length == 0) {
                return emptySegments;
            }
            return new IPv6AddressSegment[length];
        }

        @Override
        public IPv6AddressSegment createSegment(int value) {
            IPv6AddressSegment result;
            IPv6AddressSegment[][] cache = segmentCache;
            int blockIndex = value >>> 8;
            int resultIndex = value - (blockIndex << 8);
            IPv6AddressSegment[] block = cache[blockIndex];
            if (block == null) {
                block = new IPv6AddressSegment[256];
                cache[blockIndex] = block;
                result = block[resultIndex] = new IPv6AddressSegment(value);
            } else {
                result = block[resultIndex];
                if (result == null) {
                    result = block[resultIndex] = new IPv6AddressSegment(value);
                }
            }
            return result;
        }

        @Override
        public IPv6AddressSegment createSegment(int value, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                return this.createSegment(value);
            }
            if (segmentPrefixLength == 0) {
                return IPv6AddressSegment.ZERO_PREFIX_SEGMENT;
            }
            if (CACHE_SEGMENTS_BY_PREFIX) {
                int prefixCacheSize;
                int bitsPerSegment = 16;
                if (segmentPrefixLength > bitsPerSegment) {
                    segmentPrefixLength = bitsPerSegment;
                }
                int mask = IPv6Address.network().getSegmentNetworkMask(segmentPrefixLength);
                int prefixIndex = segmentPrefixLength - 1;
                int valueIndex = (value &= mask) >>> bitsPerSegment - segmentPrefixLength;
                IPv6AddressSegment[][][] cache = segmentPrefixCache;
                IPv6AddressSegment[][] prefixCache = cache[prefixIndex];
                IPv6AddressSegment[] block = null;
                IPv6AddressSegment result = null;
                int blockIndex = valueIndex >>> 8;
                int resultIndex = valueIndex - (blockIndex << 8);
                boolean blockExists = false;
                boolean resultExists = false;
                if (prefixCache == null) {
                    prefixCacheSize = 1 << segmentPrefixLength;
                    cache[prefixIndex] = new IPv6AddressSegment[prefixCacheSize + 256 - 1 >>> 8][];
                } else {
                    block = cache[prefixIndex][blockIndex];
                    boolean bl = blockExists = block != null;
                    if (blockExists) {
                        result = block[resultIndex];
                        boolean bl2 = resultExists = result != null;
                    }
                }
                if (!blockExists) {
                    prefixCacheSize = 1 << segmentPrefixLength;
                    int highestIndex = prefixCacheSize >>> 8;
                    block = valueIndex >>> 8 == highestIndex ? new IPv6AddressSegment[prefixCacheSize - (highestIndex << 8)] : new IPv6AddressSegment[256];
                    cache[prefixIndex][blockIndex] = block;
                }
                if (!resultExists) {
                    result = block[resultIndex] = new IPv6AddressSegment(value, segmentPrefixLength);
                }
                return result;
            }
            IPv6AddressSegment result = new IPv6AddressSegment(value, segmentPrefixLength);
            return result;
        }

        @Override
        public IPv6AddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                if (lower == upper) {
                    return this.createSegment(lower);
                }
                if (lower == 0 && upper == 65535) {
                    return IPv6AddressSegment.ALL_RANGE_SEGMENT;
                }
            } else {
                if (segmentPrefixLength == 0) {
                    return this.createSegment(0, 0);
                }
                if (CACHE_SEGMENTS_BY_PREFIX) {
                    int mask = IPv6Address.network().getSegmentNetworkMask(segmentPrefixLength);
                    if ((upper & mask) == (lower &= mask)) {
                        return this.createSegment(lower, segmentPrefixLength);
                    }
                    if (lower == 0 && upper == mask) {
                        IPv6AddressSegment[] cache = allPrefixedCache;
                        int prefixIndex = segmentPrefixLength - 1;
                        IPv6AddressSegment result = cache[prefixIndex];
                        if (result == null) {
                            cache[prefixIndex] = result = new IPv6AddressSegment(0, 65535, segmentPrefixLength);
                        }
                        return result;
                    }
                }
            }
            IPv6AddressSegment result = new IPv6AddressSegment(lower, upper, segmentPrefixLength);
            return result;
        }

        @Override
        protected IPv6AddressSection createSectionInternal(byte[] bytes, Integer prefix) {
            return new IPv6AddressSection(bytes, prefix, false);
        }

        protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments) {
            return new IPv6AddressSection(segments, 0, false);
        }

        protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments, IPv4AddressSection mixedSection) {
            IPv6AddressSection result = new IPv6AddressSection(segments, 0, false);
            result.embeddedIPv4Section = mixedSection;
            return result;
        }

        protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments, int startIndex) {
            return new IPv6AddressSection(segments, startIndex, false);
        }

        protected IPv6AddressSection[] createSectionArray(int length) {
            if (length == 0) {
                return emptySection;
            }
            return new IPv6AddressSection[length];
        }

        public IPv6AddressSection createSection(byte[] bytes, Integer prefix) {
            return new IPv6AddressSection(bytes, prefix);
        }

        public IPv6AddressSection createSection(IPv6AddressSegment[] segments) {
            return new IPv6AddressSection(segments);
        }

        public IPv6AddressSection createSection(IPv6AddressSegment[] segments, Integer networkPrefixLength) {
            return new IPv6AddressSection(segments, networkPrefixLength);
        }

        protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments, String zone) {
            return this.createAddress(this.createSectionInternal(segments), zone);
        }

        protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
            return this.createAddress(this.createSectionInternal(segments), (String)null);
        }

        @Override
        public IPv6Address createAddress(IPv6AddressSection section, String zone) {
            return new IPv6Address(section, (CharSequence)zone);
        }

        public IPv6Address createAddress(IPv6AddressSection section) {
            return this.createAddress(section, (String)null);
        }
    }

    protected static interface IPv6AddressSegmentCreator
    extends IPAddressTypeNetwork.IPAddressSegmentCreator<IPv6AddressSegment> {
    }
}

