/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.okhttp;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.httpclient.okhttp.OkHttpFuture;
import com.github.scribejava.httpclient.okhttp.OkHttpHttpClient;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

class OAuthAsyncCompletionHandler<T>
implements Callback {
    private final OAuthAsyncRequestCallback<T> callback;
    private final OAuthRequest.ResponseConverter<T> converter;
    private final OkHttpFuture<T> okHttpFuture;

    OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter, OkHttpFuture<T> okHttpFuture) {
        this.callback = callback;
        this.converter = converter;
        this.okHttpFuture = okHttpFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Call call, IOException exception) {
        try {
            this.okHttpFuture.setException(exception);
            if (this.callback != null) {
                this.callback.onThrowable((Throwable)exception);
            }
        }
        finally {
            this.okHttpFuture.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response okHttpResponse) {
        try {
            com.github.scribejava.core.model.Response response = OkHttpHttpClient.convertResponse(okHttpResponse);
            try {
                com.github.scribejava.core.model.Response t = this.converter == null ? response : this.converter.convert(response);
                this.okHttpFuture.setResult(t);
                if (this.callback != null) {
                    this.callback.onCompleted((Object)t);
                }
            }
            catch (IOException | RuntimeException e) {
                this.okHttpFuture.setException(e);
                if (this.callback != null) {
                    this.callback.onThrowable((Throwable)e);
                }
            }
        }
        finally {
            this.okHttpFuture.finish();
        }
    }
}

