/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.apis.ImgurApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuth20Service;

public class ImgurOAuthServiceImpl
extends OAuth20Service {
    public ImgurOAuthServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(Verifier verifier, T request) {
        OAuthConfig config = this.getConfig();
        request.addBodyParameter("client_id", config.getApiKey());
        request.addBodyParameter("client_secret", config.getApiSecret());
        if (ImgurApi.isOob(config)) {
            request.addBodyParameter("grant_type", "pin");
            request.addBodyParameter("pin", verifier.getValue());
        } else {
            request.addBodyParameter("grant_type", "authorization_code");
            request.addBodyParameter("code", verifier.getValue());
        }
        return request;
    }

    public void signRequest(Token accessToken, AbstractRequest request) {
        request.addHeader("Authorization", accessToken == null ? "Client-ID " + this.getConfig().getApiKey() : "Bearer " + accessToken.getToken());
    }
}

