/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal;

import com.github.sbt.junit.jupiter.internal.Color;
import com.github.sbt.junit.jupiter.internal.ColorTheme;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.options.Options;
import java.text.MessageFormat;
import sbt.testing.Logger;

public class TestLogger {
    private final ColorTheme colorTheme;
    private final Configuration configuration;
    private final Logger[] loggers;
    private final Options options;

    TestLogger(Logger[] loggerArray, Configuration configuration) {
        this.loggers = loggerArray;
        this.configuration = configuration;
        this.options = configuration.getOptions();
        this.colorTheme = configuration.getColorTheme();
    }

    public void debug(String string, Object ... objectArray) {
        this.log(Level.DEBUG, string, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.log(Level.ERROR, string, objectArray);
    }

    public void error(String string, String string2, Throwable throwable) {
        this.log(Level.ERROR, string2, new Object[0]);
        if (null == throwable) {
            return;
        }
        if (throwable instanceof AssertionError && !this.options.isAssertLogEnabled()) {
            return;
        }
        this.logStackTrace(string, throwable);
    }

    public void info(String string, Object ... objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public void warn(String string, Object ... objectArray) {
        this.log(Level.WARN, string, objectArray);
    }

    private void log(Level level, String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = MessageFormat.format(string, objectArray);
        }
        block6: for (Logger logger : this.loggers) {
            if (!logger.ansiCodesSupported() && this.options.isColorsEnabled()) {
                string = Color.filter(string);
            }
            switch (level) {
                case DEBUG: {
                    logger.debug(string);
                    continue block6;
                }
                case ERROR: {
                    logger.error(string);
                    continue block6;
                }
                case INFO: {
                    logger.info(string);
                    continue block6;
                }
                case WARN: {
                    logger.warn(string);
                }
            }
        }
    }

    private void logStackTrace(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = this.options.isColorsEnabled() ? this.findTestFileName(stackTraceElementArray, string) : null;
        this.logStackTracePart(stackTraceElementArray, stackTraceElementArray.length - 1, 0, throwable, string, string2);
    }

    private void logStackTracePart(StackTraceElement[] stackTraceElementArray, int n, int n2, Throwable throwable, String string, String string2) {
        int n3;
        int n4;
        int n5 = n;
        for (n4 = n3 = 0; n4 <= n; ++n4) {
            String string3;
            if (!stackTraceElementArray[n4].toString().startsWith("org.junit.") && !stackTraceElementArray[n4].toString().startsWith("org.hamcrest.")) continue;
            if (n4 == n3) {
                ++n3;
                continue;
            }
            for (n = n4 - 1; n > n3 && ((string3 = stackTraceElementArray[n].toString()).startsWith("java.lang.reflect.") || string3.startsWith("sun.reflect.")); --n) {
            }
            break;
        }
        for (n4 = n3; n4 <= n; ++n4) {
            this.error("    at " + this.stackTraceElementToString(stackTraceElementArray[n4], string, string2), new Object[0]);
        }
        if (n5 != n) {
            this.error("    ...", new Object[0]);
        } else if (n2 != 0) {
            this.error("    ... " + n2 + " more", new Object[0]);
        }
        this.logStackTraceAsCause(stackTraceElementArray, throwable.getCause(), string, string2);
    }

    private void logStackTraceAsCause(StackTraceElement[] stackTraceElementArray, Throwable throwable, String string, String string2) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        this.error("Caused by: " + throwable, new Object[0]);
        this.logStackTracePart(stackTraceElementArray2, n, stackTraceElementArray2.length - 1 - n, throwable, string, string2);
    }

    private String findTestFileName(StackTraceElement[] stackTraceElementArray, String string) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            if (!string.equals(string2)) continue;
            return stackTraceElement.getFileName();
        }
        return null;
    }

    private String stackTraceElementToString(StackTraceElement stackTraceElement, String string, String string2) {
        boolean bl = this.options.isColorsEnabled() && (string.equals(stackTraceElement.getClassName()) || string2 != null && string2.equals(stackTraceElement.getFileName()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.configuration.decodeName(stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName()));
        stringBuilder.append('(');
        if (stackTraceElement.isNativeMethod()) {
            Color color = bl ? this.colorTheme.nativeMethod() : Color.NONE;
            stringBuilder.append(color.format("Native Method"));
        } else if (null == stackTraceElement.getFileName()) {
            Color color = bl ? this.colorTheme.unknownSource() : Color.NONE;
            stringBuilder.append(color.format("Unknown Source"));
        } else {
            Color color = bl ? this.colorTheme.testFile() : Color.NONE;
            stringBuilder.append(color.format(stackTraceElement.getFileName()));
            if (stackTraceElement.getLineNumber() >= 0) {
                Color color2 = bl ? this.colorTheme.testFileLineNumber() : Color.NONE;
                stringBuilder.append(':');
                stringBuilder.append(color2.format(String.valueOf(stackTraceElement.getLineNumber())));
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static enum Level {
        INFO,
        ERROR,
        DEBUG,
        WARN;

    }
}

