/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.Ansi;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.runner.Description;

class RunSettings {
    private static final Object NULL = new Object();
    final boolean color;
    final boolean quiet;
    final boolean logAssert;
    final boolean logExceptionClass;
    final Verbosity verbosity;
    final Summary summary;
    final ArrayList<String> globPatterns;
    final Set<String> includeCategories;
    final Set<String> excludeCategories;
    final String testFilter;
    private final boolean decodeScalaNames;
    private final HashMap<String, String> sysprops;
    private final HashSet<String> ignoreRunners = new HashSet();

    RunSettings(boolean bl, boolean bl2, boolean bl3, Verbosity verbosity, Summary summary, boolean bl4, String string, boolean bl5, HashMap<String, String> hashMap, ArrayList<String> arrayList, Set<String> set, Set<String> set2, String string2) {
        this.color = bl;
        this.decodeScalaNames = bl2;
        this.quiet = bl3;
        this.verbosity = verbosity;
        this.summary = summary;
        this.logAssert = bl4;
        this.logExceptionClass = bl5;
        for (String string3 : string.split(",")) {
            this.ignoreRunners.add(string3.trim());
        }
        this.sysprops = hashMap;
        this.globPatterns = arrayList;
        this.includeCategories = set;
        this.excludeCategories = set2;
        this.testFilter = string2;
    }

    public RunSettings withTestFilter(String string) {
        String string2 = String.join((CharSequence)",", this.ignoreRunners);
        return new RunSettings(this.color, this.decodeScalaNames, this.quiet, this.verbosity, this.summary, this.logAssert, string2, this.logExceptionClass, this.sysprops, this.globPatterns, this.includeCategories, this.excludeCategories, string);
    }

    String decodeName(String string) {
        return this.decodeScalaNames ? RunSettings.decodeScalaName(string) : string;
    }

    private static String decodeScalaName(String string) {
        try {
            Class<?> clazz = Class.forName("scala.reflect.NameTransformer");
            Method method = clazz.getMethod("decode", String.class);
            String string2 = (String)method.invoke(null, string);
            return string2 == null ? string : string2;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    String buildInfoName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[36m", "\u001b[33m");
    }

    String buildErrorName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[31m", "\u001b[33m");
    }

    String buildPlainName(Description description) {
        return this.buildColoredName(description, null, null, null);
    }

    String buildColoredMessage(Throwable throwable, String string) {
        int n;
        if (throwable == null) {
            return "null";
        }
        if (!this.logExceptionClass || !this.logAssert && throwable instanceof AssertionError) {
            return throwable.getMessage();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.decodeName(throwable.getClass().getName());
        int n2 = string2.indexOf(36);
        int n3 = n = n2 == -1 ? string2.lastIndexOf(46) : string2.lastIndexOf(46, n2);
        if (n == -1) {
            stringBuilder.append(Ansi.c(string2, string));
        } else {
            stringBuilder.append(string2, 0, n);
            stringBuilder.append('.');
            stringBuilder.append(Ansi.c(string2.substring(n + 1), string));
        }
        stringBuilder.append(": ").append(throwable.getMessage());
        return stringBuilder.toString();
    }

    String buildInfoMessage(Throwable throwable) {
        return this.buildColoredMessage(throwable, "\u001b[36m");
    }

    String buildErrorMessage(Throwable throwable) {
        return this.buildColoredMessage(throwable, "\u001b[31m");
    }

    private String buildColoredName(Description description, String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = this.decodeName(description.getClassName());
        int n2 = string4.indexOf(36);
        int n3 = n = n2 == -1 ? string4.lastIndexOf(46) : string4.lastIndexOf(46, n2);
        if (n == -1) {
            stringBuilder.append(Ansi.c(string4, string));
        } else {
            stringBuilder.append(string4, 0, n);
            stringBuilder.append('.');
            stringBuilder.append(Ansi.c(string4.substring(n + 1), string));
        }
        String string5 = description.getMethodName();
        if (string5 != null) {
            stringBuilder.append('.');
            int n4 = string5.lastIndexOf(91);
            int n5 = string5.lastIndexOf(93);
            if (n4 == -1 || n5 < n4) {
                stringBuilder.append(Ansi.c(this.decodeName(string5), string2));
            } else {
                stringBuilder.append(Ansi.c(this.decodeName(string5.substring(0, n4)), string2));
                stringBuilder.append('[');
                stringBuilder.append(Ansi.c(string5.substring(n4 + 1, n5), string3));
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    boolean ignoreRunner(String string) {
        return this.ignoreRunners.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> overrideSystemProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Properties properties = System.getProperties();
        synchronized (properties) {
            for (Map.Entry<String, String> entry : this.sysprops.entrySet()) {
                String string = System.getProperty(entry.getKey());
                hashMap.put(entry.getKey(), string == null ? NULL : string);
            }
            for (Map.Entry<String, String> entry : this.sysprops.entrySet()) {
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSystemProperties(Map<String, Object> map) {
        Properties properties = System.getProperties();
        synchronized (properties) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == NULL) {
                    System.clearProperty(entry.getKey());
                    continue;
                }
                System.setProperty(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    static enum Summary {
        SBT,
        ONE_LINE,
        LIST_FAILED;

    }

    static enum Verbosity {
        TERSE,
        RUN_FINISHED,
        STARTED,
        TEST_FINISHED;

    }
}

