/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.overcast;

import com.github.sarxos.overcast.Instance;
import com.github.sarxos.overcast.Mapping;
import com.github.sarxos.overcast.OvercastAbstractMojo;
import com.jcabi.log.Logger;
import com.typesafe.config.Config;
import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.host.CloudHostFactory;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="setup", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class OvercastSetupMojo
extends OvercastAbstractMojo {
    protected CloudHost setup(String name) {
        Logger.debug((Object)((Object)this), (String)("Setting up instance " + name));
        CloudHost cloud = CloudHostFactory.getCloudHost((String)name);
        cloud.setup();
        return cloud;
    }

    @Override
    public void run() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Instance instance : this.getInstances()) {
            String name = instance.getName();
            if (!config.hasPath(name)) {
                throw new MojoExecutionException("Overcast configuration file " + this.getConfFile().getAbsolutePath() + " does not define '" + name + "' instance");
            }
            CloudHost cloud = this.setup(name);
            Mapping mapping = this.map(instance, cloud);
            mappings.add(mapping);
        }
        this.store(mappings);
    }

    @Override
    public String toString() {
        return "OvercastSetupMojo()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OvercastSetupMojo)) {
            return false;
        }
        OvercastSetupMojo other = (OvercastSetupMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OvercastSetupMojo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

