/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.omp;

import com.github.sarxos.omp.Instance;
import com.xebialabs.overcast.host.CloudHost;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Mapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String host;
    private final Map<Integer, Integer> ports;
    private final transient CloudHost cloud;

    public Mapping(Instance instance, CloudHost cloud) {
        String host = cloud.getHostName();
        if (host == null) {
            host = "localhost";
        }
        HashMap<Integer, Integer> ports = new HashMap<Integer, Integer>();
        for (Integer port : instance.getPorts()) {
            ports.put(port, cloud.getPort(port.intValue()));
        }
        this.name = instance.getName();
        this.host = host;
        this.ports = ports;
        this.cloud = cloud;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Map<Integer, Integer> getPorts() {
        return this.ports;
    }

    public CloudHost getCloud() {
        return this.cloud;
    }
}

