/*
 * Decompiled with CFR 0.152.
 */
package com.github.saran2020.dragrating;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.github.saran2020.dragrating.R;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001:\u00018B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J(\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0006\u0010&\u001a\u00020\u000bJ\b\u0010'\u001a\u00020\u0018H\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\u0012\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u001a\u0010/\u001a\u00020\u001e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0#J\u001a\u00100\u001a\u00020\u001e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070#J\u000e\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u000bJ\u0018\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020\u0007H\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00107\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0004R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/github/saran2020/dragrating/DragRatingView;", "Landroid/support/v7/widget/LinearLayoutCompat;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "assetMap", "Ljava/util/SortedMap;", "", "Landroid/graphics/drawable/Drawable;", "callback", "Lcom/github/saran2020/dragrating/DragRatingView$RatingChangeCallback;", "getCallback", "()Lcom/github/saran2020/dragrating/DragRatingView$RatingChangeCallback;", "setCallback", "(Lcom/github/saran2020/dragrating/DragRatingView$RatingChangeCallback;)V", "value", "currentRating", "setCurrentRating", "(F)V", "mIsDragging", "", "mScaledTouchSlop", "mTouchDownX", "maxRating", "ratingSpace", "addRatingViews", "", "pos", "addViews", "convertToDrawableMap", "map", "", "getImageView", "Landroid/widget/ImageView;", "getRating", "isInScrollingContainer", "onStartTrackingTouch", "onStopTrackingTouch", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "refreshRatingView", "roundOffRating", "setDrawableAssetMap", "setDrawableResourceAssetMap", "setRating", "rating", "setRatingResource", "imageView", "index", "startDrag", "trackTouchEvent", "RatingChangeCallback", "dragrating_release"})
public class DragRatingView
extends LinearLayoutCompat {
    private boolean mIsDragging;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private float ratingSpace;
    private int maxRating;
    private float currentRating;
    @Nullable
    private RatingChangeCallback callback;
    private SortedMap<Float, Drawable> assetMap;
    private HashMap _$_findViewCache;

    private final void setCurrentRating(float value) {
        if (value > (float)this.maxRating) {
            throw (Throwable)new IllegalArgumentException("Rating cannot be more than max rating");
        }
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Rating cannot be less than 0");
        }
        float previousRating = this.currentRating;
        float newRating = this.roundOffRating(value);
        if (previousRating == newRating) {
            return;
        }
        this.currentRating = newRating;
        RatingChangeCallback ratingChangeCallback = this.callback;
        if (ratingChangeCallback != null) {
            ratingChangeCallback.onRatingChanged(previousRating, this.currentRating);
        }
        Log.d((String)"buggy_bug", (String)("current rating " + this.currentRating));
        this.refreshRatingView();
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshRatingView() {
        int n = 0;
        int n2 = this.getChildCount();
        if (n <= n2) {
            while (true) {
                void i;
                View childAt;
                if ((childAt = this.getChildAt((int)i)) != null) {
                    this.setRatingResource((ImageView)childAt, (int)i);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    @Nullable
    public final RatingChangeCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable RatingChangeCallback ratingChangeCallback) {
        this.callback = ratingChangeCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final float roundOffRating(float value) {
        float f = value;
        boolean bl = false;
        float f2 = (float)Math.floor(value);
        float decimalMultiplied = (f - f2) * (float)100;
        Set<Float> set = this.assetMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"assetMap.keys");
        List keys = CollectionsKt.toList((Iterable)set);
        int previous = 0;
        int n = 1;
        int n2 = this.assetMap.size();
        while (n < n2) {
            void current;
            float currentMultiple = ((Number)keys.get((int)current)).floatValue() * (float)100;
            float previousMultiple = ((Number)keys.get(previous)).floatValue() * (float)100;
            if (decimalMultiplied > previousMultiple && decimalMultiplied < currentMultiple) {
                float f3;
                float differPreviousMultiple = decimalMultiplied - previousMultiple;
                float differCurrentMultiple = currentMultiple - decimalMultiplied;
                float minDifference = Math.min(differCurrentMultiple, differPreviousMultiple);
                if (differPreviousMultiple == differCurrentMultiple) {
                    boolean bl2 = false;
                    float f4 = (float)Math.floor(value);
                    Object e = keys.get((int)current);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"keys[current]");
                    f3 = f4 + ((Number)e).floatValue();
                } else if (minDifference == differPreviousMultiple) {
                    boolean bl3 = false;
                    float f5 = (float)Math.floor(value);
                    Object e = keys.get(previous);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"keys[previous]");
                    f3 = f5 + ((Number)e).floatValue();
                } else {
                    boolean bl4 = false;
                    float f6 = (float)Math.floor(value);
                    Object e = keys.get((int)current);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"keys[current]");
                    f3 = f6 + ((Number)e).floatValue();
                }
                return f3;
            }
            previous = current++;
        }
        return value;
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        Integer n;
        if (!this.isEnabled()) {
            return false;
        }
        MotionEvent motionEvent = event;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
        int n3 = 0;
        if (n2 != null && n2 == 0) {
            if (this.isInScrollingContainer()) {
                this.mTouchDownX = event.getX();
            } else {
                this.startDrag(event);
            }
        } else {
            Integer n4 = n;
            n3 = 2;
            if (n4 != null && n4 == n3) {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                } else {
                    float x = event.getX();
                    if (Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop) {
                        this.startDrag(event);
                    }
                }
            } else {
                Integer n5 = n;
                n3 = 1;
                if (n5 != null && n5 == n3) {
                    if (this.mIsDragging) {
                        this.trackTouchEvent(event);
                        this.onStopTrackingTouch();
                        this.setPressed(false);
                    } else {
                        this.onStartTrackingTouch();
                        this.trackTouchEvent(event);
                        this.onStopTrackingTouch();
                    }
                } else {
                    Integer n6 = n;
                    n3 = 3;
                    if (n6 != null && n6 == n3 && this.mIsDragging) {
                        this.onStopTrackingTouch();
                        this.setPressed(false);
                    }
                }
            }
        }
        return true;
    }

    private final void startDrag(MotionEvent event) {
        this.setPressed(true);
        this.onStartTrackingTouch();
        this.trackTouchEvent(event);
    }

    private final boolean isInScrollingContainer() {
        ViewParent p = this.getParent();
        while (p != null && p instanceof ViewGroup) {
            if (((ViewGroup)p).shouldDelayChildPressedState()) {
                return true;
            }
            p = ((ViewGroup)p).getParent();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected final void trackTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int x = Math.round(event.getX());
        int n = 0;
        int n2 = this.getChildCount();
        if (n <= n2) {
            while (true) {
                View child;
                void i;
                if (this.getChildAt((int)i) == null) {
                    return;
                }
                if (x > child.getLeft() && x < child.getLeft() + child.getWidth()) {
                    int dragOnView = x - child.getLeft();
                    float ratioCross = (float)dragOnView / (float)child.getWidth();
                    this.setCurrentRating((float)i + ratioCross);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    private final void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addViews() {
        int n = 0;
        int n2 = this.maxRating;
        while (n < n2) {
            void i;
            this.addRatingViews((int)i);
            ++i;
        }
    }

    private final void addRatingViews(int pos) {
        ImageView imageView = this.getImageView(pos);
        this.addView((View)imageView);
    }

    private final ImageView getImageView(int pos) {
        ImageView imageView = new ImageView(this.getContext());
        LinearLayoutCompat.LayoutParams layoutParams = new LinearLayoutCompat.LayoutParams(0, -1, 1.0f);
        layoutParams.setMarginEnd(pos != this.maxRating - 1 ? (int)this.ratingSpace : 0);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setRatingResource(imageView, pos);
        return imageView;
    }

    private final void setRatingResource(ImageView imageView, int index) {
        Drawable drawable;
        int pos = index + 1;
        float f = this.currentRating;
        float f2 = pos;
        ImageView imageView2 = imageView;
        boolean bl = false;
        float f3 = (float)Math.floor(f);
        ImageView imageView3 = imageView2;
        if (f2 <= f3) {
            Object v = this.assetMap.get(Float.valueOf(1.0f));
            if (v == null) {
                Intrinsics.throwNpe();
            }
            drawable = (Drawable)v;
        } else {
            f = this.currentRating;
            int n = pos;
            imageView2 = imageView3;
            bl = false;
            f3 = (float)Math.ceil(f);
            imageView3 = imageView2;
            if (n == (int)f3) {
                float f4 = this.currentRating;
                float f5 = this.currentRating;
                imageView2 = imageView3;
                boolean bl2 = false;
                f3 = (float)Math.floor(f4);
                imageView3 = imageView2;
                float decimal = f5 - f3;
                Object v = this.assetMap.get(Float.valueOf(decimal));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                drawable = (Drawable)v;
            } else {
                Object v = this.assetMap.get(Float.valueOf(0.0f));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                drawable = (Drawable)v;
            }
        }
        imageView3.setImageDrawable(drawable);
    }

    private final SortedMap<Float, Drawable> convertToDrawableMap(Map<Float, Integer> map) {
        SortedMap sortedMap = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Map<Float, Integer> map2 = map;
        boolean bl = false;
        for (Map.Entry<Float, Integer> entry : map2.entrySet()) {
            Drawable drawable;
            if (ResourcesCompat.getDrawable((Resources)this.getResources(), (int)((Number)entry.getValue()).intValue(), null) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"ResourcesCompat.getDrawa\u2026ces, entry.value, null)!!");
            ((Map)sortedMap).put(entry.getKey(), drawable);
        }
        return sortedMap;
    }

    public final float getRating() {
        return this.currentRating;
    }

    public final void setRating(float rating) {
        this.setCurrentRating(rating);
    }

    public final void setDrawableAssetMap(@NotNull Map<Float, ? extends Drawable> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        this.assetMap = MapsKt.toSortedMap(map);
        this.refreshRatingView();
    }

    public final void setDrawableResourceAssetMap(@NotNull Map<Float, Integer> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        this.assetMap = this.convertToDrawableMap(map);
        this.refreshRatingView();
    }

    @JvmOverloads
    public DragRatingView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxRating = 5;
        this.assetMap = this.convertToDrawableMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Float.valueOf(0.0f), (Object)R.drawable.ic_star_empty), TuplesKt.to((Object)Float.valueOf(0.5f), (Object)R.drawable.ic_star_half), TuplesKt.to((Object)Float.valueOf(1.0f), (Object)R.drawable.ic_star_full)}));
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.DragRatingView, 0, 0);
            this.ratingSpace = typedArray.getDimension(R.styleable.DragRatingView_rating_space, 0.0f);
            this.maxRating = typedArray.getInt(R.styleable.DragRatingView_max_rating, 5);
            this.setCurrentRating(typedArray.getFloat(R.styleable.DragRatingView_initial_rating, 0.0f));
            typedArray.recycle();
        }
        this.setClickable(true);
        this.setFocusable(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.addViews();
    }

    @JvmOverloads
    public /* synthetic */ DragRatingView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public DragRatingView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DragRatingView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/github/saran2020/dragrating/DragRatingView$RatingChangeCallback;", "", "onRatingChanged", "", "previous", "", "current", "dragrating_release"})
    public static interface RatingChangeCallback {
        public void onRatingChanged(float var1, float var2);
    }
}

