/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.cram;

import htsjdk.beta.codecs.reads.ReadsCodecUtils;
import htsjdk.beta.codecs.reads.cram.CRAMCodec;
import htsjdk.beta.codecs.reads.cram.CRAMDecoderOptions;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsIntervalUtils;
import htsjdk.beta.plugin.interval.HtsQueryRule;
import htsjdk.beta.plugin.reads.ReadsDecoder;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class CRAMDecoder
implements ReadsDecoder {
    private final Bundle inputBundle;
    private final ReadsDecoderOptions readsDecoderOptions;
    private final String displayName;
    private final SAMFileHeader samFileHeader;
    private boolean iteratorExists = false;
    private final SamReader samReader;

    public CRAMDecoder(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        ValidationUtils.nonNull(inputBundle, "inputBundle");
        ValidationUtils.nonNull(readsDecoderOptions, "inputBundle");
        this.inputBundle = inputBundle;
        this.readsDecoderOptions = readsDecoderOptions;
        this.displayName = inputBundle.getOrThrow(BundleResourceType.ALIGNED_READS).getDisplayName();
        this.samReader = CRAMDecoder.getSamReaderForCRAM(inputBundle, readsDecoderOptions);
        this.samFileHeader = this.samReader.getFileHeader();
    }

    @Override
    public final String getFileFormat() {
        return "CRAM";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.samFileHeader;
    }

    @Override
    public void close() {
        try {
            this.samReader.close();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure closing CRAM reader stream", this.getDisplayName()), e);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return this.getIteratorMonitor(() -> this.samReader.iterator());
    }

    @Override
    public boolean isQueryable() {
        return ReadsCodecUtils.bundleContainsIndex(this.getInputBundle()) && this.samReader.isQueryable();
    }

    @Override
    public boolean hasIndex() {
        return ReadsCodecUtils.bundleContainsIndex(this.getInputBundle()) && this.samReader.hasIndex();
    }

    @Override
    public CloseableIterator<SAMRecord> query(List<HtsInterval> intervals, HtsQueryRule queryRule) {
        ValidationUtils.nonNull(intervals, "intervals");
        ValidationUtils.nonNull(queryRule, "queryRule");
        QueryInterval[] queryIntervals = HtsIntervalUtils.toQueryIntervalArray(intervals, this.samFileHeader.getSequenceDictionary());
        return this.getIteratorMonitor(() -> this.samReader.query(queryIntervals, queryRule == HtsQueryRule.CONTAINED));
    }

    @Override
    public CloseableIterator<SAMRecord> queryStart(String queryName, long start) {
        ValidationUtils.nonNull(queryName, "queryName");
        return this.getIteratorMonitor(() -> this.samReader.queryAlignmentStart(queryName, HtsIntervalUtils.toIntegerSafe(start)));
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        return this.getIteratorMonitor(() -> this.samReader.queryUnmapped());
    }

    @Override
    public Optional<SAMRecord> queryMate(SAMRecord rec) {
        ValidationUtils.nonNull(rec, "rec");
        if (!rec.getReadPairedFlag()) {
            throw new IllegalArgumentException(String.format("queryMate called for unpaired read on %s.", this.getDisplayName()));
        }
        if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
            throw new IllegalArgumentException(String.format("SAMRecord must be either first and second of pair, but not both (%s).", this.getDisplayName()));
        }
        boolean firstOfPair = rec.getFirstOfPairFlag();
        try (CloseableIterator<SAMRecord> it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());){
            SAMRecord mateRec = null;
            while (it.hasNext()) {
                SAMRecord next = (SAMRecord)it.next();
                if (!next.getReadPairedFlag()) {
                    if (!rec.getReadName().equals(next.getReadName())) continue;
                    throw new SAMFormatException(String.format("Paired and unpaired reads with same name: %s (on %s)", rec.getReadName(), this.getInputBundle()));
                }
                if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                if (mateRec != null) {
                    throw new SAMFormatException(String.format("Multiple SAMRecord with read name %s for %s end on %s.", rec.getReadName(), firstOfPair ? "second" : "first", this.getInputBundle()));
                }
                mateRec = next;
            }
            Optional<Object> optional = Optional.ofNullable(mateRec);
            return optional;
        }
    }

    public Bundle getInputBundle() {
        return this.inputBundle;
    }

    public ReadsDecoderOptions getReadsDecoderOptions() {
        return this.readsDecoderOptions;
    }

    public static CRAMReferenceSource getCRAMReferenceSource(CRAMDecoderOptions cramDecoderOptions) {
        ValidationUtils.nonNull(cramDecoderOptions, "cramDecoderOptions");
        if (cramDecoderOptions.getReferenceSource().isPresent()) {
            return cramDecoderOptions.getReferenceSource().get();
        }
        if (cramDecoderOptions.getReferencePath().isPresent()) {
            return CRAMCodec.getCRAMReferenceSource(cramDecoderOptions.getReferencePath().get());
        }
        return ReferenceSource.getDefaultCRAMReferenceSource();
    }

    private CloseableIterator<SAMRecord> getIteratorMonitor(Supplier<CloseableIterator<SAMRecord>> newIterator) {
        this.toggleIteratorExists(true);
        return new CloseableIteratorMonitor<SAMRecord>(newIterator.get());
    }

    private void toggleIteratorExists(boolean newState) {
        if (this.iteratorExists == newState) {
            if (this.iteratorExists) {
                throw new IllegalStateException(String.format("The previous iterator must be closed before starting a new iterator on %s", this.getDisplayName()));
            }
            throw new IllegalStateException(String.format("No outstanding iterator exists for %s", this.getDisplayName()));
        }
        this.iteratorExists = newState;
    }

    private static SamReader getSamReaderForCRAM(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        SamInputResource samInputResource = ReadsCodecUtils.bundleToSamInputResource(inputBundle, readsDecoderOptions);
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault();
        ReadsCodecUtils.readsDecoderOptionsToSamReaderFactory(readsDecoderOptions, samReaderFactory);
        CRAMDecoder.cramDecoderOptionsToSamReaderFactory(samReaderFactory, readsDecoderOptions.getCRAMDecoderOptions());
        return samReaderFactory.open(samInputResource);
    }

    private static void cramDecoderOptionsToSamReaderFactory(SamReaderFactory samReaderFactory, CRAMDecoderOptions cramDecoderOptions) {
        samReaderFactory.referenceSource(CRAMDecoder.getCRAMReferenceSource(cramDecoderOptions));
    }

    private class CloseableIteratorMonitor<T>
    implements CloseableIterator<T> {
        final CloseableIterator<T> wrappedIterator;

        public CloseableIteratorMonitor(CloseableIterator<T> wrappedIterator) {
            ValidationUtils.nonNull(wrappedIterator, "wrappedIterator");
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public void close() {
            CRAMDecoder.this.toggleIteratorExists(false);
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.wrappedIterator.next();
        }
    }
}

