/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class VCFHeader
implements Serializable {
    public static final long serialVersionUID = 1L;
    private VCFHeaderVersion vcfHeaderVersion;
    private final Set<VCFHeaderLine> mMetaData = new LinkedHashSet<VCFHeaderLine>();
    private final Map<String, VCFInfoHeaderLine> mInfoMetaData = new LinkedHashMap<String, VCFInfoHeaderLine>();
    private final Map<String, VCFFormatHeaderLine> mFormatMetaData = new LinkedHashMap<String, VCFFormatHeaderLine>();
    private final Map<String, VCFFilterHeaderLine> mFilterMetaData = new LinkedHashMap<String, VCFFilterHeaderLine>();
    private final Map<String, VCFHeaderLine> mOtherMetaData = new LinkedHashMap<String, VCFHeaderLine>();
    private final Map<String, VCFContigHeaderLine> contigMetaData = new LinkedHashMap<String, VCFContigHeaderLine>();
    private final List<String> mGenotypeSampleNames = new ArrayList<String>();
    public static final String METADATA_INDICATOR = "##";
    public static final String HEADER_INDICATOR = "#";
    public static final String SOURCE_KEY = "source";
    public static final String REFERENCE_KEY = "reference";
    public static final String CONTIG_KEY = "contig";
    public static final String INTERVALS_KEY = "intervals";
    public static final String EXCLUDE_INTERVALS_KEY = "excludeIntervals";
    public static final String INTERVAL_MERGING_KEY = "interval_merging";
    public static final String INTERVAL_SET_RULE_KEY = "interval_set_rule";
    public static final String INTERVAL_PADDING_KEY = "interval_padding";
    private boolean samplesWereAlreadySorted = true;
    private ArrayList<String> sampleNamesInOrder = null;
    private HashMap<String, Integer> sampleNameToOffset = null;
    private boolean writeEngineHeaders = true;
    private boolean writeCommandLine = true;

    public VCFHeader() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public VCFHeader(Set<VCFHeaderLine> metaData) {
        this.mMetaData.addAll(metaData);
        this.removeVCFVersionLines(this.mMetaData);
        this.createLookupEntriesForAllHeaderLines();
        this.checkForDeprecatedGenotypeLikelihoodsKey();
    }

    public VCFHeader(VCFHeader toCopy) {
        this(toCopy.mMetaData, toCopy.mGenotypeSampleNames);
    }

    public VCFHeader(Set<VCFHeaderLine> metaData, Set<String> genotypeSampleNames) {
        this(metaData, new ArrayList<String>(genotypeSampleNames));
    }

    public VCFHeader(VCFHeaderVersion vcfHeaderVersion, Set<VCFHeaderLine> metaData, Set<String> genotypeSampleNames) {
        this(metaData, new ArrayList<String>(genotypeSampleNames));
        ValidationUtils.nonNull(vcfHeaderVersion);
        this.setVCFHeaderVersion(vcfHeaderVersion);
    }

    public VCFHeader(Set<VCFHeaderLine> metaData, List<String> genotypeSampleNames) {
        this(metaData);
        if (genotypeSampleNames.size() != new HashSet<String>(genotypeSampleNames).size()) {
            throw new TribbleException.InvalidHeader("BUG: VCF header has duplicate sample names");
        }
        this.mGenotypeSampleNames.addAll(genotypeSampleNames);
        this.samplesWereAlreadySorted = ParsingUtils.isSorted(genotypeSampleNames);
        this.buildVCFReaderMaps(genotypeSampleNames);
    }

    public void setVCFHeaderVersion(VCFHeaderVersion vcfHeaderVersion) {
        VCFHeader.validateVersionTransition(this.vcfHeaderVersion, vcfHeaderVersion);
        this.vcfHeaderVersion = vcfHeaderVersion;
    }

    public static void validateVersionTransition(VCFHeaderVersion fromVersion, VCFHeaderVersion toVersion) {
        ValidationUtils.nonNull(toVersion);
        String errorMessageFormatString = "VCF cannot be automatically promoted from %s to %s";
        if (fromVersion != null && (toVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_3) ? !fromVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_3) : fromVersion.equals((Object)VCFHeaderVersion.VCF4_3))) {
            throw new TribbleException(String.format("VCF cannot be automatically promoted from %s to %s", new Object[]{fromVersion, toVersion}));
        }
    }

    public VCFHeaderVersion getVCFHeaderVersion() {
        return this.vcfHeaderVersion;
    }

    private void buildVCFReaderMaps(Collection<String> genotypeSampleNamesInAppearenceOrder) {
        this.sampleNamesInOrder = new ArrayList(genotypeSampleNamesInAppearenceOrder.size());
        this.sampleNameToOffset = new HashMap(genotypeSampleNamesInAppearenceOrder.size());
        int i = 0;
        for (String name : genotypeSampleNamesInAppearenceOrder) {
            this.sampleNamesInOrder.add(name);
            this.sampleNameToOffset.put(name, i++);
        }
        Collections.sort(this.sampleNamesInOrder);
    }

    public void addMetaDataLine(VCFHeaderLine headerLine) {
        if (this.addMetadataLineLookupEntry(headerLine)) {
            this.mMetaData.add(headerLine);
            this.checkForDeprecatedGenotypeLikelihoodsKey();
        }
    }

    public List<VCFContigHeaderLine> getContigLines() {
        return Collections.unmodifiableList(new ArrayList<VCFContigHeaderLine>(this.contigMetaData.values()));
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        List<VCFContigHeaderLine> contigHeaderLines = this.getContigLines();
        if (contigHeaderLines.isEmpty()) {
            return null;
        }
        ArrayList<SAMSequenceRecord> sequenceRecords = new ArrayList<SAMSequenceRecord>(contigHeaderLines.size());
        for (VCFContigHeaderLine contigHeaderLine : contigHeaderLines) {
            sequenceRecords.add(contigHeaderLine.getSAMSequenceRecord());
        }
        return new SAMSequenceDictionary(sequenceRecords);
    }

    public void setSequenceDictionary(SAMSequenceDictionary dictionary) {
        this.contigMetaData.clear();
        ArrayList<VCFHeaderLine> toRemove = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!(line instanceof VCFContigHeaderLine)) continue;
            toRemove.add(line);
        }
        this.mMetaData.removeAll(toRemove);
        for (SAMSequenceRecord record : dictionary.getSequences()) {
            this.addMetaDataLine(new VCFContigHeaderLine(record, record.getAssembly()));
        }
    }

    public VariantContextComparator getVCFRecordComparator() {
        return new VariantContextComparator((Collection<VCFContigHeaderLine>)this.getContigLines());
    }

    public List<VCFFilterHeaderLine> getFilterLines() {
        ArrayList<VCFFilterHeaderLine> filters = new ArrayList<VCFFilterHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!(line instanceof VCFFilterHeaderLine)) continue;
            filters.add((VCFFilterHeaderLine)line);
        }
        return filters;
    }

    public List<VCFIDHeaderLine> getIDHeaderLines() {
        ArrayList<VCFIDHeaderLine> lines = new ArrayList<VCFIDHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!(line instanceof VCFIDHeaderLine)) continue;
            lines.add((VCFIDHeaderLine)((Object)line));
        }
        return lines;
    }

    private void removeVCFVersionLines(Set<VCFHeaderLine> headerLines) {
        ArrayList<VCFHeaderLine> toRemove = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine line : headerLines) {
            if (!VCFHeaderVersion.isFormatString(line.getKey())) continue;
            toRemove.add(line);
        }
        headerLines.removeAll(toRemove);
    }

    private void createLookupEntriesForAllHeaderLines() {
        for (VCFHeaderLine line : this.mMetaData) {
            this.addMetadataLineLookupEntry(line);
        }
    }

    private boolean addMetadataLineLookupEntry(VCFHeaderLine line) {
        if (line instanceof VCFInfoHeaderLine) {
            VCFInfoHeaderLine infoLine = (VCFInfoHeaderLine)line;
            return this.addMetaDataLineMapLookupEntry(this.mInfoMetaData, infoLine.getID(), infoLine);
        }
        if (line instanceof VCFFormatHeaderLine) {
            VCFFormatHeaderLine formatLine = (VCFFormatHeaderLine)line;
            return this.addMetaDataLineMapLookupEntry(this.mFormatMetaData, formatLine.getID(), formatLine);
        }
        if (line instanceof VCFFilterHeaderLine) {
            VCFFilterHeaderLine filterLine = (VCFFilterHeaderLine)line;
            return this.addMetaDataLineMapLookupEntry(this.mFilterMetaData, filterLine.getID(), filterLine);
        }
        if (line instanceof VCFContigHeaderLine) {
            return this.addContigMetaDataLineLookupEntry((VCFContigHeaderLine)line);
        }
        return this.addMetaDataLineMapLookupEntry(this.mOtherMetaData, line.getKey(), line);
    }

    private boolean addContigMetaDataLineLookupEntry(VCFContigHeaderLine line) {
        if (this.contigMetaData.containsKey(line.getID())) {
            return false;
        }
        this.contigMetaData.put(line.getID(), line);
        return true;
    }

    private <T extends VCFHeaderLine> boolean addMetaDataLineMapLookupEntry(Map<String, T> map, String key, T line) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, line);
        return true;
    }

    private void checkForDeprecatedGenotypeLikelihoodsKey() {
        if (this.hasFormatLine("GL") && !this.hasFormatLine("PL")) {
            this.addMetaDataLine(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        }
    }

    public Set<HEADER_FIELDS> getHeaderFields() {
        return new LinkedHashSet<HEADER_FIELDS>(Arrays.asList(HEADER_FIELDS.values()));
    }

    public Set<VCFHeaderLine> getMetaDataInInputOrder() {
        return this.makeGetMetaDataSet(this.mMetaData);
    }

    public Set<VCFHeaderLine> getMetaDataInSortedOrder() {
        return this.makeGetMetaDataSet(new TreeSet<VCFHeaderLine>(this.mMetaData));
    }

    private Set<VCFHeaderLine> makeGetMetaDataSet(Set<VCFHeaderLine> headerLinesInSomeOrder) {
        LinkedHashSet<VCFHeaderLine> lines = new LinkedHashSet<VCFHeaderLine>();
        if (this.vcfHeaderVersion != null && this.vcfHeaderVersion.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_3)) {
            lines.add(new VCFHeaderLine(VCFHeaderVersion.VCF4_3.getFormatString(), VCFHeaderVersion.VCF4_3.getVersionString()));
        } else {
            lines.add(new VCFHeaderLine(VCFHeaderVersion.VCF4_2.getFormatString(), VCFHeaderVersion.VCF4_2.getVersionString()));
        }
        lines.addAll(headerLinesInSomeOrder);
        return Collections.unmodifiableSet(lines);
    }

    public VCFHeaderLine getMetaDataLine(String key) {
        for (VCFHeaderLine line : this.mMetaData) {
            if (!line.getKey().equals(key)) continue;
            return line;
        }
        return null;
    }

    public List<String> getGenotypeSamples() {
        return this.mGenotypeSampleNames;
    }

    public int getNGenotypeSamples() {
        return this.mGenotypeSampleNames.size();
    }

    public boolean hasGenotypingData() {
        return this.getNGenotypeSamples() > 0;
    }

    public boolean samplesWereAlreadySorted() {
        return this.samplesWereAlreadySorted;
    }

    public int getColumnCount() {
        return HEADER_FIELDS.values().length + (this.hasGenotypingData() ? this.mGenotypeSampleNames.size() + 1 : 0);
    }

    public Collection<VCFInfoHeaderLine> getInfoHeaderLines() {
        return this.mInfoMetaData.values();
    }

    public Collection<VCFFormatHeaderLine> getFormatHeaderLines() {
        return this.mFormatMetaData.values();
    }

    public VCFInfoHeaderLine getInfoHeaderLine(String id) {
        return this.mInfoMetaData.get(id);
    }

    public VCFFormatHeaderLine getFormatHeaderLine(String id) {
        return this.mFormatMetaData.get(id);
    }

    public VCFFilterHeaderLine getFilterHeaderLine(String id) {
        return this.mFilterMetaData.get(id);
    }

    public boolean hasInfoLine(String id) {
        return this.getInfoHeaderLine(id) != null;
    }

    public boolean hasFormatLine(String id) {
        return this.getFormatHeaderLine(id) != null;
    }

    public boolean hasFilterLine(String id) {
        return this.getFilterHeaderLine(id) != null;
    }

    public VCFHeaderLine getOtherHeaderLine(String key) {
        return this.mOtherMetaData.get(key);
    }

    public Collection<VCFHeaderLine> getOtherHeaderLines() {
        return this.mOtherMetaData.values();
    }

    public boolean isWriteEngineHeaders() {
        return this.writeEngineHeaders;
    }

    public void setWriteEngineHeaders(boolean writeEngineHeaders) {
        this.writeEngineHeaders = writeEngineHeaders;
    }

    public boolean isWriteCommandLine() {
        return this.writeCommandLine;
    }

    public void setWriteCommandLine(boolean writeCommandLine) {
        this.writeCommandLine = writeCommandLine;
    }

    public ArrayList<String> getSampleNamesInOrder() {
        return this.sampleNamesInOrder;
    }

    public HashMap<String, Integer> getSampleNameToOffset() {
        return this.sampleNameToOffset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[VCFHeader:");
        for (VCFHeaderLine line : this.mMetaData) {
            b.append("\n\t").append(line);
        }
        return b.append("\n]").toString();
    }

    public static enum HEADER_FIELDS {
        CHROM,
        POS,
        ID,
        REF,
        ALT,
        QUAL,
        FILTER,
        INFO;

    }
}

