/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.writer.AsyncVariantContextWriter;
import htsjdk.variant.variantcontext.writer.BCF2Writer;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;

public class VariantContextWriterBuilder {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);
    private static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    private static final Log log = Log.getInstance(VariantContextWriter.class);
    public static final EnumSet<OutputType> FILE_TYPES = EnumSet.of(OutputType.VCF, OutputType.BCF, OutputType.BLOCK_COMPRESSED_VCF);
    public static final EnumSet<OutputType> STREAM_TYPES = EnumSet.of(OutputType.VCF_STREAM, OutputType.BCF_STREAM);
    private SAMSequenceDictionary refDict = null;
    private OutputType outType = OutputType.UNSPECIFIED;
    private Path outPath = null;
    private OutputStream outStream = null;
    private IndexCreator idxCreator = null;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private boolean createMD5 = Defaults.CREATE_MD5;
    protected EnumSet<Options> options = DEFAULT_OPTIONS.clone();

    public VariantContextWriterBuilder() {
        if (Defaults.USE_ASYNC_IO_WRITE_FOR_TRIBBLE) {
            this.options.add(Options.USE_ASYNC_IO);
        }
    }

    public VariantContextWriterBuilder setReferenceDictionary(SAMSequenceDictionary refDict) {
        this.refDict = refDict;
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(File outFile) {
        return this.setOutputPath(IOUtil.toPath(outFile));
    }

    public VariantContextWriterBuilder setOutputPath(Path outPath) {
        this.outPath = outPath;
        this.outStream = null;
        this.outType = VariantContextWriterBuilder.determineOutputTypeFromFile(outPath);
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(String outFile) {
        return this.setOutputFile(new File(outFile));
    }

    public VariantContextWriterBuilder setOutputFileType(OutputType outType) {
        if (!FILE_TYPES.contains((Object)outType)) {
            throw new IllegalArgumentException("Must choose a file type, not other output types.");
        }
        if (this.outPath == null || this.outStream != null) {
            throw new IllegalArgumentException("Cannot set a file type if the output is not to a file.");
        }
        this.outType = outType;
        return this;
    }

    public VariantContextWriterBuilder setOutputVCFStream(OutputStream outStream) {
        this.outStream = outStream;
        this.outPath = null;
        this.outType = OutputType.VCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputBCFStream(OutputStream outStream) {
        this.outStream = outStream;
        this.outPath = null;
        this.outType = OutputType.BCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputStream(OutputStream outStream) {
        return this.setOutputVCFStream(outStream);
    }

    public VariantContextWriterBuilder setIndexCreator(IndexCreator idxCreator) {
        this.idxCreator = idxCreator;
        return this;
    }

    public VariantContextWriterBuilder clearIndexCreator() {
        this.idxCreator = null;
        return this;
    }

    public VariantContextWriterBuilder setBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public VariantContextWriterBuilder unsetBuffering() {
        this.bufferSize = 0;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5(boolean createMD5) {
        this.createMD5 = createMD5;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5() {
        return this.setCreateMD5(true);
    }

    public VariantContextWriterBuilder unsetCreateMD5() {
        return this.setCreateMD5(false);
    }

    public VariantContextWriterBuilder setOptions(EnumSet<Options> options) {
        this.options = options;
        return this;
    }

    public VariantContextWriterBuilder setOption(Options option) {
        this.options.add(option);
        return this;
    }

    public VariantContextWriterBuilder unsetOption(Options option) {
        this.options.remove((Object)option);
        return this;
    }

    public VariantContextWriterBuilder modifyOption(Options option, boolean setIt) {
        return setIt ? this.setOption(option) : this.unsetOption(option);
    }

    public static void setDefaultOption(Options option) {
        DEFAULT_OPTIONS.add(option);
    }

    public static void unsetDefaultOption(Options option) {
        DEFAULT_OPTIONS.remove((Object)option);
    }

    public VariantContextWriterBuilder clearOptions() {
        this.options = NO_OPTIONS.clone();
        return this;
    }

    boolean isOptionSet(Options option) {
        return this.options.contains((Object)option);
    }

    public VariantContextWriter build() {
        return this.build(EMPTY_OPEN_OPTION_ARRAY);
    }

    public VariantContextWriter build(OpenOption ... openOptions) {
        VariantContextWriter writer = null;
        OutputType typeToBuild = this.outType;
        if (this.options.contains((Object)Options.FORCE_BCF)) {
            if (FILE_TYPES.contains((Object)this.outType)) {
                typeToBuild = OutputType.BCF;
            } else if (STREAM_TYPES.contains((Object)this.outType)) {
                typeToBuild = OutputType.BCF_STREAM;
            }
        }
        OutputStream outStreamFromFile = this.outStream;
        if (FILE_TYPES.contains((Object)this.outType) || STREAM_TYPES.contains((Object)this.outType) && this.outStream == null) {
            try {
                outStreamFromFile = IOUtil.maybeBufferOutputStream(Files.newOutputStream(this.outPath, openOptions), this.bufferSize);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException("File not found: " + this.outPath, e);
            }
            catch (IOException e) {
                throw new RuntimeIOException("File not found: " + this.outPath, e);
            }
            if (this.createMD5) {
                outStreamFromFile = new Md5CalculatingOutputStream(outStreamFromFile, IOUtil.addExtension(this.outPath, ".md5"));
            }
        }
        switch (typeToBuild) {
            case UNSPECIFIED: {
                throw new IllegalArgumentException("Output format type is not set, or could not be inferred from the output path. If a path was used, does it have a valid VCF extension (" + String.join((CharSequence)", ", FileExtensions.VCF_LIST) + ")?");
            }
            case VCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                writer = this.createVCFWriter(this.outPath, outStreamFromFile);
                break;
            }
            case BLOCK_COMPRESSED_VCF: {
                this.idxCreator = this.refDict == null ? new TabixIndexCreator(TabixFormat.VCF) : new TabixIndexCreator(this.refDict, TabixFormat.VCF);
                writer = this.createVCFWriter(this.outPath, new BlockCompressedOutputStream(outStreamFromFile, this.outPath));
                break;
            }
            case BCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                writer = this.createBCFWriter(this.outPath, outStreamFromFile);
                break;
            }
            case VCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    log.warn("VCF index creation not supported for stream output, index will not be created");
                    this.options.remove((Object)Options.INDEX_ON_THE_FLY);
                }
                writer = this.createVCFWriter(null, outStreamFromFile);
                break;
            }
            case BCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    log.warn("BCF index creation not supported for stream output, index will not be created");
                    this.options.remove((Object)Options.INDEX_ON_THE_FLY);
                }
                writer = this.createBCFWriter(null, this.outStream);
            }
        }
        if (this.options.contains((Object)Options.USE_ASYNC_IO)) {
            writer = new AsyncVariantContextWriter(writer, 2000);
        }
        return writer;
    }

    public static OutputType determineOutputTypeFromFile(File file) {
        return VariantContextWriterBuilder.determineOutputTypeFromFile(file.toPath());
    }

    public static OutputType determineOutputTypeFromFile(Path path) {
        if (VariantContextWriterBuilder.isBCF(path)) {
            return OutputType.BCF;
        }
        if (VariantContextWriterBuilder.isCompressedVCF(path)) {
            return OutputType.BLOCK_COMPRESSED_VCF;
        }
        if (VariantContextWriterBuilder.isVCF(path)) {
            return OutputType.VCF;
        }
        try {
            Path canonicalPath = path.toRealPath(new LinkOption[0]);
            if (!canonicalPath.equals(path)) {
                return VariantContextWriterBuilder.determineOutputTypeFromFile(canonicalPath);
            }
        }
        catch (NoSuchFileException canonicalPath) {
        }
        catch (IOException x) {
            throw new RuntimeIOException(x);
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            return OutputType.VCF_STREAM;
        }
        return OutputType.UNSPECIFIED;
    }

    private static boolean isVCF(Path outPath) {
        return outPath != null && outPath.getFileName().toString().endsWith(".vcf");
    }

    private static boolean isBCF(Path outPath) {
        return outPath != null && outPath.getFileName().toString().endsWith(".bcf");
    }

    private static boolean isCompressedVCF(Path outPath) {
        if (outPath == null) {
            return false;
        }
        return IOUtil.hasBlockCompressedExtension(outPath);
    }

    private VariantContextWriter createVCFWriter(Path writerPath, OutputStream writerStream) {
        if (this.idxCreator == null) {
            return new VCFWriter(writerPath, writerStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
        }
        return new VCFWriter(writerPath, writerStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
    }

    private VariantContextWriter createBCFWriter(Path writerPath, OutputStream writerStream) {
        if (this.idxCreator == null) {
            return new BCF2Writer(writerPath, writerStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
        }
        return new BCF2Writer(writerPath, writerStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
    }

    public static enum OutputType {
        UNSPECIFIED,
        VCF,
        BCF,
        BLOCK_COMPRESSED_VCF,
        VCF_STREAM,
        BCF_STREAM;

    }
}

