/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class DataSeriesReader<T> {
    private final CRAMCodec<T> codec;

    public DataSeriesReader(DataSeriesType valueType, EncodingParams params, BitInputStream bitInputStream, Map<Integer, ByteArrayInputStream> inputMap) {
        CRAMEncoding encoding = EncodingFactory.createEncoding(valueType, params.id, params.params);
        this.codec = encoding.buildReadCodec(bitInputStream, inputMap);
    }

    T readData() {
        return this.codec.read();
    }

    T readDataArray(int length) {
        return this.codec.read(length);
    }
}

