/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import com.saasquatch.jsonschemainferrer.PrimitivesSummary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class PrimitivesSummaryMap
extends HashMap<Map.Entry<String, String>, PrimitivesSummary> {
    public void addSample(@Nonnull String type, @Nullable String format, @Nonnull JsonNode sample) {
        Map.Entry<String, String> key = PrimitivesSummaryMap.newKey(type, format);
        this.compute(key, (_key, primitivesSummary) -> {
            if (primitivesSummary == null) {
                primitivesSummary = new PrimitivesSummary();
            }
            primitivesSummary.addSample(sample);
            return primitivesSummary;
        });
    }

    @Nullable
    public PrimitivesSummary getPrimitivesSummary(@Nonnull String type, @Nullable String format) {
        return (PrimitivesSummary)this.get(PrimitivesSummaryMap.newKey(type, format));
    }

    private static Map.Entry<String, String> newKey(@Nonnull String type, @Nullable String format) {
        return JunkDrawer.entryOf(Objects.requireNonNull(type), format);
    }
}

