/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.saasquatch.jsonschemainferrer.Consts;
import com.saasquatch.jsonschemainferrer.EnumExtractor;
import com.saasquatch.jsonschemainferrer.EnumExtractorInput;
import com.saasquatch.jsonschemainferrer.FormatInferrer;
import com.saasquatch.jsonschemainferrer.FormatInferrerInput;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatureInput;
import com.saasquatch.jsonschemainferrer.IntegerTypeCriterion;
import com.saasquatch.jsonschemainferrer.IntegerTypeCriterionInput;
import com.saasquatch.jsonschemainferrer.IntegerTypePreference;
import com.saasquatch.jsonschemainferrer.JsonSchemaInferrerBuilder;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import com.saasquatch.jsonschemainferrer.PrimitivesSummary;
import com.saasquatch.jsonschemainferrer.PrimitivesSummaryMap;
import com.saasquatch.jsonschemainferrer.SpecVersion;
import com.saasquatch.jsonschemainferrer.TitleDescriptionGenerator;
import com.saasquatch.jsonschemainferrer.TitleDescriptionGeneratorInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonSchemaInferrer {
    private final SpecVersion specVersion;
    private final IntegerTypePreference integerTypePreference;
    private final IntegerTypeCriterion integerTypeCriterion;
    private final EnumExtractor enumExtractor;
    private final TitleDescriptionGenerator titleDescriptionGenerator;
    private final FormatInferrer formatInferrer;
    private final GenericSchemaFeature genericSchemaFeature;

    JsonSchemaInferrer(@Nonnull SpecVersion specVersion, @Nonnull IntegerTypePreference integerTypePreference, @Nonnull IntegerTypeCriterion integerTypeCriterion, @Nonnull EnumExtractor enumExtractor, @Nonnull TitleDescriptionGenerator titleDescriptionGenerator, @Nonnull FormatInferrer formatInferrer, @Nonnull GenericSchemaFeature genericSchemaFeature) {
        this.specVersion = specVersion;
        this.integerTypePreference = integerTypePreference;
        this.integerTypeCriterion = integerTypeCriterion;
        this.enumExtractor = enumExtractor;
        this.titleDescriptionGenerator = titleDescriptionGenerator;
        this.formatInferrer = formatInferrer;
        this.genericSchemaFeature = genericSchemaFeature;
    }

    @Nonnull
    public static JsonSchemaInferrerBuilder newBuilder() {
        return new JsonSchemaInferrerBuilder();
    }

    @Nonnull
    public ObjectNode inferForSample(@Nullable JsonNode sample) {
        return this.inferForSamples(Collections.singleton(sample));
    }

    @Nonnull
    public ObjectNode inferForSamples(@Nonnull Collection<? extends JsonNode> samples) {
        if (samples.isEmpty()) {
            throw new IllegalArgumentException("Unable to process empty samples");
        }
        Collection processedSamples = samples.stream().map(this::preProcessSample).collect(Collectors.toList());
        ObjectNode schema = JunkDrawer.newObject();
        schema.put("$schema", this.specVersion.getMetaSchemaUrl());
        Set<ObjectNode> anyOfs = this.getAnyOfsFromSamples(processedSamples, "$");
        switch (anyOfs.size()) {
            case 0: {
                throw new AssertionError((Object)"empty anyOfs encountered in inferForSamples");
            }
            case 1: {
                schema.setAll(anyOfs.iterator().next());
                break;
            }
            default: {
                schema.set("anyOf", (JsonNode)JunkDrawer.newArray(anyOfs));
                this.processGenericSchemaFeature(schema, processedSamples, null, "$");
            }
        }
        return schema;
    }

    @Nonnull
    private JsonNode preProcessSample(@Nullable JsonNode sample) {
        if (sample == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (sample.isPojo()) {
            throw new IllegalArgumentException(sample.getClass().getSimpleName() + " not supported");
        }
        if (JunkDrawer.isNull(sample)) {
            return JsonNodeFactory.instance.nullNode();
        }
        return sample;
    }

    @Nullable
    private ObjectNode processObjects(@Nonnull Collection<ObjectNode> objectNodes, @Nonnull String path) {
        if (objectNodes.isEmpty()) {
            return null;
        }
        Set<String> allFieldNames = JunkDrawer.getAllFieldNames(objectNodes);
        ObjectNode properties = JunkDrawer.newObject();
        for (String fieldName : allFieldNames) {
            Collection processedSamples = JunkDrawer.getAllValuesForFieldName(objectNodes, fieldName).map(this::preProcessSample).collect(Collectors.toList());
            ObjectNode newProperty = JunkDrawer.newObject();
            this.handleDescriptionGeneration(newProperty, fieldName);
            String objectPath = JunkDrawer.appendObjectJsonPath(path, fieldName);
            Set<ObjectNode> anyOfs = this.getAnyOfsFromSamples(processedSamples, objectPath);
            switch (anyOfs.size()) {
                case 0: {
                    throw new AssertionError((Object)"empty anyOfs encountered");
                }
                case 1: {
                    newProperty.setAll(anyOfs.iterator().next());
                    break;
                }
                default: {
                    newProperty.set("anyOf", (JsonNode)JunkDrawer.newArray(anyOfs));
                    this.processGenericSchemaFeature(newProperty, processedSamples, null, objectPath);
                }
            }
            properties.set(fieldName, (JsonNode)newProperty);
        }
        ObjectNode schema = JunkDrawer.newObject().put("type", "object");
        if (!properties.isEmpty()) {
            schema.set("properties", (JsonNode)properties);
        }
        this.processGenericSchemaFeature(schema, objectNodes, "object", path);
        return schema;
    }

    @Nullable
    private ObjectNode processArrays(@Nonnull Collection<ArrayNode> arrayNodes, @Nonnull String path) {
        ObjectNode items;
        if (arrayNodes.isEmpty()) {
            return null;
        }
        Collection processedSamples = arrayNodes.stream().flatMap(JunkDrawer::stream).map(this::preProcessSample).collect(Collectors.toList());
        String arrayPath = JunkDrawer.appendArrayStarJsonPath(path);
        Set<ObjectNode> anyOfs = this.getAnyOfsFromSamples(processedSamples, arrayPath);
        switch (anyOfs.size()) {
            case 0: {
                items = JunkDrawer.newObject();
                break;
            }
            case 1: {
                items = anyOfs.iterator().next();
                break;
            }
            default: {
                items = JunkDrawer.newObject();
                items.set("anyOf", (JsonNode)JunkDrawer.newArray(anyOfs));
            }
        }
        ObjectNode schema = JunkDrawer.newObject().put("type", "array");
        if (!items.isEmpty()) {
            schema.set("items", (JsonNode)items);
        }
        this.processGenericSchemaFeature(schema, arrayNodes, "array", path);
        return schema;
    }

    @Nonnull
    private Set<ObjectNode> processPrimitives(@Nonnull Collection<ValueNode> valueNodes, @Nonnull String path) {
        if (valueNodes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectNode> anyOfs = new HashSet<ObjectNode>();
        boolean allNumbersAreIntegers = valueNodes.stream().filter(JsonNode::isNumber).allMatch(this::isInteger);
        PrimitivesSummaryMap primitivesSummaryMap = new PrimitivesSummaryMap();
        for (ValueNode valueNode : valueNodes) {
            ObjectNode newAnyOf = JunkDrawer.newObject();
            String type = this.inferPrimitiveType((JsonNode)valueNode, allNumbersAreIntegers);
            newAnyOf.put("type", type);
            String format = this.inferFormat((JsonNode)valueNode, path);
            if (format != null) {
                newAnyOf.put("format", format);
            }
            primitivesSummaryMap.addSample(type, format, (JsonNode)valueNode);
            anyOfs.add(newAnyOf);
        }
        for (ObjectNode anyOf : anyOfs) {
            String type = anyOf.path("type").textValue();
            String format = anyOf.path("format").textValue();
            PrimitivesSummary primitivesSummary = Objects.requireNonNull(primitivesSummaryMap.getPrimitivesSummary(type, format));
            this.processGenericSchemaFeature(anyOf, primitivesSummary.getSamples(), type, path);
        }
        return anyOfs;
    }

    @Nonnull
    private ObjectNode enumExtractionResultToSchema(@Nonnull Collection<? extends JsonNode> enumExtractionResult, @Nonnull String path) {
        Objects.requireNonNull(enumExtractionResult);
        if (enumExtractionResult.isEmpty()) {
            throw new IllegalStateException("Empty enum group encountered");
        }
        ArrayNode enumArray = JunkDrawer.newArray();
        enumExtractionResult.stream().distinct().forEach(arg_0 -> ((ArrayNode)enumArray).add(arg_0));
        ObjectNode schema = JunkDrawer.newObject();
        schema.set("enum", (JsonNode)enumArray);
        this.processGenericSchemaFeature(schema, enumExtractionResult, null, path);
        return schema;
    }

    @Nonnull
    private Set<ObjectNode> getAnyOfsFromSamples(@Nonnull Collection<? extends JsonNode> processedSamples, @Nonnull String path) {
        Collection<Collection<? extends JsonNode>> enumExtractionResults = this.getEnumExtractionResults(processedSamples, path);
        ArrayList<ObjectNode> objectNodes = new ArrayList<ObjectNode>();
        ArrayList<ArrayNode> arrayNodes = new ArrayList<ArrayNode>();
        ArrayList<ValueNode> valueNodes = new ArrayList<ValueNode>();
        for (JsonNode jsonNode : processedSamples) {
            if (enumExtractionResults.stream().anyMatch(enumExtractionResult -> enumExtractionResult.contains(sample))) continue;
            if (jsonNode instanceof ObjectNode) {
                objectNodes.add((ObjectNode)jsonNode);
                continue;
            }
            if (jsonNode instanceof ArrayNode) {
                arrayNodes.add((ArrayNode)jsonNode);
                continue;
            }
            valueNodes.add((ValueNode)jsonNode);
        }
        HashSet<ObjectNode> anyOfs = new HashSet<ObjectNode>();
        enumExtractionResults.stream().map(enumExtractionResult -> this.enumExtractionResultToSchema((Collection<? extends JsonNode>)enumExtractionResult, path)).forEach(anyOfs::add);
        Optional.ofNullable(this.processObjects(objectNodes, path)).ifPresent(anyOfs::add);
        Optional.ofNullable(this.processArrays(arrayNodes, path)).ifPresent(anyOfs::add);
        anyOfs.addAll(this.processPrimitives(valueNodes, path));
        this.postProcessAnyOfs(anyOfs);
        return Collections.unmodifiableSet(anyOfs);
    }

    private void postProcessAnyOfs(@Nonnull Collection<ObjectNode> anyOfs) {
        HashSet<String> simpleTypes = new HashSet<String>();
        ArrayList<ObjectNode> simpleAnyOfs = new ArrayList<ObjectNode>();
        for (ObjectNode anyOf : anyOfs) {
            Set anyOfSchemaFieldNames = JunkDrawer.stream(anyOf.fieldNames()).collect(Collectors.toSet());
            if (!anyOfSchemaFieldNames.equals(Consts.Fields.SINGLETON_TYPE)) continue;
            simpleAnyOfs.add(anyOf);
            simpleTypes.add(anyOf.path("type").textValue());
        }
        if (simpleAnyOfs.size() <= 1) {
            return;
        }
        anyOfs.removeAll(simpleAnyOfs);
        ObjectNode combinedSimpleAnyOf = JunkDrawer.newObject();
        combinedSimpleAnyOf.set("type", (JsonNode)JunkDrawer.stringColToArrayDistinct(simpleTypes));
        anyOfs.add(combinedSimpleAnyOf);
    }

    @Nonnull
    String inferPrimitiveType(@Nonnull JsonNode sample, boolean allNumbersAreIntegers) {
        JsonNodeType type = sample.getNodeType();
        switch (type) {
            case STRING: 
            case BINARY: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                if (JunkDrawer.isTextualFloat(sample)) {
                    return "string";
                }
                return this.integerTypePreference.shouldUseInteger(() -> this.isInteger(sample), allNumbersAreIntegers) ? "integer" : "number";
            }
        }
        throw new IllegalStateException(JunkDrawer.format("Unexpected %s[%s] encountered with value[%s]", type.getClass().getSimpleName(), type, sample));
    }

    private boolean isInteger(@Nonnull JsonNode sample) {
        IntegerTypeCriterionInput input = new IntegerTypeCriterionInput(sample, this.specVersion);
        return this.integerTypeCriterion.isInteger(input);
    }

    private Collection<Collection<? extends JsonNode>> getEnumExtractionResults(@Nonnull Collection<? extends JsonNode> samples, @Nonnull String path) {
        EnumExtractorInput input = new EnumExtractorInput(samples, this.specVersion, path);
        Collection<Collection<? extends JsonNode>> enumExtractionResults = this.enumExtractor.extractEnums(input);
        return Objects.requireNonNull(enumExtractionResults);
    }

    private void handleDescriptionGeneration(@Nonnull ObjectNode schema, @Nullable String fieldName) {
        String comment;
        String description;
        TitleDescriptionGeneratorInput input = new TitleDescriptionGeneratorInput(fieldName, this.specVersion);
        String title = this.titleDescriptionGenerator.generateTitle(input);
        if (title != null) {
            schema.put("title", title);
        }
        if ((description = this.titleDescriptionGenerator.generateDescription(input)) != null) {
            schema.put("description", description);
        }
        if ((comment = this.titleDescriptionGenerator.generateComment(input)) != null) {
            schema.put("$comment", comment);
        }
    }

    @Nullable
    private String inferFormat(@Nonnull JsonNode sample, @Nonnull String path) {
        FormatInferrerInput input = new FormatInferrerInput(sample, this.specVersion, path);
        return this.formatInferrer.inferFormat(input);
    }

    private void processGenericSchemaFeature(@Nonnull ObjectNode schema, @Nonnull Collection<? extends JsonNode> samples, @Nullable String type, @Nonnull String path) {
        GenericSchemaFeatureInput input = new GenericSchemaFeatureInput(schema, samples, type, this.specVersion, path);
        ObjectNode featureResult = this.genericSchemaFeature.getFeatureResult(input);
        if (featureResult != null) {
            schema.setAll(featureResult);
        }
    }
}

