/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import java.util.Objects;

public final class GenericSchemaFeatures {
    private GenericSchemaFeatures() {
    }

    public static GenericSchemaFeature noOp() {
        return input -> null;
    }

    public static GenericSchemaFeature chained(GenericSchemaFeature ... features) {
        for (GenericSchemaFeature feature : features) {
            Objects.requireNonNull(feature);
        }
        switch (features.length) {
            case 0: {
                return GenericSchemaFeatures.noOp();
            }
            case 1: {
                return features[0];
            }
        }
        return input -> {
            ObjectNode result = JunkDrawer.newObject();
            for (GenericSchemaFeature feature : features) {
                ObjectNode featureResult = feature.getFeatureResult(input);
                if (featureResult == null) continue;
                result.setAll(featureResult);
            }
            return result.isEmpty() ? null : result;
        };
    }
}

