/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.saasquatch.jsonschemainferrer.FormatInferrer;
import com.saasquatch.jsonschemainferrer.FormatInferrerInput;
import com.saasquatch.jsonschemainferrer.SpecVersion;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

enum BuiltInFormatInferrer implements FormatInferrer
{
    NO_OP{

        @Override
        public String inferFormat(FormatInferrerInput input) {
            return null;
        }
    }
    ,
    DATE_TIME{

        @Override
        public String inferFormat(FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            try {
                ZonedDateTime.parse(textValue);
                return "date-time";
            }
            catch (Exception exception) {
                if (input.getSpecVersion().compareTo(SpecVersion.DRAFT_07) >= 0) {
                    try {
                        LocalDate.parse(textValue);
                        return "date";
                    }
                    catch (Exception exception2) {
                        try {
                            LocalTime.parse(textValue);
                            return "time";
                        }
                        catch (Exception exception3) {
                            try {
                                OffsetTime.parse(textValue);
                                return "time";
                            }
                            catch (Exception exception4) {
                                // empty catch block
                            }
                        }
                    }
                }
                return null;
            }
        }
    }
    ,
    EMAIL{

        @Override
        public String inferFormat(FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            if (EmailValidator.getInstance().isValid(textValue)) {
                return "email";
            }
            return null;
        }
    }
    ,
    IP{

        @Override
        public String inferFormat(FormatInferrerInput input) {
            String textValue = input.getSample().textValue();
            if (textValue == null) {
                return null;
            }
            if (InetAddressValidator.getInstance().isValidInet4Address(textValue)) {
                return "ipv4";
            }
            if (InetAddressValidator.getInstance().isValidInet6Address(textValue)) {
                return "ipv6";
            }
            return null;
        }
    };

}

