/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatureInput;
import com.saasquatch.jsonschemainferrer.JunkDrawer;

public enum StringLengthFeature implements GenericSchemaFeature
{
    MIN_LENGTH{

        @Override
        public ObjectNode getFeatureResult(GenericSchemaFeatureInput input) {
            if (!"string".equals(input.getType())) {
                return null;
            }
            ObjectNode result = JunkDrawer.newObject();
            input.getSamples().stream().mapToInt(j -> JunkDrawer.getSerializedTextLength(j)).min().ifPresent(minLength -> result.put("minLength", minLength));
            return result;
        }
    }
    ,
    MAX_LENGTH{

        @Override
        public ObjectNode getFeatureResult(GenericSchemaFeatureInput input) {
            if (!"string".equals(input.getType())) {
                return null;
            }
            ObjectNode result = JunkDrawer.newObject();
            input.getSamples().stream().mapToInt(j -> JunkDrawer.getSerializedTextLength(j)).max().ifPresent(maxLength -> result.put("maxLength", maxLength));
            return result;
        }
    };

}

