/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saasquatch.jsonschemainferrer.AdditionalPropertiesPolicy;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AdditionalPropertiesPolicies {
    private AdditionalPropertiesPolicies() {
    }

    public static AdditionalPropertiesPolicy noOp() {
        return input -> null;
    }

    public static AdditionalPropertiesPolicy allowed() {
        return input -> JsonNodeFactory.instance.booleanNode(true);
    }

    public static AdditionalPropertiesPolicy notAllowed() {
        return input -> JsonNodeFactory.instance.booleanNode(false);
    }

    public static AdditionalPropertiesPolicy existingTypes() {
        return input -> {
            ObjectNode schema = input.getSchema();
            Set<String> existingTypes = JunkDrawer.stream(schema.path("properties")).map(j -> j.path("type")).flatMap(typeNode -> {
                if (typeNode.isTextual()) {
                    return Stream.of(typeNode.textValue());
                }
                if (typeNode.isArray()) {
                    return JunkDrawer.stream(typeNode).map(JsonNode::textValue).filter(Objects::nonNull);
                }
                return Stream.empty();
            }).collect(Collectors.toSet());
            switch (existingTypes.size()) {
                case 0: {
                    return JsonNodeFactory.instance.booleanNode(false);
                }
                case 1: {
                    return JunkDrawer.newObject().put("type", (String)existingTypes.iterator().next());
                }
            }
            ObjectNode additionalProps = JunkDrawer.newObject();
            additionalProps.set("type", (JsonNode)JunkDrawer.stringColToArrayDistinct(existingTypes));
            return additionalProps;
        };
    }
}

