/*
 * Decompiled with CFR 0.152.
 */
package com.kryptoprefs.preferences.key;

import android.annotation.TargetApi;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import com.kryptoprefs.preferences.key.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kryptoprefs/preferences/key/KeyStoreKey;", "Lcom/kryptoprefs/preferences/key/Key;", "alias", "", "mode", "padding", "userAuthenticationRequired", "", "userAuthenticationTimeout", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", "key", "Ljava/security/Key;", "keyStore", "Ljava/security/KeyStore;", "kotlin.jvm.PlatformType", "createKey", "get", "tag", "Companion", "kryptoprefs_release"})
@TargetApi(value=23)
public final class KeyStoreKey
implements Key {
    private final KeyStore keyStore;
    private final java.security.Key key;
    private final String alias;
    private final String mode;
    private final String padding;
    private final boolean userAuthenticationRequired;
    private final int userAuthenticationTimeout;
    private static final String STORETYPE = "AndroidKeyStore";
    private static final int KEY_SIZE = 256;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public java.security.Key get() {
        return this.key;
    }

    @Override
    @NotNull
    public String tag() {
        return STORETYPE;
    }

    private final java.security.Key createKey() {
        if (!this.keyStore.containsAlias(this.alias)) {
            KeyGenerator generator = KeyGenerator.getInstance("AES", STORETYPE);
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.alias, 3).setBlockModes(new String[]{this.mode}).setEncryptionPaddings(new String[]{this.padding}).setKeySize(256);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"KeyGenParameterSpec.Buil\u2026    .setKeySize(KEY_SIZE)");
            KeyGenParameterSpec.Builder builder2 = builder;
            if (this.userAuthenticationRequired) {
                builder2.setUserAuthenticationRequired(this.userAuthenticationRequired);
                builder2.setUserAuthenticationValidityDurationSeconds(this.userAuthenticationTimeout);
            }
            generator.init((AlgorithmParameterSpec)builder2.build());
            generator.generateKey();
        }
        java.security.Key key = this.keyStore.getKey(this.alias, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"keyStore.getKey(alias, null)");
        return key;
    }

    public KeyStoreKey(@NotNull String alias, @NotNull String mode, @NotNull String padding, boolean userAuthenticationRequired, int userAuthenticationTimeout) {
        KeyStore keyStore;
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)padding, (String)"padding");
        this.alias = alias;
        this.mode = mode;
        this.padding = padding;
        this.userAuthenticationRequired = userAuthenticationRequired;
        this.userAuthenticationTimeout = userAuthenticationTimeout;
        KeyStore keyStore2 = KeyStore.getInstance(STORETYPE);
        KeyStoreKey keyStoreKey = this;
        boolean bl = false;
        boolean bl2 = false;
        KeyStore $this$apply = keyStore2;
        boolean bl3 = false;
        $this$apply.load(null);
        keyStoreKey.keyStore = keyStore = keyStore2;
        this.key = this.createKey();
        if (Build.VERSION.SDK_INT < 23) {
            throw (Throwable)new RuntimeException("Android M Needed.");
        }
    }

    public /* synthetic */ KeyStoreKey(String string, String string2, String string3, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(string, string2, string3, bl, n);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/kryptoprefs/preferences/key/KeyStoreKey$Companion;", "", "()V", "KEY_SIZE", "", "STORETYPE", "", "kryptoprefs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

