/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.navigationmanager;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.design.widget.NavigationView;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.widget.DrawerLayout;
import android.view.MenuItem;
import android.view.View;

public abstract class NavigationManager
implements NavigationView.OnNavigationItemSelectedListener,
DrawerLayout.DrawerListener {
    public static final String NAVIGATE_ID = "navigate_id";
    public static final String CURRENT_ID = "current_id";
    public static final String CURRENT_TITLE = "current_title";
    public static final String ACTION_MODE_SUSPENDED = "action_mode_state";
    public static final String ACTION_MODE_ACTIVE = "action_mode_active";
    private NavigationView mNavigationView;
    private DrawerLayout mDrawerLayout;
    private NavigationListener mNavigationListener;
    private ActionModeListener mActionModeListener;
    private FragmentTransaction mFragmentTransaction;
    private FragmentManager mFragmentManager;
    private Intent mIntent;
    private Fragment mCurrentFragment;
    private int mContainerId;
    private int mCurrentId;
    private String mTitle;

    public NavigationManager(FragmentManager fragmentManager, NavigationView navigationView, DrawerLayout drawerLayout, @IdRes int containerId) {
        this.mFragmentManager = fragmentManager;
        this.mNavigationView = navigationView;
        this.mDrawerLayout = drawerLayout;
        this.mContainerId = containerId;
        this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this);
        this.mNavigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
    }

    public void init(Bundle savedInstanceState, Intent intent) {
        if (savedInstanceState != null) {
            this.mCurrentId = savedInstanceState.getInt(CURRENT_ID);
            this.mTitle = savedInstanceState.getString(CURRENT_TITLE);
            this.mCurrentFragment = this.mFragmentManager.findFragmentByTag(CURRENT_TITLE);
        } else {
            this.mIntent = intent;
            if (this.mIntent == null) {
                this.navigate(this.getDefaultItem());
            } else {
                Bundle args = this.mIntent.getExtras();
                if (args != null) {
                    int menuId = args.getInt(NAVIGATE_ID);
                    MenuItem item = this.mNavigationView.getMenu().findItem(menuId);
                    if (item != null && menuId != 0) {
                        this.onNavigationItemSelected(item);
                    } else {
                        this.navigate(this.getDefaultItem());
                    }
                } else {
                    this.navigate(this.getDefaultItem());
                }
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(CURRENT_ID, this.mCurrentId);
        outState.putString(CURRENT_TITLE, this.mTitle);
    }

    public boolean shouldDelayTransaction(int item) {
        return true;
    }

    public abstract int getDefaultItem();

    @NonNull
    public abstract Fragment createFragment(@IdRes int var1);

    public void navigateWithIntent(Intent intent) {
        Bundle args;
        this.mIntent = intent;
        if (this.mIntent != null && (args = this.mIntent.getExtras()) != null) {
            int menuId = args.getInt(NAVIGATE_ID);
            this.navigate(menuId);
        }
    }

    public void navigate(@IdRes int menuId) {
        MenuItem newItem;
        if (this.mCurrentId != menuId && (newItem = this.mNavigationView.getMenu().findItem(menuId)) != null) {
            MenuItem lastItem = this.mNavigationView.getMenu().findItem(this.mCurrentId);
            if (lastItem != null) {
                lastItem.setChecked(false);
            }
            this.onNavigationItemSelected(newItem);
        }
    }

    public boolean onNavigationItemSelected(MenuItem item) {
        boolean firstStart;
        if (this.mNavigationListener != null) {
            this.mNavigationListener.onItemSelected(item);
        }
        this.closeDrawer();
        boolean bl = firstStart = this.mCurrentId == 0;
        if (item.getItemId() == this.mCurrentId) {
            return false;
        }
        this.mCurrentId = item.getItemId();
        this.mTitle = item.getTitle().toString();
        if (item.isCheckable()) {
            this.mNavigationView.setCheckedItem(this.mCurrentId);
            if (this.mNavigationListener != null && this.mCurrentFragment != null) {
                this.mNavigationListener.onSectionChange(this.mCurrentFragment);
            }
            this.mCurrentFragment = this.createFragment(item.getItemId());
            if (this.mIntent != null) {
                Bundle args = this.mCurrentFragment.getArguments();
                Bundle extras = this.mIntent.getExtras();
                if (args == null) {
                    args = new Bundle();
                }
                if (extras != null) {
                    args.putAll(extras);
                }
                this.mCurrentFragment.setArguments(args);
                this.mIntent = null;
            }
            if (!this.shouldDelayTransaction(this.mCurrentId) || firstStart) {
                this.commitFragmentTransaction(this.createFragmentTransaction(this.mCurrentFragment));
            } else {
                this.mDrawerLayout.setDrawerLockMode(1);
                this.mFragmentTransaction = this.createFragmentTransaction(this.mCurrentFragment);
            }
            return true;
        }
        return false;
    }

    public void onDrawerSlide(View drawerView, float slideOffset) {
        if (slideOffset == 0.0f) {
            this.onDrawerClosed(drawerView);
        } else {
            this.onDrawerOpened(drawerView);
        }
    }

    public void onDrawerOpened(View drawerView) {
        ActionModeListener fragCallbacks;
        if (this.mActionModeListener != null && this.mActionModeListener.isActionModeActive()) {
            this.mActionModeListener.onSuspendActionMode();
        }
        if (this.mCurrentFragment instanceof ActionModeListener && (fragCallbacks = (ActionModeListener)this.mCurrentFragment).isActionModeActive()) {
            fragCallbacks.onSuspendActionMode();
        }
    }

    public void onDrawerClosed(View drawerView) {
        ActionModeListener fragCallbacks;
        if (this.mActionModeListener != null && this.mActionModeListener.isActionModeSuspended()) {
            this.mActionModeListener.onResumeActionMode();
        }
        if (this.mCurrentFragment instanceof ActionModeListener && (fragCallbacks = (ActionModeListener)this.mCurrentFragment).isActionModeSuspended()) {
            fragCallbacks.onResumeActionMode();
        }
        if (this.mFragmentTransaction != null && this.shouldDelayTransaction(this.mCurrentId)) {
            this.commitFragmentTransaction(this.mFragmentTransaction);
            this.mFragmentTransaction = null;
            this.mDrawerLayout.setDrawerLockMode(0);
        }
    }

    public void onDrawerStateChanged(int newState) {
    }

    public Fragment getCurrentFragment() {
        return this.mCurrentFragment;
    }

    public int getCurrentId() {
        return this.mCurrentId;
    }

    public String getCurrentTitle() {
        return this.mTitle;
    }

    public void setActionModeListener(ActionModeListener actionModeListener) {
        this.mActionModeListener = actionModeListener;
    }

    public void setNavigationListener(NavigationListener navigationListener) {
        this.mNavigationListener = navigationListener;
    }

    @SuppressLint(value={"CommitTransaction"})
    public FragmentTransaction createFragmentTransaction(Fragment fragment) {
        return this.mFragmentManager.beginTransaction().replace(this.mContainerId, fragment, CURRENT_TITLE);
    }

    public void commitFragmentTransaction(FragmentTransaction transaction) {
        transaction.commitAllowingStateLoss();
    }

    public boolean openDrawer() {
        if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
            return false;
        }
        this.mDrawerLayout.openDrawer(0x800003);
        return true;
    }

    public boolean closeDrawer() {
        if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
            this.mDrawerLayout.closeDrawer(0x800003);
            return true;
        }
        return false;
    }

    public static void saveActionModeState(Bundle outState, ActionModeListener callbacks) {
        outState.putBoolean(ACTION_MODE_SUSPENDED, callbacks.isActionModeSuspended());
        outState.putBoolean(ACTION_MODE_ACTIVE, callbacks.isActionModeActive());
    }

    public static Intent createNavigationIntent(@IdRes int res) {
        Intent intent = new Intent();
        intent.putExtra(NAVIGATE_ID, res);
        return intent;
    }

    public static interface ActionModeListener {
        public void onSuspendActionMode();

        public void onResumeActionMode();

        public boolean isActionModeActive();

        public boolean isActionModeSuspended();
    }

    public static interface NavigationListener {
        public void onItemSelected(MenuItem var1);

        public void onSectionChange(Fragment var1);
    }
}

