/*
 * Decompiled with CFR 0.152.
 */
package gopher.impl;

import cps.CpsAsyncMonad;
import gopher.JVMGopher;
import gopher.impl.Expirable;
import gopher.impl.Expirable$Capture$;
import gopher.impl.Expirable$Capture$Ready$;
import gopher.impl.GuardedSPSCBaseChannel;
import gopher.impl.Reader;
import gopher.impl.SPSCBuffer;
import gopher.impl.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.util.Success$;

public class GuardedSPSCBufferedChannel<F, A>
extends GuardedSPSCBaseChannel<F, A> {
    public final int gopher$impl$GuardedSPSCBufferedChannel$$bufSize;
    private final ExecutorService taskExecutor;
    private final SPSCBuffer state;

    public GuardedSPSCBufferedChannel(JVMGopher<F> gopherApi, int bufSize, ExecutorService controlExecutor, ExecutorService taskExecutor, CpsAsyncMonad<F> evidence$1) {
        this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize = bufSize;
        this.taskExecutor = taskExecutor;
        super(gopherApi, controlExecutor, taskExecutor, evidence$1);
        this.state = new RingBuffer();
    }

    public SPSCBuffer<A> state() {
        return this.state;
    }

    @Override
    public void step() {
        this.state().local();
        boolean isClosed = this.publishedClosed().get();
        boolean progress = true;
        while (progress) {
            progress = false;
            if (!this.state().isEmpty()) {
                progress |= this.processReadsStep();
            } else if (isClosed) {
                progress |= this.processDoneClose();
                if (this.writers().isEmpty()) {
                    progress |= this.processReadClose();
                }
            }
            if (!this.state().isFull()) {
                progress |= this.processWriteStep();
            }
            if (progress) continue;
            this.state().publish();
            if (this.checkLeaveStep()) continue;
            progress = true;
            isClosed = this.publishedClosed().get();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processReadsStep() {
        void var3_3;
        Object a = this.state().startRead();
        boolean done = false;
        boolean progress = false;
        Queue nonExpiredBusyReads = Queue$.MODULE$.empty();
        while (!done && !this.readers().isEmpty()) {
            Reader reader = this.readers().poll();
            if (reader == null || reader.isExpired()) continue;
            Expirable.Capture capture = reader.capture();
            if (capture instanceof Expirable.Capture.Ready) {
                Function1 function1;
                Expirable.Capture.Ready ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture);
                Function1 f = function1 = (Function1)ready._1();
                this.taskExecutor.execute(() -> f.apply((Object)Success$.MODULE$.apply(a)));
                reader.markUsed();
                this.state().finishRead();
                progress = true;
                done = true;
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                nonExpiredBusyReads = nonExpiredBusyReads.enqueue(reader);
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                progress = true;
                continue;
            }
            throw new MatchError(capture);
        }
        while (nonExpiredBusyReads.nonEmpty()) {
            progress = true;
            Tuple2 tuple2 = nonExpiredBusyReads.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Reader r = (Reader)tuple2._1();
            Queue c = (Queue)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)r, (Object)c);
            Reader r2 = (Reader)tuple22._1();
            Queue c2 = (Queue)tuple22._2();
            this.progressWaitReader(r2);
            nonExpiredBusyReads = c2;
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processWriteStep() {
        void var1_1;
        boolean progress = false;
        boolean done = false;
        Queue nonExpiredBusyWriters = Queue$.MODULE$.empty();
        while (!done && !this.writers().isEmpty()) {
            Expirable.Capture.Ready ready;
            Tuple2 tuple2;
            Writer writer = this.writers().poll();
            if (writer == null || writer.isExpired()) continue;
            Expirable.Capture capture = writer.capture();
            if (capture instanceof Expirable.Capture.Ready && (tuple2 = (Tuple2)(ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture))._1()) != null) {
                Object a = tuple2._1();
                Function1 f = (Function1)tuple2._2();
                done = true;
                if (this.state().write(a)) {
                    this.taskExecutor.execute(() -> f.apply((Object)Success$.MODULE$.apply((Object)BoxedUnit.UNIT)));
                    progress = true;
                    writer.markUsed();
                    continue;
                }
                writer.markFree();
                this.writers().addFirst(writer);
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                nonExpiredBusyWriters = nonExpiredBusyWriters.enqueue(writer);
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                progress = true;
                continue;
            }
            throw new MatchError(capture);
        }
        while (nonExpiredBusyWriters.nonEmpty()) {
            Queue c;
            progress = true;
            Tuple2 tuple2 = nonExpiredBusyWriters.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Writer w = (Writer)tuple2._1();
            Queue c2 = (Queue)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)w, (Object)c2);
            Writer w2 = (Writer)tuple22._1();
            nonExpiredBusyWriters = c = (Queue)tuple22._2();
            this.progressWaitWriter(w2);
        }
        return (boolean)var1_1;
    }

    public class RingBuffer
    implements SPSCBuffer<A> {
        private final AtomicReferenceArray refs;
        private final AtomicInteger publishedStart;
        private final AtomicInteger publishedSize;
        private int start;
        private int size;

        public RingBuffer() {
            if (GuardedSPSCBufferedChannel.this == null) {
                throw new NullPointerException();
            }
            this.refs = new AtomicReferenceArray(GuardedSPSCBufferedChannel.this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize);
            this.publishedStart = new AtomicInteger(0);
            this.publishedSize = new AtomicInteger(0);
            this.start = 0;
            this.size = 0;
        }

        public AtomicReferenceArray<Object> refs() {
            return this.refs;
        }

        public AtomicInteger publishedStart() {
            return this.publishedStart;
        }

        public AtomicInteger publishedSize() {
            return this.publishedSize;
        }

        public int start() {
            return this.start;
        }

        public void start_$eq(int x$1) {
            this.start = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        @Override
        public void local() {
            this.start_$eq(this.publishedStart().get());
            this.size_$eq(this.publishedSize().get());
        }

        @Override
        public void publish() {
            this.publishedStart().set(this.start());
            this.publishedSize().set(this.size());
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean isFull() {
            return this.size() == GuardedSPSCBufferedChannel.this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize;
        }

        @Override
        public A startRead() {
            Object aRef = this.refs().get(this.start());
            return Scala3RunTime$.MODULE$.nn(aRef);
        }

        @Override
        public boolean finishRead() {
            boolean bl;
            if (this.size() > 0) {
                this.start_$eq((this.start() + 1) % GuardedSPSCBufferedChannel.this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize);
                this.size_$eq(this.size() - 1);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean write(A a) {
            boolean bl;
            if (this.size() < GuardedSPSCBufferedChannel.this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize) {
                int end = (this.start() + this.size()) % GuardedSPSCBufferedChannel.this.gopher$impl$GuardedSPSCBufferedChannel$$bufSize;
                Object aRef = a;
                this.refs().lazySet(end, aRef);
                this.size_$eq(this.size() + 1);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public final /* synthetic */ GuardedSPSCBufferedChannel gopher$impl$GuardedSPSCBufferedChannel$RingBuffer$$$outer() {
            return GuardedSPSCBufferedChannel.this;
        }
    }
}

