/*
 * Decompiled with CFR 0.152.
 */
package gopher;

import cps.CpsAsyncMonad;
import gopher.Gopher;
import gopher.WriteChannel;
import gopher.impl.NesteWriterWithExpireTime;
import gopher.impl.NestedWriterWithExpireTimeThrowing;
import gopher.impl.SimpleWriter;
import gopher.impl.SimpleWriterWithExpireTime;
import gopher.impl.Writer;
import java.io.Serializable;
import scala.Function1;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public class WriteChannelWithExpiration<F, A>
implements WriteChannel<F, A> {
    private final WriteChannel<F, A> internal;
    private final FiniteDuration ttl;
    private final boolean throwTimeouts;
    private final Gopher<F> gopherApi;

    public WriteChannelWithExpiration(WriteChannel<F, A> internal, FiniteDuration ttl, boolean throwTimeouts, Gopher<F> gopherApi) {
        this.internal = internal;
        this.ttl = ttl;
        this.throwTimeouts = throwTimeouts;
        this.gopherApi = gopherApi;
    }

    @Override
    public F awrite(A a) {
        long expireTime = System.currentTimeMillis() + this.ttl.toMillis();
        return (F)this.asyncMonad().adoptCallbackStyle((Function1)(JProcedure1 & Serializable)f -> this.internal.addWriter(this.makeExpirableWriter(a, (Function1<Try<BoxedUnit>, BoxedUnit>)f, expireTime)));
    }

    @Override
    public void addWriter(Writer<A> writer) {
        long expireTime = System.currentTimeMillis() + this.ttl.toMillis();
        this.internal.addWriter(this.wrapExpirable(writer, expireTime));
    }

    @Override
    public CpsAsyncMonad<F> asyncMonad() {
        return this.internal.asyncMonad();
    }

    @Override
    public WriteChannelWithExpiration<F, A> withWriteExpiration(FiniteDuration ttl, boolean throwTimeouts, Gopher<F> gopherApi) {
        return new WriteChannelWithExpiration<F, A>(this.internal, ttl, throwTimeouts, gopherApi);
    }

    private Writer<A> wrapExpirable(Writer<A> nested, long expireTimeMillis) {
        return this.throwTimeouts ? new NestedWriterWithExpireTimeThrowing<F, A>(nested, expireTimeMillis, this.gopherApi) : new NesteWriterWithExpireTime<A>(nested, expireTimeMillis);
    }

    private Writer<A> makeExpirableWriter(A a, Function1<Try<BoxedUnit>, BoxedUnit> f, long expireTimeMillis) {
        return this.throwTimeouts ? new NestedWriterWithExpireTimeThrowing<F, A>(new SimpleWriter<A>(a, f), expireTimeMillis, this.gopherApi) : new SimpleWriterWithExpireTime<A>(a, f, expireTimeMillis);
    }
}

