/*
 * Decompiled with CFR 0.152.
 */
package gopher.impl;

import gopher.Gopher;
import gopher.Time;
import gopher.impl.Writer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure$;
import scala.util.Try;

public class NestedWriterWithExpireTimeThrowing<F, A>
implements Writer<A> {
    private final Writer<A> nested;
    private final long expireTimeMillis;
    private final Gopher<F> gopherApi;
    private final Time.Scheduled scheduledThrow;

    public <F, A> NestedWriterWithExpireTimeThrowing(Writer<A> nested, long expireTimeMillis, Gopher<F> gopherApi) {
        this.nested = nested;
        this.expireTimeMillis = expireTimeMillis;
        this.gopherApi = gopherApi;
        this.scheduledThrow = gopherApi.time().schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkExpire(), FiniteDuration$.MODULE$.apply(expireTimeMillis - gopherApi.time().now().toMillis(), TimeUnit.MILLISECONDS));
    }

    public Time.Scheduled scheduledThrow() {
        return this.scheduledThrow;
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired() {
        return this.gopherApi.time().now().toMillis() >= this.expireTimeMillis || this.nested.isExpired();
    }

    @Override
    public Option<Tuple2<A, Function1<Try<BoxedUnit>, BoxedUnit>>> capture() {
        return this.nested.capture();
    }

    @Override
    public void markUsed() {
        this.scheduledThrow().cancel();
        this.nested.markUsed();
    }

    @Override
    public void markFree() {
        this.nested.markFree();
        this.checkExpire();
    }

    public void checkExpire() {
        if (this.gopherApi.time().now().toMillis() > this.expireTimeMillis && !this.nested.isExpired()) {
            Tuple2 tuple2;
            Option option = this.nested.capture();
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Object a = tuple2._1();
                Function1 f = (Function1)tuple2._2();
                this.nested.markUsed();
                try {
                    f.apply((Object)Failure$.MODULE$.apply((Throwable)new TimeoutException()));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
    }
}

