/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.ThinWormAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.drawer.type.WormDrawer;

public class ThinWormDrawer
extends WormDrawer {
    public ThinWormDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    @Override
    public void draw(@NonNull Canvas canvas, @NonNull Value value, int coordinateX, int coordinateY) {
        if (!(value instanceof ThinWormAnimationValue)) {
            return;
        }
        ThinWormAnimationValue v = (ThinWormAnimationValue)value;
        int rectStart = v.getRectStart();
        int rectEnd = v.getRectEnd();
        int height = v.getHeight() / 2;
        int radius = this.indicator.getRadius();
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedColor = this.indicator.getSelectedColor();
        if (this.indicator.getOrientation() == Orientation.HORIZONTAL) {
            this.rect.left = rectStart;
            this.rect.right = rectEnd;
            this.rect.top = coordinateY - height;
            this.rect.bottom = coordinateY + height;
        } else {
            this.rect.left = coordinateX - height;
            this.rect.right = coordinateX + height;
            this.rect.top = rectStart;
            this.rect.bottom = rectEnd;
        }
        this.paint.setColor(unselectedColor);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, (float)radius, this.paint);
        this.paint.setColor(selectedColor);
        canvas.drawRoundRect(this.rect, (float)radius, (float)radius, this.paint);
    }
}

