/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.SlideAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.data.Orientation;
import com.rd.draw.drawer.type.BaseDrawer;

public class SlideDrawer
extends BaseDrawer {
    public SlideDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int coordinateX, int coordinateY) {
        if (!(value instanceof SlideAnimationValue)) {
            return;
        }
        SlideAnimationValue v = (SlideAnimationValue)value;
        int coordinate = v.getCoordinate();
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedColor = this.indicator.getSelectedColor();
        int radius = this.indicator.getRadius();
        this.paint.setColor(unselectedColor);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, (float)radius, this.paint);
        this.paint.setColor(selectedColor);
        if (this.indicator.getOrientation() == Orientation.HORIZONTAL) {
            canvas.drawCircle((float)coordinate, (float)coordinateY, (float)radius, this.paint);
        } else {
            canvas.drawCircle((float)coordinateX, (float)coordinate, (float)radius, this.paint);
        }
    }
}

